/*
 * Decompiled with CFR 0.152.
 */
package com.kitfox.svg;

import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGElementException;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGLoaderHelper;
import com.kitfox.svg.SVGParseException;
import com.kitfox.svg.SVGRoot;
import com.kitfox.svg.pathcmd.Arc;
import com.kitfox.svg.pathcmd.BuildHistory;
import com.kitfox.svg.pathcmd.Cubic;
import com.kitfox.svg.pathcmd.CubicSmooth;
import com.kitfox.svg.pathcmd.Horizontal;
import com.kitfox.svg.pathcmd.LineTo;
import com.kitfox.svg.pathcmd.MoveTo;
import com.kitfox.svg.pathcmd.PathCommand;
import com.kitfox.svg.pathcmd.Quadratic;
import com.kitfox.svg.pathcmd.QuadraticSmooth;
import com.kitfox.svg.pathcmd.Terminal;
import com.kitfox.svg.pathcmd.Vertical;
import com.kitfox.svg.xml.StyleAttribute;
import com.kitfox.svg.xml.StyleSheet;
import com.kitfox.svg.xml.XMLParseUtil;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class SVGElement
implements Serializable {
    public static final long serialVersionUID = 0L;
    public static final String SVG_NS = "http://www.w3.org/2000/svg";
    protected SVGElement parent = null;
    protected final ArrayList<SVGElement> children = new ArrayList();
    protected String id = null;
    protected String cssClass = null;
    protected final HashMap<String, StyleAttribute> inlineStyles = new HashMap();
    protected final HashMap<String, StyleAttribute> presAttribs = new HashMap();
    protected static final Set<String> ignorePresAttrib;
    protected URI xmlBase = null;
    protected SVGDiagram diagram;
    boolean dirty = true;
    LinkedList<SVGElement> contexts = new LinkedList();

    public SVGElement() {
        this(null, null, null);
    }

    public SVGElement(String string, SVGElement sVGElement) {
        this(string, null, sVGElement);
    }

    public SVGElement(String string, String string2, SVGElement sVGElement) {
        this.id = string;
        this.cssClass = string2;
        this.parent = sVGElement;
    }

    public abstract String getTagName();

    public SVGElement getParent() {
        return this.parent;
    }

    void setParent(SVGElement sVGElement) {
        this.parent = sVGElement;
    }

    public List<SVGElement> getPath(List<SVGElement> list) {
        if (list == null) {
            list = new ArrayList<SVGElement>();
        }
        if (this.parent != null) {
            this.parent.getPath(list);
        }
        list.add(this);
        return list;
    }

    public List<SVGElement> getChildren(List<SVGElement> list) {
        if (list == null) {
            list = new ArrayList<SVGElement>();
        }
        list.addAll(this.children);
        return list;
    }

    public SVGElement getChild(String string) {
        for (SVGElement sVGElement : this.children) {
            String string2 = sVGElement.getId();
            if (string2 == null || !string2.equals(string)) continue;
            return sVGElement;
        }
        return null;
    }

    public int indexOfChild(SVGElement sVGElement) {
        return this.children.indexOf(sVGElement);
    }

    public void swapChildren(int n, int n2) throws SVGException {
        if (this.children == null || n < 0 || n >= this.children.size() || n2 < 0 || n2 >= this.children.size()) {
            return;
        }
        SVGElement sVGElement = this.children.get(n);
        this.children.set(n, this.children.get(n2));
        this.children.set(n2, sVGElement);
        this.build();
    }

    public void loaderStartElement(SVGLoaderHelper sVGLoaderHelper, Attributes attributes, SVGElement sVGElement) throws SAXException {
        Object object;
        String string;
        this.parent = sVGElement;
        this.diagram = sVGLoaderHelper.diagram;
        this.id = attributes.getValue("id");
        if (this.id != null && !this.id.equals("")) {
            this.diagram.setElement(this.id, this);
        }
        this.cssClass = (string = attributes.getValue("class")) == null || string.equals("") ? null : string;
        String string2 = attributes.getValue("style");
        if (string2 != null) {
            object = XMLParseUtil.parseStyle(string2, this.inlineStyles);
        }
        if ((object = attributes.getValue("xml:base")) != null && !((String)object).equals("")) {
            try {
                this.xmlBase = new URI((String)object);
            }
            catch (Exception exception) {
                throw new SAXException(exception);
            }
        }
        int n = attributes.getLength();
        for (int i = 0; i < n; ++i) {
            String string3 = attributes.getQName(i);
            if (ignorePresAttrib.contains(string3)) continue;
            String string4 = attributes.getValue(i);
            this.presAttribs.put(string3, new StyleAttribute(string3, string4));
        }
    }

    public Set<String> getInlineAttributes() {
        return this.inlineStyles.keySet();
    }

    public Set<String> getPresentationAttributes() {
        return this.presAttribs.keySet();
    }

    public void loaderAddChild(SVGLoaderHelper sVGLoaderHelper, SVGElement sVGElement) throws SVGElementException {
        this.children.add(sVGElement);
        sVGElement.parent = this;
        sVGElement.setDiagram(this.diagram);
    }

    protected void setDiagram(SVGDiagram sVGDiagram) {
        this.diagram = sVGDiagram;
        sVGDiagram.setElement(this.id, this);
        for (SVGElement sVGElement : this.children) {
            sVGElement.setDiagram(sVGDiagram);
        }
    }

    public void removeChild(SVGElement sVGElement) throws SVGElementException {
        if (!this.children.contains(sVGElement)) {
            throw new SVGElementException(this, "Element does not contain child " + sVGElement);
        }
        this.children.remove(sVGElement);
    }

    public void loaderAddText(SVGLoaderHelper sVGLoaderHelper, String string) {
    }

    public void loaderEndElement(SVGLoaderHelper sVGLoaderHelper) throws SVGParseException {
    }

    protected void build() throws SVGException {
        String string;
        StyleAttribute styleAttribute = new StyleAttribute();
        if (this.getPres(styleAttribute.setName("id")) && !(string = styleAttribute.getStringValue()).equals(this.id)) {
            this.diagram.removeElement(this.id);
            this.id = string;
            this.diagram.setElement(this.id, this);
        }
        if (this.getPres(styleAttribute.setName("class"))) {
            this.cssClass = styleAttribute.getStringValue();
        }
        if (this.getPres(styleAttribute.setName("xml:base"))) {
            this.xmlBase = styleAttribute.getURIValue();
        }
        for (int i = 0; i < this.children.size(); ++i) {
            SVGElement sVGElement = this.children.get(i);
            sVGElement.build();
        }
    }

    public URI getXMLBase() {
        return this.xmlBase != null ? this.xmlBase : (this.parent != null ? this.parent.getXMLBase() : this.diagram.getXMLBase());
    }

    public String getId() {
        return this.id;
    }

    protected void pushParentContext(SVGElement sVGElement) {
        this.contexts.addLast(sVGElement);
    }

    protected SVGElement popParentContext() {
        return this.contexts.removeLast();
    }

    protected SVGElement getParentContext() {
        return this.contexts.isEmpty() ? null : this.contexts.getLast();
    }

    public SVGRoot getRoot() {
        return this.parent == null ? null : this.parent.getRoot();
    }

    public boolean getStyle(StyleAttribute styleAttribute) throws SVGException {
        return this.getStyle(styleAttribute, true);
    }

    public boolean getStyle(StyleAttribute styleAttribute, boolean bl) throws SVGException {
        Object object;
        String string = styleAttribute.getName();
        StyleAttribute styleAttribute2 = this.inlineStyles.get(string);
        styleAttribute.setStringValue(styleAttribute2 == null ? "" : styleAttribute2.getStringValue());
        if (styleAttribute2 != null) {
            return true;
        }
        StyleAttribute styleAttribute3 = this.presAttribs.get(string);
        styleAttribute.setStringValue(styleAttribute3 == null ? "" : styleAttribute3.getStringValue());
        if (styleAttribute3 != null) {
            return true;
        }
        SVGRoot sVGRoot = this.getRoot();
        if (sVGRoot != null && (object = sVGRoot.getStyleSheet()) != null) {
            return ((StyleSheet)object).getStyle(styleAttribute, this.getTagName(), this.cssClass);
        }
        if (bl) {
            object = this.getParentContext();
            if (object != null) {
                return ((SVGElement)object).getStyle(styleAttribute, true);
            }
            if (this.parent != null) {
                return this.parent.getStyle(styleAttribute, true);
            }
        }
        return false;
    }

    public StyleAttribute getStyleAbsolute(String string) {
        return this.inlineStyles.get(string);
    }

    public boolean getPres(StyleAttribute styleAttribute) throws SVGException {
        String string = styleAttribute.getName();
        StyleAttribute styleAttribute2 = this.presAttribs.get(string);
        styleAttribute.setStringValue(styleAttribute2 == null ? "" : styleAttribute2.getStringValue());
        return styleAttribute2 != null;
    }

    public StyleAttribute getPresAbsolute(String string) {
        return this.presAttribs.get(string);
    }

    protected static AffineTransform parseTransform(String string) throws SVGException {
        Matcher matcher = Pattern.compile("\\w+\\([^)]*\\)").matcher("");
        AffineTransform affineTransform = new AffineTransform();
        matcher.reset(string);
        while (matcher.find()) {
            affineTransform.concatenate(SVGElement.parseSingleTransform(matcher.group()));
        }
        return affineTransform;
    }

    public static AffineTransform parseSingleTransform(String string) throws SVGException {
        Matcher matcher = Pattern.compile("([a-zA-Z]+|-?\\d+(\\.\\d+)?(e-?\\d+)?|-?\\.\\d+(e-?\\d+)?)").matcher("");
        AffineTransform affineTransform = new AffineTransform();
        matcher.reset(string);
        if (!matcher.find()) {
            return affineTransform;
        }
        String string2 = matcher.group().toLowerCase();
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            linkedList.add(matcher.group());
        }
        double[] dArray = new double[linkedList.size()];
        Iterator iterator = linkedList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            dArray[n++] = XMLParseUtil.parseDouble((String)iterator.next());
        }
        if (string2.equals("matrix")) {
            affineTransform.setTransform(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        } else if (string2.equals("translate")) {
            if (dArray.length == 1) {
                affineTransform.setToTranslation(dArray[0], 0.0);
            } else {
                affineTransform.setToTranslation(dArray[0], dArray[1]);
            }
        } else if (string2.equals("scale")) {
            if (dArray.length > 1) {
                affineTransform.setToScale(dArray[0], dArray[1]);
            } else {
                affineTransform.setToScale(dArray[0], dArray[0]);
            }
        } else if (string2.equals("rotate")) {
            if (dArray.length > 2) {
                affineTransform.setToRotation(Math.toRadians(dArray[0]), dArray[1], dArray[2]);
            } else {
                affineTransform.setToRotation(Math.toRadians(dArray[0]));
            }
        } else if (string2.equals("skewx")) {
            affineTransform.setToShear(Math.toRadians(dArray[0]), 0.0);
        } else if (string2.equals("skewy")) {
            affineTransform.setToShear(0.0, Math.toRadians(dArray[0]));
        } else {
            throw new SVGException("Unknown transform type");
        }
        return affineTransform;
    }

    protected static float nextFloat(LinkedList<String> linkedList) {
        String string = linkedList.removeFirst();
        return Float.parseFloat(string);
    }

    protected static PathCommand[] parsePathList(String string) {
        PathCommand[] pathCommandArray;
        Matcher matcher = Pattern.compile("([MmLlHhVvAaQqTtCcSsZz])|([-+]?((\\d*\\.\\d+)|(\\d+))([eE][-+]?\\d+)?)").matcher(string);
        LinkedList<String> linkedList = new LinkedList<String>();
        while (matcher.find()) {
            linkedList.addLast(matcher.group());
        }
        boolean bl = false;
        LinkedList<Terminal> linkedList2 = new LinkedList<Terminal>();
        int n = 90;
        while (linkedList.size() != 0) {
            pathCommandArray = (PathCommand[])linkedList.removeFirst();
            char c = pathCommandArray.charAt(0);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                n = c;
            } else {
                linkedList.addFirst((String)pathCommandArray);
            }
            PathCommand pathCommand = null;
            switch (n) {
                case 77: {
                    pathCommand = new MoveTo(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    n = 76;
                    break;
                }
                case 109: {
                    pathCommand = new MoveTo(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    n = 108;
                    break;
                }
                case 76: {
                    pathCommand = new LineTo(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 108: {
                    pathCommand = new LineTo(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 72: {
                    pathCommand = new Horizontal(false, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 104: {
                    pathCommand = new Horizontal(true, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 86: {
                    pathCommand = new Vertical(false, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 118: {
                    pathCommand = new Vertical(true, SVGElement.nextFloat(linkedList));
                    break;
                }
                case 65: {
                    pathCommand = new Arc(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 97: {
                    pathCommand = new Arc(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList) == 1.0f, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 81: {
                    pathCommand = new Quadratic(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 113: {
                    pathCommand = new Quadratic(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 84: {
                    pathCommand = new QuadraticSmooth(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 116: {
                    pathCommand = new QuadraticSmooth(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 67: {
                    pathCommand = new Cubic(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 99: {
                    pathCommand = new Cubic(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 83: {
                    pathCommand = new CubicSmooth(false, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 115: {
                    pathCommand = new CubicSmooth(true, SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList), SVGElement.nextFloat(linkedList));
                    break;
                }
                case 90: 
                case 122: {
                    pathCommand = new Terminal();
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid path element");
                }
            }
            linkedList2.add((Terminal)pathCommand);
            bl = pathCommand.isRelative;
        }
        pathCommandArray = new PathCommand[linkedList2.size()];
        linkedList2.toArray(pathCommandArray);
        return pathCommandArray;
    }

    protected static GeneralPath buildPath(String string, int n) {
        PathCommand[] pathCommandArray = SVGElement.parsePathList(string);
        int n2 = 2;
        for (int i = 0; i < pathCommandArray.length; ++i) {
            n2 += pathCommandArray[i].getNumKnotsAdded();
        }
        GeneralPath generalPath = new GeneralPath(n, n2);
        BuildHistory buildHistory = new BuildHistory();
        for (int i = 0; i < pathCommandArray.length; ++i) {
            PathCommand pathCommand = pathCommandArray[i];
            pathCommand.appendPath(generalPath, buildHistory);
        }
        return generalPath;
    }

    public abstract boolean updateTime(double var1) throws SVGException;

    public int getNumChildren() {
        return this.children.size();
    }

    public SVGElement getChild(int n) {
        return this.children.get(n);
    }

    public double lerp(double d, double d2, double d3) {
        return (1.0 - d3) * d + d3 * d2;
    }

    static {
        HashSet hashSet = new HashSet();
        ignorePresAttrib = Collections.unmodifiableSet(hashSet);
    }
}

