/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.mapmode;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.RotateCommand;
import org.openstreetmap.josm.command.ScaleCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WaySegment;
import org.openstreetmap.josm.data.osm.visitor.AllNodesVisitor;
import org.openstreetmap.josm.data.osm.visitor.paint.WireframeMapRenderer;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.MapViewState;
import org.openstreetmap.josm.gui.SelectionManager;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.util.KeyPressReleaseListener;
import org.openstreetmap.josm.gui.util.ModifierListener;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class SelectAction
extends MapMode
implements ModifierListener,
KeyPressReleaseListener,
SelectionManager.SelectionEnded {
    private boolean lassoMode;
    public boolean repeatedKeySwitchLassoOption;
    private MouseEvent oldEvent;
    private Mode mode;
    private final transient SelectionManager selectionManager;
    private boolean cancelDrawMode;
    private boolean drawTargetHighlight;
    private boolean didMouseDrag;
    private final MapView mv;
    private Point startingDraggingPos;
    private EastNorth startEN;
    private Point lastMousePos;
    private long mouseDownTime;
    private int mouseDownButton;
    private long mouseReleaseTime;
    private int initialMoveDelay;
    private int initialMoveThreshold;
    private boolean initialMoveThresholdExceeded;
    private transient Set<OsmPrimitive> oldHighlights = new HashSet<OsmPrimitive>();
    private final transient CycleManager cycleManager = new CycleManager();
    private final transient VirtualManager virtualManager = new VirtualManager();

    public SelectAction(MapFrame mapFrame) {
        super(I18n.tr("Select", new Object[0]), "move/move", I18n.tr("Select, move, scale and rotate objects", new Object[0]), Shortcut.registerShortcut("mapmode:select", I18n.tr("Mode: {0}", I18n.tr("Select", new Object[0])), 83, 5003), mapFrame, ImageProvider.getCursor("normal", "selection"));
        this.mv = mapFrame.mapView;
        this.putValue("help", HelpUtil.ht("/Action/Select"));
        this.selectionManager = new SelectionManager(this, false, this.mv);
    }

    @Override
    public void enterMode() {
        super.enterMode();
        this.mv.addMouseListener(this);
        this.mv.addMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(Main.pref.getInteger("mappaint.node.virtual-size", 8) != 0);
        this.drawTargetHighlight = Main.pref.getBoolean("draw.target-highlight", true);
        this.initialMoveDelay = Main.pref.getInteger("edit.initial-move-delay", 200);
        this.initialMoveThreshold = Main.pref.getInteger("edit.initial-move-threshold", 5);
        this.repeatedKeySwitchLassoOption = Main.pref.getBoolean("mappaint.select.toggle-lasso-on-repeated-S", true);
        this.cycleManager.init();
        this.virtualManager.init();
        Main.map.keyDetector.addModifierListener(this);
        Main.map.keyDetector.addKeyListener(this);
    }

    @Override
    public void exitMode() {
        super.exitMode();
        this.selectionManager.unregister(this.mv);
        this.mv.removeMouseListener(this);
        this.mv.removeMouseMotionListener(this);
        this.mv.setVirtualNodesEnabled(false);
        Main.map.keyDetector.removeModifierListener(this);
        Main.map.keyDetector.removeKeyListener(this);
        this.removeHighlighting();
    }

    @Override
    public void modifiersChanged(int n) {
        if (!Main.isDisplayingMapView() || this.oldEvent == null) {
            return;
        }
        if (this.giveUserFeedback(this.oldEvent, n)) {
            this.mv.repaint();
        }
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent) {
        return this.giveUserFeedback(mouseEvent, mouseEvent.getModifiers());
    }

    private boolean giveUserFeedback(MouseEvent mouseEvent, int n) {
        Collection<OsmPrimitive> collection = SelectAction.asColl(this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), this.mv.isSelectablePredicate, true));
        this.updateKeyModifiers(n);
        this.determineMapMode(!collection.isEmpty());
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        this.virtualManager.clear();
        if (this.mode == Mode.MOVE && !this.dragInProgress() && this.virtualManager.activateVirtualNodeNearPoint(mouseEvent.getPoint())) {
            DataSet dataSet = this.getLayerManager().getEditDataSet();
            if (dataSet != null && this.drawTargetHighlight) {
                dataSet.setHighlightedVirtualNodes(this.virtualManager.virtualWays);
            }
            this.mv.setNewCursor(SelectActionCursor.virtual_node.cursor(), (Object)this);
            return this.repaintIfRequired(hashSet);
        }
        this.mv.setNewCursor(this.getCursor(collection), (Object)this);
        if (!this.drawTargetHighlight || this.mode != Mode.MOVE || collection.isEmpty()) {
            return this.repaintIfRequired(hashSet);
        }
        boolean bl = this.ctrl && !this.dragInProgress();
        for (OsmPrimitive osmPrimitive : collection) {
            if (!bl && osmPrimitive.isSelected()) continue;
            hashSet.add(osmPrimitive);
        }
        return this.repaintIfRequired(hashSet);
    }

    private Cursor getCursor(Collection<OsmPrimitive> collection) {
        String string = "rect";
        switch (this.mode) {
            case MOVE: {
                OsmPrimitive osmPrimitive;
                if (this.virtualManager.hasVirtualNode()) {
                    string = "virtual_node";
                    break;
                }
                Iterator<OsmPrimitive> iterator = collection.iterator();
                OsmPrimitive osmPrimitive2 = osmPrimitive = iterator.hasNext() ? iterator.next() : null;
                if (this.dragInProgress()) {
                    if (!this.ctrl || this.getLayerManager().getEditDataSet().getSelectedNodes().isEmpty()) {
                        string = "move";
                        break;
                    }
                    boolean bl = osmPrimitive instanceof Node && !osmPrimitive.isSelected();
                    string = bl ? "merge_to_node" : "merge";
                    break;
                }
                string = osmPrimitive instanceof Node ? "node" : string;
                String string2 = string = osmPrimitive instanceof Way ? "way" : string;
                if (this.shift) {
                    string = string + "_add";
                    break;
                }
                if (!this.ctrl) break;
                string = string + (osmPrimitive == null || osmPrimitive.isSelected() ? "_rm" : "_add");
                break;
            }
            case ROTATE: {
                string = "rotate";
                break;
            }
            case SCALE: {
                string = "scale";
                break;
            }
            case SELECT: {
                string = this.lassoMode ? "lasso" : "rect" + (this.shift ? "_add" : (this.ctrl && !Main.isPlatformOsx() ? "_rm" : ""));
            }
        }
        return SelectActionCursor.valueOf(string).cursor();
    }

    private boolean removeHighlighting() {
        boolean bl = false;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet != null && !dataSet.getHighlightedVirtualNodes().isEmpty()) {
            bl = true;
            dataSet.clearHighlightedVirtualNodes();
        }
        if (this.oldHighlights.isEmpty()) {
            return bl;
        }
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
        }
        this.oldHighlights = new HashSet<OsmPrimitive>();
        return true;
    }

    private boolean repaintIfRequired(Set<OsmPrimitive> set) {
        if (!this.drawTargetHighlight) {
            return false;
        }
        boolean bl = false;
        for (OsmPrimitive osmPrimitive : set) {
            if (this.oldHighlights.contains(osmPrimitive)) continue;
            bl = true;
            osmPrimitive.setHighlighted(true);
        }
        this.oldHighlights.removeAll(set);
        for (OsmPrimitive osmPrimitive : this.oldHighlights) {
            osmPrimitive.setHighlighted(false);
            bl = true;
        }
        this.oldHighlights = set;
        return bl;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseDownButton = mouseEvent.getButton();
        if (!this.mv.isActiveLayerVisible() || !((Boolean)this.getValue("active")).booleanValue() || this.mouseDownButton != 1) {
            return;
        }
        this.mv.requestFocus();
        this.updateKeyModifiers(mouseEvent);
        this.cancelDrawMode = this.shift || this.ctrl;
        this.didMouseDrag = false;
        this.initialMoveThresholdExceeded = false;
        this.mouseDownTime = System.currentTimeMillis();
        this.lastMousePos = mouseEvent.getPoint();
        this.startEN = this.mv.getEastNorth(this.lastMousePos.x, this.lastMousePos.y);
        OsmPrimitive osmPrimitive = this.mv.getNearestNodeOrWay(mouseEvent.getPoint(), this.mv.isSelectablePredicate, true);
        this.determineMapMode(osmPrimitive != null);
        switch (this.mode) {
            case ROTATE: 
            case SCALE: {
                DataSet dataSet = this.getLayerManager().getEditDataSet();
                if (!dataSet.selectionEmpty()) break;
                dataSet.setSelected(SelectAction.asColl(osmPrimitive));
                break;
            }
            case MOVE: {
                if (!this.cancelDrawMode && osmPrimitive instanceof Way) {
                    this.virtualManager.activateVirtualNodeNearPoint(mouseEvent.getPoint());
                }
                OsmPrimitive osmPrimitive2 = this.cycleManager.cycleSetup(osmPrimitive, mouseEvent.getPoint());
                this.selectPrims(SelectAction.asColl(osmPrimitive2), false, false);
                this.useLastMoveCommandIfPossible();
                GuiHelper.scheduleTimer(this.initialMoveDelay + 1, actionEvent -> this.updateStatusLine(), false);
                break;
            }
            default: {
                if (this.ctrl && Main.isPlatformOsx()) break;
                this.selectionManager.register(this.mv, this.lassoMode);
                this.selectionManager.mousePressed(mouseEvent);
            }
        }
        if (this.giveUserFeedback(mouseEvent)) {
            this.mv.repaint();
        }
        this.updateStatusLine();
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (Main.isPlatformOsx() && (this.mode == Mode.ROTATE || this.mode == Mode.SCALE)) {
            this.mouseDragged(mouseEvent);
            return;
        }
        this.oldEvent = mouseEvent;
        if (this.giveUserFeedback(mouseEvent)) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        int n;
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        if (this.mouseDownButton == 1 && this.mouseReleaseTime > this.mouseDownTime) {
            return;
        }
        this.cancelDrawMode = true;
        if (this.mode == Mode.SELECT) {
            if (this.ctrl && Main.isPlatformOsx()) {
                this.selectionManager.unregister(this.mv);
                this.mv.setNewCursor(13, (Object)this);
            }
            return;
        }
        if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime < (long)this.initialMoveDelay) {
            return;
        }
        if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE && (mouseEvent.getModifiersEx() & 0x400) == 0) {
            return;
        }
        if (this.mode == Mode.MOVE) {
            n = this.ctrl && !this.getLayerManager().getEditDataSet().getSelectedNodes().isEmpty() ? 1 : 0;
            Node node = n != 0 ? this.findNodeToMergeTo(mouseEvent.getPoint()) : null;
            boolean bl = this.removeHighlighting();
            if (node != null) {
                node.setHighlighted(true);
                this.oldHighlights.add(node);
                bl = true;
            }
            this.mv.setNewCursor(this.getCursor(SelectAction.asColl(node)), (Object)this);
            this.oldEvent = mouseEvent;
            if (bl) {
                this.mv.repaint();
            }
        }
        if (this.startingDraggingPos == null) {
            this.startingDraggingPos = new Point(mouseEvent.getX(), mouseEvent.getY());
        }
        if (this.lastMousePos == null) {
            this.lastMousePos = mouseEvent.getPoint();
            return;
        }
        if (!this.initialMoveThresholdExceeded) {
            n = (int)this.lastMousePos.distance(mouseEvent.getX(), mouseEvent.getY());
            if (n < this.initialMoveThreshold) {
                return;
            }
            this.initialMoveThresholdExceeded = true;
        }
        if (mouseEvent.getPoint().equals(this.lastMousePos)) {
            return;
        }
        EastNorth eastNorth = this.mv.getEastNorth(mouseEvent.getX(), mouseEvent.getY());
        if (this.virtualManager.hasVirtualWaysToBeConstructed()) {
            this.virtualManager.createMiddleNodeFromVirtual(eastNorth);
        } else if (!this.updateCommandWhileDragging(eastNorth)) {
            return;
        }
        this.mv.repaint();
        if (this.mode != Mode.SCALE) {
            this.lastMousePos = mouseEvent.getPoint();
        }
        this.didMouseDrag = true;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.removeHighlighting()) {
            this.mv.repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.mv.isActiveLayerVisible()) {
            return;
        }
        this.startingDraggingPos = null;
        this.mouseReleaseTime = System.currentTimeMillis();
        if (this.mode == Mode.SELECT) {
            if (mouseEvent.getButton() != 1) {
                return;
            }
            this.selectionManager.endSelecting(mouseEvent);
            this.selectionManager.unregister(this.mv);
            if (!this.cancelDrawMode && this.getLayerManager().getEditDataSet().selectionEmpty()) {
                Main.map.selectDrawTool(true);
                this.updateStatusLine();
                return;
            }
        }
        if (this.mode == Mode.MOVE && mouseEvent.getButton() == 1) {
            if (!this.didMouseDrag) {
                this.virtualManager.clear();
                if (this.lastMousePos == null || this.lastMousePos.distanceSq(mouseEvent.getPoint()) < 100.0) {
                    this.updateKeyModifiers(mouseEvent);
                    this.selectPrims(this.cycleManager.cyclePrims(), true, false);
                    Collection<OsmPrimitive> collection = this.getLayerManager().getEditDataSet().getSelected();
                    if (mouseEvent.getClickCount() >= 2 && collection.size() == 1 && collection.iterator().next() instanceof Node) {
                        Main.worker.execute(() -> Main.map.selectDrawTool(true));
                        return;
                    }
                }
            } else {
                this.confirmOrUndoMovement(mouseEvent);
            }
        }
        this.mode = null;
        if (mouseEvent.getButton() == 2) {
            this.removeHighlighting();
        } else {
            this.giveUserFeedback(mouseEvent);
        }
        this.updateStatusLine();
    }

    @Override
    public void selectionEnded(Rectangle rectangle, MouseEvent mouseEvent) {
        this.updateKeyModifiers(mouseEvent);
        this.selectPrims(this.selectionManager.getSelectedObjects(this.alt), true, true);
    }

    @Override
    public void doKeyPressed(KeyEvent keyEvent) {
        if (!(this.repeatedKeySwitchLassoOption && Main.isDisplayingMapView() && this.getShortcut().isEvent(keyEvent))) {
            return;
        }
        if (Main.isDebugEnabled()) {
            Main.debug(this.getClass().getName() + " consuming event " + keyEvent);
        }
        keyEvent.consume();
        if (!this.lassoMode) {
            Main.map.selectMapMode(Main.map.mapModeSelectLasso);
        } else {
            Main.map.selectMapMode(Main.map.mapModeSelect);
        }
    }

    @Override
    public void doKeyReleased(KeyEvent keyEvent) {
    }

    private void determineMapMode(boolean bl) {
        this.mode = this.shift && this.ctrl ? Mode.ROTATE : (this.alt && this.ctrl ? Mode.SCALE : (bl || this.dragInProgress() ? Mode.MOVE : Mode.SELECT));
    }

    private boolean dragInProgress() {
        return this.didMouseDrag && this.startingDraggingPos != null;
    }

    private boolean updateCommandWhileDragging(EastNorth eastNorth) {
        Object object;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        Collection<OsmPrimitive> collection = dataSet.getSelectedNodesAndWays();
        if (collection.isEmpty()) {
            object = this.mv.getNearestNodeOrWay(this.mv.getPoint(this.startEN), this.mv.isSelectablePredicate, true);
            dataSet.setSelected(new PrimitiveId[]{object});
        }
        if ((object = AllNodesVisitor.getAllNodes(collection)).size() < 2 && (this.mode == Mode.ROTATE || this.mode == Mode.SCALE)) {
            return false;
        }
        Command command = SelectAction.getLastCommand();
        if (this.mode == Mode.MOVE) {
            if (this.startEN == null) {
                return false;
            }
            dataSet.beginUpdate();
            if (command instanceof MoveCommand && object.equals(((MoveCommand)command).getParticipatingPrimitives())) {
                ((MoveCommand)command).saveCheckpoint();
                ((MoveCommand)command).applyVectorTo(eastNorth);
            } else {
                command = new MoveCommand(collection, this.startEN, eastNorth);
                Main.main.undoRedo.add(command);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                LatLon latLon = node.getCoor();
                if (latLon == null || !latLon.isOutSideWorld()) continue;
                ((MoveCommand)command).resetToCheckpoint();
                dataSet.endUpdate();
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("Cannot move objects outside of the world.", new Object[0]), I18n.tr("Warning", new Object[0]), 2);
                this.mv.setNewCursor(this.cursor, (Object)this);
                return false;
            }
        } else {
            this.startEN = eastNorth;
            if (this.mode != Mode.ROTATE && this.mode != Mode.SCALE) {
                return false;
            }
            dataSet.beginUpdate();
            if (this.mode == Mode.ROTATE) {
                if (command instanceof RotateCommand && object.equals(((RotateCommand)command).getTransformedNodes())) {
                    ((RotateCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new RotateCommand(collection, eastNorth));
                }
            } else if (this.mode == Mode.SCALE) {
                if (command instanceof ScaleCommand && object.equals(((ScaleCommand)command).getTransformedNodes())) {
                    ((ScaleCommand)command).handleEvent(eastNorth);
                } else {
                    Main.main.undoRedo.add(new ScaleCommand(collection, eastNorth));
                }
            }
            Collection<Way> collection2 = dataSet.getSelectedWays();
            if (SelectAction.doesImpactStatusLine((Collection<Node>)object, collection2)) {
                Main.map.statusLine.setDist(collection2);
            }
        }
        dataSet.endUpdate();
        return true;
    }

    private static boolean doesImpactStatusLine(Collection<Node> collection, Collection<Way> collection2) {
        for (Way way : collection2) {
            for (Node node : way.getNodes()) {
                if (!collection.contains(node)) continue;
                return true;
            }
        }
        return false;
    }

    private void useLastMoveCommandIfPossible() {
        Command command = SelectAction.getLastCommand();
        Collection<Node> collection = AllNodesVisitor.getAllNodes(this.getLayerManager().getEditDataSet().getSelected());
        if (command instanceof MoveCommand && collection.equals(((MoveCommand)command).getParticipatingPrimitives())) {
            ((MoveCommand)command).changeStartPoint(this.startEN);
        }
    }

    private static Command getLastCommand() {
        Command command;
        Command command2 = command = !Main.main.undoRedo.commands.isEmpty() ? Main.main.undoRedo.commands.getLast() : null;
        if (command instanceof SequenceCommand) {
            command = ((SequenceCommand)command).getLastCommand();
        }
        return command;
    }

    private void confirmOrUndoMovement(MouseEvent mouseEvent) {
        int n;
        if (this.movesHiddenWay()) {
            ConfirmMoveDialog confirmMoveDialog = new ConfirmMoveDialog();
            confirmMoveDialog.setContent(I18n.tr("Are you sure that you want to move elements with attached ways that are hidden by filters?", new Object[0]));
            confirmMoveDialog.toggleEnable("movedHiddenElements");
            confirmMoveDialog.showDialog();
            if (confirmMoveDialog.getValue() != 1) {
                Main.main.undoRedo.undo();
            }
        }
        int n2 = n = Main.pref.getInteger("warn.move.maxelements", 20);
        for (OsmPrimitive osmPrimitive : this.getLayerManager().getEditDataSet().getSelected()) {
            if (osmPrimitive instanceof Way) {
                n2 -= ((Way)osmPrimitive).getNodes().size();
            }
            if (--n2 >= 0) continue;
            break;
        }
        if (n2 < 0) {
            ConfirmMoveDialog confirmMoveDialog = new ConfirmMoveDialog();
            confirmMoveDialog.setContent(I18n.trn("You moved more than {0} element. Moving a large number of elements is often an error.\nReally move them?", "You moved more than {0} elements. Moving a large number of elements is often an error.\nReally move them?", n, n));
            confirmMoveDialog.toggleEnable("movedManyElements");
            confirmMoveDialog.showDialog();
            if (confirmMoveDialog.getValue() != 1) {
                Main.main.undoRedo.undo();
            }
        } else {
            this.updateKeyModifiers(mouseEvent);
            if (this.ctrl) {
                this.mergePrims(mouseEvent.getPoint());
            }
        }
        this.getLayerManager().getEditDataSet().fireSelectionChanged();
    }

    private boolean movesHiddenWay() {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>(dataSet.getSelected());
        for (OsmPrimitive osmPrimitive : Utils.filteredCollection(dataSet.getSelected(), Way.class)) {
            hashSet.addAll(((Way)osmPrimitive).getNodes());
        }
        for (OsmPrimitive osmPrimitive : Utils.filteredCollection(hashSet, Node.class)) {
            for (Way way : Utils.filteredCollection(osmPrimitive.getReferrers(), Way.class)) {
                if (!way.isDisabledAndHidden()) continue;
                return true;
            }
        }
        return false;
    }

    private void mergePrims(Point point) {
        Collection<OsmPrimitive> collection;
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        Collection<Node> collection2 = dataSet.getSelectedNodes();
        if (collection2.isEmpty()) {
            return;
        }
        Node node = this.findNodeToMergeTo(point);
        if (node == null) {
            return;
        }
        if (collection2.size() == 1) {
            collection = dataSet.getSelectedNodesAndWays();
            Collection<Node> collection3 = AllNodesVisitor.getAllNodes(collection);
            Command command = SelectAction.getLastCommand();
            dataSet.beginUpdate();
            if (command instanceof MoveCommand && collection3.equals(((MoveCommand)command).getParticipatingPrimitives())) {
                Node node2 = collection2.iterator().next();
                EastNorth eastNorth = node2.getEastNorth();
                EastNorth eastNorth2 = node.getEastNorth();
                ((MoveCommand)command).moveAgain(eastNorth2.getX() - eastNorth.getX(), eastNorth2.getY() - eastNorth.getY());
            }
            dataSet.endUpdate();
        }
        collection = new LinkedList<Node>(collection2);
        collection.add(node);
        this.mergeNodes(Main.getLayerManager().getEditLayer(), collection, node);
    }

    public void mergeNodes(OsmDataLayer osmDataLayer, Collection<Node> collection, Node node) {
        MergeNodesAction.doMergeNodes(osmDataLayer, collection, node);
    }

    private Node findNodeToMergeTo(Point point) {
        List<Node> list = this.mv.getNearestNodes(point, this.getLayerManager().getEditDataSet().getSelectedNodes(), this.mv.isSelectablePredicate);
        return list.isEmpty() ? null : (Node)list.iterator().next();
    }

    private void selectPrims(Collection<OsmPrimitive> collection, boolean bl, boolean bl2) {
        DataSet dataSet = this.getLayerManager().getEditDataSet();
        if (dataSet == null || this.shift && this.ctrl || this.ctrl && !bl || this.virtualManager.hasVirtualWaysToBeConstructed() && !bl) {
            return;
        }
        if (!bl) {
            this.shift |= dataSet.getSelected().containsAll(collection);
        }
        if (this.ctrl) {
            if (bl2) {
                dataSet.clearSelection(collection);
            } else {
                dataSet.toggleSelected(collection);
            }
        } else if (this.shift) {
            dataSet.addSelected(collection);
        } else {
            dataSet.setSelected(collection);
        }
    }

    public final Mode getMode() {
        return this.mode;
    }

    @Override
    public String getModeHelpText() {
        if (this.mouseDownButton == 1 && this.mouseReleaseTime < this.mouseDownTime) {
            if (this.mode == Mode.SELECT) {
                return I18n.tr("Release the mouse button to select the objects in the rectangle.", new Object[0]);
            }
            if (this.mode == Mode.MOVE && System.currentTimeMillis() - this.mouseDownTime >= (long)this.initialMoveDelay) {
                DataSet dataSet = this.getLayerManager().getEditDataSet();
                boolean bl = dataSet != null && !dataSet.getSelectedNodes().isEmpty();
                String string = bl ? ' ' + I18n.tr("Ctrl to merge with nearest node.", new Object[0]) : "";
                return I18n.tr("Release the mouse button to stop moving.", new Object[0]) + string;
            }
            if (this.mode == Mode.ROTATE) {
                return I18n.tr("Release the mouse button to stop rotating.", new Object[0]);
            }
            if (this.mode == Mode.SCALE) {
                return I18n.tr("Release the mouse button to stop scaling.", new Object[0]);
            }
        }
        return I18n.tr("Move objects by dragging; Shift to add to selection (Ctrl to toggle); Shift-Ctrl to rotate selected; Alt-Ctrl to scale selected; or change selection", new Object[0]);
    }

    @Override
    public boolean layerIsSupported(Layer layer) {
        return layer instanceof OsmDataLayer;
    }

    public void setLassoMode(boolean bl) {
        this.selectionManager.setLassoMode(bl);
        this.lassoMode = bl;
    }

    protected static <T> Collection<T> asColl(T t) {
        return t == null ? Collections.emptySet() : Collections.singleton(t);
    }

    private class VirtualManager {
        private Node virtualNode;
        private Collection<WaySegment> virtualWays = new LinkedList<WaySegment>();
        private int nodeVirtualSize;
        private int virtualSnapDistSq2;
        private int virtualSpace;

        private VirtualManager() {
        }

        private void init() {
            this.nodeVirtualSize = Main.pref.getInteger("mappaint.node.virtual-size", 8);
            int n = Main.pref.getInteger("mappaint.node.virtual-snap-distance", 8);
            this.virtualSnapDistSq2 = n * n;
            this.virtualSpace = Main.pref.getInteger("mappaint.node.virtual-space", 70);
        }

        private boolean activateVirtualNodeNearPoint(Point point) {
            if (this.nodeVirtualSize > 0) {
                LinkedList<WaySegment> linkedList = new LinkedList<WaySegment>();
                Pair pair = null;
                Pair<Object, Object> pair2 = new Pair<Object, Object>(null, null);
                for (WaySegment waySegment : SelectAction.this.mv.getNearestWaySegments(point, ((SelectAction)SelectAction.this).mv.isSelectablePredicate)) {
                    Point2D.Double double_;
                    MapViewState.MapViewPoint mapViewPoint;
                    Way way = waySegment.way;
                    pair2.a = way.getNode(waySegment.lowerIndex);
                    pair2.b = way.getNode(waySegment.lowerIndex + 1);
                    MapViewState.MapViewPoint mapViewPoint2 = SelectAction.this.mv.getState().getPointFor((Node)pair2.a);
                    if (!WireframeMapRenderer.isLargeSegment(mapViewPoint2, mapViewPoint = SelectAction.this.mv.getState().getPointFor((Node)pair2.b), this.virtualSpace) || !(point.distanceSq(double_ = new Point2D.Double((mapViewPoint2.getInViewX() + mapViewPoint.getInViewX()) / 2.0, (mapViewPoint2.getInViewY() + mapViewPoint.getInViewY()) / 2.0)) < (double)this.virtualSnapDistSq2)) continue;
                    Pair.sort(pair2);
                    if (pair == null) {
                        pair = new Pair(pair2.a, pair2.b);
                        this.virtualNode = new Node(SelectAction.this.mv.getLatLon(((Point2D)double_).getX(), ((Point2D)double_).getY()));
                    }
                    if (!pair.equals(pair2)) continue;
                    (way.isSelected() ? linkedList : this.virtualWays).add(waySegment);
                }
                if (!linkedList.isEmpty()) {
                    this.virtualWays = linkedList;
                }
            }
            return !this.virtualWays.isEmpty();
        }

        private void createMiddleNodeFromVirtual(EastNorth eastNorth) {
            LinkedList<Command> linkedList = new LinkedList<Command>();
            linkedList.add(new AddCommand(this.virtualNode));
            for (WaySegment waySegment : this.virtualWays) {
                Way way = waySegment.way;
                Way way2 = new Way(way);
                way2.addNode(waySegment.lowerIndex + 1, this.virtualNode);
                linkedList.add(new ChangeCommand(way, way2));
            }
            linkedList.add(new MoveCommand((OsmPrimitive)this.virtualNode, SelectAction.this.startEN, eastNorth));
            String string = I18n.trn("Add and move a virtual new node to way", "Add and move a virtual new node to {0} ways", this.virtualWays.size(), this.virtualWays.size());
            Main.main.undoRedo.add(new SequenceCommand(string, linkedList));
            SelectAction.this.getLayerManager().getEditDataSet().setSelected(Collections.singleton(this.virtualNode));
            this.clear();
        }

        private void clear() {
            this.virtualWays.clear();
            this.virtualNode = null;
        }

        private boolean hasVirtualNode() {
            return this.virtualNode != null;
        }

        private boolean hasVirtualWaysToBeConstructed() {
            return !this.virtualWays.isEmpty();
        }
    }

    private class CycleManager {
        private Collection<OsmPrimitive> cycleList = Collections.emptyList();
        private boolean cyclePrims;
        private OsmPrimitive cycleStart;
        private boolean waitForMouseUpParameter;
        private boolean multipleMatchesParameter;

        private CycleManager() {
        }

        private void init() {
            this.waitForMouseUpParameter = Main.pref.getBoolean("mappaint.select.waits-for-mouse-up", false);
            this.multipleMatchesParameter = Main.pref.getBoolean("selectaction.cycles.multiple.matches", false);
        }

        private OsmPrimitive cycleSetup(OsmPrimitive osmPrimitive, Point point) {
            OsmPrimitive osmPrimitive2 = null;
            if (osmPrimitive != null) {
                osmPrimitive2 = osmPrimitive;
                if (!SelectAction.this.alt && !this.multipleMatchesParameter) {
                    this.cycleList = SelectAction.asColl(osmPrimitive2);
                    if (this.waitForMouseUpParameter) {
                        osmPrimitive2 = SelectAction.this.mv.getNearestNodeOrWay(point, ((SelectAction)SelectAction.this).mv.isSelectablePredicate, true);
                    }
                } else {
                    this.cycleList = SelectAction.this.mv.getAllNearest(point, ((SelectAction)SelectAction.this).mv.isSelectablePredicate);
                    if (this.cycleList.size() > 1) {
                        this.cyclePrims = false;
                        OsmPrimitive osmPrimitive3 = osmPrimitive2;
                        for (OsmPrimitive osmPrimitive4 : this.cycleList) {
                            if (!osmPrimitive4.isSelected()) continue;
                            this.cyclePrims = true;
                            osmPrimitive2 = osmPrimitive4;
                            break;
                        }
                        if (!(this.cycleList.size() != 2 || this.waitForMouseUpParameter || osmPrimitive2.equals(osmPrimitive3) || osmPrimitive2.isNew() || SelectAction.this.ctrl)) {
                            this.cyclePrims = false;
                            osmPrimitive2 = osmPrimitive3;
                        }
                    }
                }
            }
            return osmPrimitive2;
        }

        private Collection<OsmPrimitive> cyclePrims() {
            if (this.cycleList.size() <= 1) {
                return this.cycleList;
            }
            DataSet dataSet = SelectAction.this.getLayerManager().getEditDataSet();
            OsmPrimitive osmPrimitive = this.cycleList.iterator().next();
            OsmPrimitive osmPrimitive2 = null;
            OsmPrimitive osmPrimitive32 = osmPrimitive;
            if (this.cyclePrims && SelectAction.this.shift) {
                for (OsmPrimitive osmPrimitive32 : this.cycleList) {
                    if (!osmPrimitive32.isSelected()) break;
                }
            } else {
                Iterator<OsmPrimitive> iterator = this.cycleList.iterator();
                while (iterator.hasNext()) {
                    osmPrimitive32 = iterator.next();
                    if (!osmPrimitive32.isSelected()) continue;
                    osmPrimitive2 = osmPrimitive32;
                    if (!this.cyclePrims && !SelectAction.this.ctrl) break;
                    dataSet.clearSelection(osmPrimitive2);
                    OsmPrimitive osmPrimitive4 = osmPrimitive32 = iterator.hasNext() ? iterator.next() : osmPrimitive;
                    break;
                }
            }
            if (SelectAction.this.ctrl) {
                if (osmPrimitive2 != null) {
                    if (!this.cycleList.contains(this.cycleStart)) {
                        dataSet.clearSelection(this.cycleList);
                        this.cycleStart = osmPrimitive2;
                    } else if (this.cycleStart.equals(osmPrimitive32)) {
                        dataSet.addSelected(osmPrimitive32);
                    }
                } else {
                    this.cycleStart = osmPrimitive32 = this.cycleList.contains(this.cycleStart) ? this.cycleStart : osmPrimitive;
                }
            } else {
                this.cycleStart = null;
            }
            return SelectAction.asColl(osmPrimitive32);
        }
    }

    static class ConfirmMoveDialog
    extends ExtendedDialog {
        ConfirmMoveDialog() {
            super(Main.parent, I18n.tr("Move elements", new Object[0]), I18n.tr("Move them", new Object[0]), I18n.tr("Undo move", new Object[0]));
            this.setButtonIcons("reorder", "cancel");
            this.setCancelButton(2);
        }
    }

    private static enum SelectActionCursor {
        rect("normal", "selection"),
        rect_add("normal", "select_add"),
        rect_rm("normal", "select_remove"),
        way("normal", "select_way"),
        way_add("normal", "select_way_add"),
        way_rm("normal", "select_way_remove"),
        node("normal", "select_node"),
        node_add("normal", "select_node_add"),
        node_rm("normal", "select_node_remove"),
        virtual_node("normal", "addnode"),
        scale("scale", null),
        rotate("rotate", null),
        merge("crosshair", null),
        lasso("normal", "rope"),
        merge_to_node("crosshair", "joinnode"),
        move(13);

        private final Cursor c;

        private SelectActionCursor(String string2, String string3) {
            this.c = ImageProvider.getCursor(string2, string3);
        }

        private SelectActionCursor(int n2) {
            this.c = Cursor.getPredefinedCursor(n2);
        }

        public Cursor cursor() {
            return this.c;
        }
    }

    public static enum Mode {
        MOVE,
        ROTATE,
        SCALE,
        SELECT;

    }
}

