/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.IConflictListener;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.SubclassFilteredCollection;

public class ConflictCollection
implements Iterable<Conflict<? extends OsmPrimitive>> {
    private final List<Conflict<? extends OsmPrimitive>> conflicts = new ArrayList<Conflict<? extends OsmPrimitive>>();
    private final CopyOnWriteArrayList<IConflictListener> listeners = new CopyOnWriteArrayList();

    public void addConflictListener(IConflictListener iConflictListener) {
        if (iConflictListener != null) {
            this.listeners.addIfAbsent(iConflictListener);
        }
    }

    public void removeConflictListener(IConflictListener iConflictListener) {
        this.listeners.remove(iConflictListener);
    }

    protected void fireConflictAdded() {
        for (IConflictListener iConflictListener : this.listeners) {
            iConflictListener.onConflictsAdded(this);
        }
    }

    protected void fireConflictRemoved() {
        for (IConflictListener iConflictListener : this.listeners) {
            iConflictListener.onConflictsRemoved(this);
        }
    }

    protected void addConflict(Conflict<?> conflict) {
        if (this.hasConflictForMy((OsmPrimitive)conflict.getMy())) {
            throw new IllegalStateException(I18n.tr("Already registered a conflict for primitive ''{0}''.", conflict.getMy().toString()));
        }
        if (!this.conflicts.contains(conflict)) {
            this.conflicts.add(conflict);
        }
    }

    public void add(Conflict<?> conflict) {
        CheckParameterUtil.ensureParameterNotNull(conflict, "conflict");
        this.addConflict(conflict);
        this.fireConflictAdded();
    }

    public void add(Collection<Conflict<?>> collection) {
        if (collection == null) {
            return;
        }
        for (Conflict<?> conflict : collection) {
            this.addConflict(conflict);
        }
        this.fireConflictAdded();
    }

    public void add(OsmPrimitive osmPrimitive, OsmPrimitive osmPrimitive2) {
        this.addConflict(new Conflict<OsmPrimitive>(osmPrimitive, osmPrimitive2));
        this.fireConflictAdded();
    }

    public void remove(Conflict<?> conflict) {
        this.conflicts.remove(conflict);
        this.fireConflictRemoved();
    }

    public void remove(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingMy(osmPrimitive)) continue;
            iterator.remove();
        }
        this.fireConflictRemoved();
    }

    public Conflict<?> getConflictForMy(OsmPrimitive osmPrimitive) {
        for (Conflict<? extends OsmPrimitive> conflict : this.conflicts) {
            if (!conflict.isMatchingMy(osmPrimitive)) continue;
            return conflict;
        }
        return null;
    }

    public Conflict<?> getConflictForTheir(OsmPrimitive osmPrimitive) {
        for (Conflict<? extends OsmPrimitive> conflict : this.conflicts) {
            if (!conflict.isMatchingTheir(osmPrimitive)) continue;
            return conflict;
        }
        return null;
    }

    public boolean hasConflictForMy(OsmPrimitive osmPrimitive) {
        return this.getConflictForMy(osmPrimitive) != null;
    }

    public boolean hasConflict(Conflict<?> conflict) {
        return this.hasConflictForMy((OsmPrimitive)conflict.getMy());
    }

    public boolean hasConflictForTheir(OsmPrimitive osmPrimitive) {
        return this.getConflictForTheir(osmPrimitive) != null;
    }

    public void removeForMy(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingMy(osmPrimitive)) continue;
            iterator.remove();
        }
    }

    public void removeForTheir(OsmPrimitive osmPrimitive) {
        Iterator<Conflict<?>> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isMatchingTheir(osmPrimitive)) continue;
            iterator.remove();
        }
    }

    public List<Conflict<?>> get() {
        return this.conflicts;
    }

    public int size() {
        return this.conflicts.size();
    }

    public Conflict<?> get(int n) {
        return this.conflicts.get(n);
    }

    @Override
    public Iterator<Conflict<?>> iterator() {
        return this.conflicts.iterator();
    }

    public void add(ConflictCollection conflictCollection) {
        for (Conflict<?> conflict : conflictCollection) {
            this.add(conflict);
        }
    }

    public Set<OsmPrimitive> getMyConflictParties() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Conflict<? extends OsmPrimitive> conflict : this.conflicts) {
            hashSet.add(conflict.getMy());
        }
        return hashSet;
    }

    public Set<OsmPrimitive> getTheirConflictParties() {
        HashSet<OsmPrimitive> hashSet = new HashSet<OsmPrimitive>();
        for (Conflict<? extends OsmPrimitive> conflict : this.conflicts) {
            hashSet.add(conflict.getTheir());
        }
        return hashSet;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public String toString() {
        return this.conflicts.toString();
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getNodeConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, conflict -> conflict != null && conflict.getMy() instanceof Node);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getWayConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, conflict -> conflict != null && conflict.getMy() instanceof Way);
    }

    public final Collection<Conflict<? extends OsmPrimitive>> getRelationConflicts() {
        return SubclassFilteredCollection.filter(this.conflicts, conflict -> conflict != null && conflict.getMy() instanceof Relation);
    }

    public int hashCode() {
        return Objects.hash(this.conflicts, this.listeners);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConflictCollection conflictCollection = (ConflictCollection)object;
        return Objects.equals(this.conflicts, conflictCollection.conflicts) && Objects.equals(this.listeners, conflictCollection.listeners);
    }
}

