/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.Multipolygon;
import org.openstreetmap.josm.data.osm.visitor.paint.relations.MultipolygonCache;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;

public class PowerLines
extends Test {
    protected static final int POWER_LINES = 2501;
    static final Collection<String> POWER_LINE_TAGS = Arrays.asList("line", "minor_line");
    static final Collection<String> POWER_TOWER_TAGS = Arrays.asList("tower", "pole");
    static final Collection<String> POWER_STATION_TAGS = Arrays.asList("station", "sub_station", "substation", "plant", "generator");
    static final Collection<String> BUILDING_STATION_TAGS = Arrays.asList("transformer_tower");
    static final Collection<String> POWER_ALLOWED_TAGS = Arrays.asList("switch", "transformer", "busbar", "generator", "switchgear", "portal", "terminal", "insulator");
    private final List<TestError> potentialErrors = new ArrayList<TestError>();
    private final List<OsmPrimitive> powerStations = new ArrayList<OsmPrimitive>();

    public PowerLines() {
        super(I18n.tr("Power lines", new Object[0]), I18n.tr("Checks for nodes in power lines that do not have a power=tower/pole tag.", new Object[0]));
    }

    @Override
    public void visit(Way way) {
        if (way.isUsable()) {
            if (PowerLines.isPowerLine(way) && !way.hasTag("location", "underground")) {
                for (Node node : way.getNodes()) {
                    if (PowerLines.isPowerTower(node) || PowerLines.isPowerAllowed(node) || !IN_DOWNLOADED_AREA.test(node) || way.isFirstLastNode(node) && PowerLines.isPowerStation(node)) continue;
                    this.potentialErrors.add(TestError.builder(this, Severity.WARNING, 2501).message(I18n.tr("Missing power tower/pole within power line", new Object[0])).primitives(node).build());
                }
            } else if (way.isClosed() && PowerLines.isPowerStation(way)) {
                this.powerStations.add(way);
            }
        }
    }

    @Override
    public void visit(Relation relation) {
        if (relation.isMultipolygon() && PowerLines.isPowerStation(relation)) {
            this.powerStations.add(relation);
        }
    }

    @Override
    public void startTest(ProgressMonitor progressMonitor) {
        super.startTest(progressMonitor);
        this.powerStations.clear();
        this.potentialErrors.clear();
    }

    @Override
    public void endTest() {
        for (TestError testError : this.potentialErrors) {
            testError.getPrimitives().stream().map(Node.class::cast).filter(node -> !this.isInPowerStation((Node)node)).findAny().ifPresent(node -> this.errors.add(testError));
        }
        this.potentialErrors.clear();
        super.endTest();
    }

    protected final boolean isInPowerStation(Node node) {
        for (OsmPrimitive osmPrimitive : this.powerStations) {
            Object object;
            ArrayList<List<Node>> arrayList = new ArrayList<List<Node>>();
            if (osmPrimitive instanceof Way) {
                arrayList.add(((Way)osmPrimitive).getNodes());
            } else if (osmPrimitive instanceof Relation && (object = MultipolygonCache.getInstance().get(Main.map.mapView, (Relation)osmPrimitive)) != null) {
                for (Multipolygon.JoinedWay joinedWay : Multipolygon.joinWays(((Multipolygon)object).getOuterWays())) {
                    arrayList.add(joinedWay.getNodes());
                }
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                List list = (List)object.next();
                if (!Geometry.nodeInsidePolygon(node, list)) continue;
                return true;
            }
        }
        return false;
    }

    protected static final boolean isPowerLine(Way way) {
        return PowerLines.isPowerIn(way, POWER_LINE_TAGS);
    }

    protected static final boolean isPowerStation(OsmPrimitive osmPrimitive) {
        return PowerLines.isPowerIn(osmPrimitive, POWER_STATION_TAGS) || PowerLines.isBuildingIn(osmPrimitive, BUILDING_STATION_TAGS);
    }

    protected static final boolean isPowerTower(Node node) {
        return PowerLines.isPowerIn(node, POWER_TOWER_TAGS);
    }

    protected static final boolean isPowerAllowed(Node node) {
        return PowerLines.isPowerIn(node, POWER_ALLOWED_TAGS);
    }

    private static boolean isPowerIn(OsmPrimitive osmPrimitive, Collection<String> collection) {
        return osmPrimitive.hasTag("power", collection);
    }

    private static boolean isBuildingIn(OsmPrimitive osmPrimitive, Collection<String> collection) {
        return osmPrimitive.hasTag("building", collection);
    }
}

