/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.History;
import org.openstreetmap.josm.data.osm.history.HistoryDataSet;
import org.openstreetmap.josm.data.osm.history.HistoryDataSetListener;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.history.HistoryBrowser;
import org.openstreetmap.josm.gui.history.HistoryBrowserDialogManager;
import org.openstreetmap.josm.gui.history.HistoryLoadTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.InputMapUtils;

public class HistoryBrowserDialog
extends JDialog
implements HistoryDataSetListener {
    private final HistoryBrowser browser = new HistoryBrowser();
    private final CloseAction closeAction = new CloseAction();
    private final JLabel titleLabel = new JLabel("", 0);

    public HistoryBrowserDialog(History history) {
        super(GuiHelper.getFrameForComponent(Main.parent), false);
        this.build();
        this.setHistory(history);
        this.setTitle(HistoryBrowserDialog.buildTitle(history));
        this.pack();
        if (this.getInsets().top > 0) {
            this.titleLabel.setVisible(false);
        }
        HistoryDataSet.getInstance().addHistoryDataSetListener(this);
        this.addWindowListener(new WindowClosingAdapter());
    }

    static String buildTitle(History history) {
        String string;
        switch (history.getEarliest().getType()) {
            case NODE: {
                string = I18n.marktr("History for node {0}");
                break;
            }
            case WAY: {
                string = I18n.marktr("History for way {0}");
                break;
            }
            case RELATION: {
                string = I18n.marktr("History for relation {0}");
                break;
            }
            default: {
                string = "";
            }
        }
        return I18n.tr(string, Long.toString(history.getId()));
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(string);
        if (this.titleLabel != null) {
            this.titleLabel.setText(string);
        }
    }

    protected void build() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.titleLabel, "North");
        this.add((Component)this.browser, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1));
        JButton jButton = new JButton(new ReloadAction());
        jButton.setName("btn.reload");
        jPanel.add(jButton);
        jButton = new JButton(this.closeAction);
        jButton.setName("btn.close");
        jPanel.add(jButton);
        InputMapUtils.addEscapeAction(this.getRootPane(), this.closeAction);
        jButton = new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Action/ObjectHistory")));
        jButton.setName("btn.help");
        jPanel.add(jButton);
        this.add((Component)jPanel, "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Action/ObjectHistory"));
    }

    protected void setHistory(History history) {
        this.browser.populate(history);
    }

    public void unlinkAsListener() {
        this.getHistoryBrowser().getModel().unlinkAsListener();
    }

    @Override
    public void historyUpdated(HistoryDataSet historyDataSet, PrimitiveId primitiveId) {
        History history;
        if ((primitiveId == null || primitiveId.equals(this.browser.getHistory().getPrimitiveId())) && (history = historyDataSet.getHistory(this.browser.getHistory().getPrimitiveId())) != null) {
            this.browser.populate(history);
        }
    }

    @Override
    public void historyDataSetCleared(HistoryDataSet historyDataSet) {
        this.closeAction.run();
    }

    public HistoryBrowser getHistoryBrowser() {
        return this.browser;
    }

    class WindowClosingAdapter
    extends WindowAdapter {
        WindowClosingAdapter() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            HistoryBrowserDialog.this.closeAction.run();
        }
    }

    class ReloadAction
    extends AbstractAction {
        ReloadAction() {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reload the history from the server", new Object[0]));
            new ImageProvider("dialogs", "refresh").getResource().attachImageIcon(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            HistoryLoadTask historyLoadTask = new HistoryLoadTask();
            historyLoadTask.add(HistoryBrowserDialog.this.browser.getHistory());
            Main.worker.submit(historyLoadTask);
        }
    }

    class CloseAction
    extends AbstractAction {
        CloseAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
            new ImageProvider("ok").getResource().attachImageIcon(this);
        }

        public void run() {
            HistoryBrowserDialog.this.getHistoryBrowser().getModel().unlinkAsListener();
            HistoryDataSet.getInstance().removeHistoryDataSetListener(HistoryBrowserDialog.this);
            HistoryBrowserDialogManager.getInstance().hide(HistoryBrowserDialog.this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.run();
        }
    }
}

