/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.loader;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ForeignAccess;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.Source;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.locks.ReentrantLock;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Log;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.string.StringUtils;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.control.JavaException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.loader.CodeLoader;
import org.jruby.truffle.language.loader.FeatureLoader;
import org.jruby.truffle.language.loader.ReentrantLockFreeingMap;
import org.jruby.truffle.language.loader.RequireNodeGen;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.parser.ParserContext;

@NodeChild(value="feature")
public abstract class RequireNode
extends RubyNode {
    @Node.Child
    private IndirectCallNode callNode = IndirectCallNode.create();
    @Node.Child
    private CallDispatchHeadNode isInLoadedFeatures = CallDispatchHeadNode.createMethodCall();
    @Node.Child
    private CallDispatchHeadNode addToLoadedFeatures = CallDispatchHeadNode.createMethodCall();
    @Node.Child
    private Node isExecutableNode = Message.IS_EXECUTABLE.createNode();
    @Node.Child
    private Node executeNode = Message.createExecute(0).createNode();

    public static RequireNode create() {
        return RequireNodeGen.create(null);
    }

    public abstract boolean executeRequire(VirtualFrame var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    protected boolean require(VirtualFrame frame, String feature, @Cached(value="create()") BranchProfile errorProfile, @Cached(value="createBinaryProfile()") ConditionProfile isLoadedProfile) {
        ReentrantLock lock;
        FeatureLoader featureLoader = this.getContext().getFeatureLoader();
        String expandedPath = featureLoader.findFeature(feature);
        if (expandedPath == null) {
            errorProfile.enter();
            throw new RaiseException(this.getContext().getCoreExceptions().loadErrorCannotLoad(feature, this));
        }
        DynamicObject pathString = StringOperations.createString(this.getContext(), StringOperations.encodeRope(expandedPath, UTF8Encoding.INSTANCE));
        if (isLoadedProfile.profile(this.isFeatureLoaded(frame, pathString))) {
            return false;
        }
        ReentrantLockFreeingMap<String> fileLocks = featureLoader.getFileLocks();
        do {
            if (!(lock = fileLocks.get(expandedPath)).isHeldByCurrentThread()) continue;
            return false;
        } while (!fileLocks.lock(this, this.getContext().getThreadManager(), expandedPath, lock));
        try {
            Source source;
            if (this.isFeatureLoaded(frame, pathString)) {
                boolean bl = false;
                return bl;
            }
            try {
                source = this.getContext().getSourceLoader().load(expandedPath);
            }
            catch (IOException e) {
                boolean bl = false;
                fileLocks.unlock(expandedPath, lock);
                return bl;
            }
            String mimeType = this.getSourceMimeType(source);
            if ("application/x-ruby".equals(mimeType)) {
                RubyRootNode rootNode = this.getContext().getCodeLoader().parse(source, UTF8Encoding.INSTANCE, ParserContext.TOP_LEVEL, null, true, this);
                CodeLoader.DeferredCall deferredCall = this.getContext().getCodeLoader().prepareExecute(ParserContext.TOP_LEVEL, DeclarationContext.TOP_LEVEL, rootNode, null, this.coreLibrary().getMainObject());
                deferredCall.call(frame, this.callNode);
            } else if ("application/x-sulong-library".equals(mimeType)) {
                featureLoader.ensureCExtImplementationLoaded(frame, feature, this.callNode);
                if (this.getContext().getOptions().CEXTS_LOG_LOAD) {
                    Log.info("loading cext module %s", expandedPath);
                }
                CallTarget callTarget = featureLoader.parseSource(source);
                this.callNode.call(frame, callTarget, new Object[0]);
                TruffleObject initFunction = this.getInitFunction(expandedPath);
                if (!ForeignAccess.sendIsExecutable(this.isExecutableNode, frame, initFunction)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new UnsupportedOperationException();
                }
                try {
                    ForeignAccess.sendExecute(this.executeNode, frame, initFunction, new Object[0]);
                }
                catch (InteropException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw new JavaException(e);
                }
            } else {
                errorProfile.enter();
                if (StringUtils.toLowerCase(expandedPath).endsWith(".su")) {
                    throw new RaiseException(this.cextSupportNotAvailable(expandedPath));
                }
                throw new RaiseException(this.unknownLanguage(expandedPath, mimeType));
            }
            this.addToLoadedFeatures(frame, pathString);
            boolean bl = true;
            return bl;
        }
        finally {
            fileLocks.unlock(expandedPath, lock);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private String getSourceMimeType(Source source) {
        return source.getMimeType();
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject cextSupportNotAvailable(String expandedPath) {
        return this.getContext().getCoreExceptions().internalError("cext support is not available to load " + expandedPath, this.callNode);
    }

    @CompilerDirectives.TruffleBoundary
    private DynamicObject unknownLanguage(String expandedPath, String mimeType) {
        return this.getContext().getCoreExceptions().internalError("unknown language " + mimeType + " for " + expandedPath, this.callNode);
    }

    @CompilerDirectives.TruffleBoundary
    private TruffleObject getInitFunction(String expandedPath) {
        String initFunctionName = "@Init_" + this.getBaseName(expandedPath);
        Object initFunction = this.getContext().getEnv().importSymbol(initFunctionName);
        if (!(initFunction instanceof TruffleObject)) {
            if (initFunction == null) {
                throw new RaiseException(this.getContext().getCoreExceptions().internalError(String.format("Couldn't find the cext initialise function %s in %s", initFunctionName, expandedPath), this.callNode));
            }
            throw new RaiseException(this.getContext().getCoreExceptions().internalError(String.format("The cext initialise function %s in %s was not a Truffle object", initFunctionName, expandedPath), this.callNode));
        }
        return (TruffleObject)initFunction;
    }

    @CompilerDirectives.TruffleBoundary
    private String getBaseName(String path) {
        String name = new File(path).getName();
        int firstDot = name.indexOf(46);
        if (firstDot == -1) {
            return name;
        }
        return name.substring(0, firstDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFeatureLoaded(VirtualFrame frame, DynamicObject feature) {
        DynamicObject loadedFeatures = this.getContext().getCoreLibrary().getLoadedFeatures();
        Object object = this.getContext().getFeatureLoader().getLoadedFeaturesLock();
        synchronized (object) {
            return this.isInLoadedFeatures.callBoolean(frame, loadedFeatures, "include?", null, feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLoadedFeatures(VirtualFrame frame, DynamicObject feature) {
        DynamicObject loadedFeatures = this.coreLibrary().getLoadedFeatures();
        Object object = this.getContext().getFeatureLoader().getLoadedFeaturesLock();
        synchronized (object) {
            this.addToLoadedFeatures.call(frame, loadedFeatures, "<<", feature);
        }
    }
}

