/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

@NodeChild(value="child")
public abstract class IsFrozenNode
extends RubyNode {
    private final BranchProfile errorProfile = BranchProfile.create();

    public abstract boolean executeIsFrozen(Object var1);

    public void raiseIfFrozen(Object object) {
        if (this.executeIsFrozen(object)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().frozenError(object, this));
        }
    }

    @Specialization
    public boolean isFrozen(boolean object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(int object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(long object) {
        return true;
    }

    @Specialization
    public boolean isFrozen(double object) {
        return true;
    }

    @Specialization
    protected boolean isFrozen(DynamicObject object, @Cached(value="createReadFrozenNode()") ReadObjectFieldNode readFrozenNode) {
        return (Boolean)readFrozenNode.execute(object);
    }

    protected ReadObjectFieldNode createReadFrozenNode() {
        return ReadObjectFieldNodeGen.create(Layouts.FROZEN_IDENTIFIER, false);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isFrozen(Object object) {
        return !(object instanceof DynamicObject) || ((DynamicObject)object).containsKey(Layouts.FROZEN_IDENTIFIER);
    }
}

