/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.parser.scope;

import org.jruby.truffle.parser.scope.StaticScope;

public class DynamicScope {
    protected final StaticScope staticScope;
    protected final DynamicScope parent;
    private boolean lambda;
    private Object[] variableValues;

    public DynamicScope(StaticScope staticScope, DynamicScope parent) {
        this.staticScope = staticScope;
        this.parent = parent;
        this.allocate();
    }

    public DynamicScope(StaticScope staticScope) {
        this.staticScope = staticScope;
        this.parent = null;
        this.allocate();
    }

    public final DynamicScope getParentScope() {
        return this.parent;
    }

    @Deprecated
    public DynamicScope getNextCapturedScope() {
        return this.getParentScope();
    }

    public final StaticScope getStaticScope() {
        return this.staticScope;
    }

    public Object setValue(Object value, int offset, int depth) {
        return this.setValue(offset, value, depth);
    }

    public String toString() {
        return this.toString(new StringBuffer(), "");
    }

    public String toString(StringBuffer buf, String indent) {
        buf.append(indent).append("Static Type[" + this.hashCode() + "]: " + (this.staticScope.isBlockScope() ? "block" : "local") + " [");
        int size = this.staticScope.getNumberOfVariables();
        Object[] variableValues = this.getValues();
        if (size != 0) {
            String[] names = this.staticScope.getVariables();
            for (int i = 0; i < size - 1; ++i) {
                buf.append(names[i]).append("=");
                if (variableValues[i] == null) {
                    buf.append("null");
                } else {
                    buf.append(variableValues[i]);
                }
                buf.append(",");
            }
            buf.append(names[size - 1]).append("=");
            assert (variableValues.length == names.length) : "V: " + variableValues.length + " != N: " + names.length + " for " + buf;
            if (variableValues[size - 1] == null) {
                buf.append("null");
            } else {
                buf.append(variableValues[size - 1]);
            }
        }
        buf.append("]");
        if (this.parent != null) {
            buf.append("\n");
            this.parent.toString(buf, indent + "  ");
        }
        return buf.toString();
    }

    public void setLambda(boolean lambda) {
        this.lambda = lambda;
    }

    public boolean isLambda() {
        return this.lambda;
    }

    private void allocate() {
        if (this.variableValues == null) {
            int size = this.staticScope.getNumberOfVariables();
            this.variableValues = new Object[size];
        }
    }

    public Object[] getValues() {
        return this.variableValues;
    }

    public Object getValue(int offset, int depth) {
        if (depth > 0) {
            return this.parent.getValue(offset, depth - 1);
        }
        this.assertGetValue(offset, depth);
        return this.variableValues[offset];
    }

    public Object setValue(int offset, Object value, int depth) {
        if (depth > 0) {
            this.assertParent();
            return this.parent.setValue(offset, value, depth - 1);
        }
        this.assertSetValue(offset, value);
        return this.setValueDepthZero(value, offset);
    }

    public Object setValueDepthZero(Object value, int offset) {
        this.assertSetValueDepthZero(offset, value);
        this.variableValues[offset] = value;
        return this.variableValues[offset];
    }

    public void growIfNeeded() {
        int dynamicSize;
        int n = dynamicSize = this.variableValues == null ? 0 : this.variableValues.length;
        if (this.staticScope.getNumberOfVariables() > dynamicSize) {
            Object[] values = new Object[this.staticScope.getNumberOfVariables()];
            if (dynamicSize > 0) {
                DynamicScope.copy(this.variableValues, 0, values, 0, dynamicSize);
            }
            this.variableValues = values;
        }
    }

    public static void copy(Object[] src, int srcOff, Object[] dst, int dstOff, int length) {
        switch (length) {
            case 0: {
                return;
            }
            case 1: {
                dst[dstOff] = src[srcOff];
                return;
            }
            case 2: {
                dst[dstOff] = src[srcOff];
                dst[++dstOff] = src[srcOff + 1];
                return;
            }
            case 3: {
                dst[dstOff] = src[srcOff];
                dst[++dstOff] = src[srcOff + 1];
                dst[++dstOff] = src[srcOff + 2];
                return;
            }
        }
        System.arraycopy(src, srcOff, dst, dstOff, length);
    }

    private void assertGetValue(int offset, int depth) {
        Object[] values = this.variableValues;
        assert (values != null && offset < values.length) : "No variables or index to big for getValue off: " + offset + ", Dep: " + depth + ", O: " + this;
    }

    private void assertParent() {
        assert (this.parent != null) : "If depth > 0, then parent should not ever be null";
    }

    private void assertSetValue(int offset, Object value) {
        assert (offset < this.variableValues.length) : "Setting " + offset + " to " + value + ", O: " + this;
    }

    private void assertSetValueDepthZero(int offset, Object value) {
        assert (offset < this.variableValues.length) : "Setting " + offset + " to " + value + ", O: " + this;
    }
}

