/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.expression;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.expression.InlineMetadata;
import org.jetbrains.kotlin.js.translate.reference.CallExpressionTranslator;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.FunctionBodyTranslator;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0005\u001a\u001a\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\u0002\b\n*\u00020\u0002H\u0002\u001a \u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u001a\u001a\u0010\u0011\u001a\u00020\u0012*\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u001a\u001a\u0010\u0017\u001a\u00020\u0018*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"requiresExtensionReceiverParameter", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "getRequiresExtensionReceiverParameter", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Z", "getCorrectTypeParameters", "", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/ReadOnly;", "translateAndAliasParameters", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "descriptor", "targetList", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "translateFunction", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "wrapWithInlineMetadata", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "kotlin-compiler"})
public final class FunctionTranslatorKt {
    @NotNull
    public static final TranslationContext translateAndAliasParameters(@NotNull TranslationContext $receiver, @NotNull FunctionDescriptor descriptor2, @NotNull List<JsParameter> targetList2) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(targetList2, "targetList");
        Map aliases = new LinkedHashMap();
        for (TypeParameterDescriptor type2 : FunctionTranslatorKt.getCorrectTypeParameters(descriptor2)) {
            JsNameRef jsNameRef;
            if (!type2.isReified()) continue;
            JsName paramNameForType = $receiver.getNameForDescriptor(type2);
            object2 = targetList2;
            JsParameter jsParameter = new JsParameter(paramNameForType);
            object2.add(jsParameter);
            String suggestedName = Namer.isInstanceSuggestedName(type2);
            JsName paramName = $receiver.scope().declareTemporaryName(suggestedName);
            Object object3 = targetList2;
            Object object4 = new JsParameter(paramName);
            object3.add(object4);
            object3 = aliases;
            TypeParameterDescriptor typeParameterDescriptor = type2;
            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "type");
            object4 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull(paramName.makeRef(), "paramName.makeRef()");
            object3.put(object4, jsNameRef);
        }
        if (FunctionTranslatorKt.getRequiresExtensionReceiverParameter(descriptor2)) {
            JsName receiverParameterName = $receiver.scope().declareTemporaryName(Namer.getReceiverParameterName());
            Object object5 = aliases;
            ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
            if (receiverParameterDescriptor == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull(receiverParameterDescriptor, "descriptor.extensionReceiverParameter!!");
            object = receiverParameterDescriptor;
            JsNameRef jsNameRef = receiverParameterName.makeRef();
            Intrinsics.checkExpressionValueIsNotNull(jsNameRef, "receiverParameterName.makeRef()");
            object2 = jsNameRef;
            object5.put(object, object2);
            object5 = targetList2;
            object = new JsParameter(receiverParameterName);
            object5.add(object);
        }
        for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
            object = targetList2;
            object2 = new JsParameter($receiver.getNameForDescriptor(valueParameter));
            JsParameter $receiver2 = (JsParameter)object2;
            MetadataProperties.setHasDefaultValue($receiver2, DescriptorUtilsKt.hasDefaultValue(valueParameter));
            object.add(object2);
        }
        VariableDescriptor continuationDescriptor = $receiver.getContinuationParameterDescriptor();
        if (continuationDescriptor != null) {
            JsParameter jsParameter = new JsParameter($receiver.getNameForDescriptor(continuationDescriptor));
            object = targetList2;
            object.add(jsParameter);
        }
        TranslationContext translationContext = $receiver.innerContextWithDescriptorsAliased(aliases);
        Intrinsics.checkExpressionValueIsNotNull(translationContext, "this.innerContextWithDescriptorsAliased(aliases)");
        return translationContext;
    }

    private static final List<TypeParameterDescriptor> getCorrectTypeParameters(@NotNull FunctionDescriptor $receiver) {
        List<TypeParameterDescriptor> list2;
        FunctionDescriptor functionDescriptor = $receiver;
        if (!(functionDescriptor instanceof PropertyAccessorDescriptor)) {
            functionDescriptor = null;
        }
        if ((list2 = (PropertyAccessorDescriptor)functionDescriptor) == null || (list2 = list2.getCorrespondingProperty()) == null || (list2 = list2.getTypeParameters()) == null) {
            list2 = $receiver.getTypeParameters();
        }
        return list2;
    }

    private static final boolean getRequiresExtensionReceiverParameter(@NotNull FunctionDescriptor $receiver) {
        return DescriptorUtils.isExtension($receiver);
    }

    public static final void translateFunction(@NotNull TranslationContext $receiver, @NotNull KtDeclarationWithBody declaration, @NotNull JsFunction function2) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        FunctionDescriptor descriptor2 = BindingUtils.getFunctionDescriptor($receiver.bindingContext(), declaration);
        if (declaration.hasBody()) {
            JsBlock body = FunctionBodyTranslator.translateFunctionBody(descriptor2, declaration, $receiver);
            Collection collection = function2.getBody().getStatements();
            List<JsStatement> list2 = body.getStatements();
            Intrinsics.checkExpressionValueIsNotNull(list2, "body.statements");
            Iterable iterable = list2;
            CollectionsKt.addAll(collection, iterable);
        }
        MetadataProperties.setFunctionDescriptor(function2, descriptor2);
    }

    @NotNull
    public static final JsExpression wrapWithInlineMetadata(@NotNull TranslationContext $receiver, @NotNull JsFunction function2, @NotNull FunctionDescriptor descriptor2) {
        JsExpression jsExpression;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(function2, "function");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        if (CallExpressionTranslator.shouldBeInlined(descriptor2, $receiver) && DescriptorUtilsKt.isEffectivelyPublicApi(descriptor2)) {
            InlineMetadata metadata2 = InlineMetadata.Companion.compose(function2, descriptor2);
            jsExpression = metadata2.getFunctionWithMetadata();
        } else {
            jsExpression = function2;
        }
        return jsExpression;
    }
}

