"""
Pympc is a client for Music Player Daemon.
Copyright (C) 2004  Magnus Bjernstad <bjernstad@gmail.com>

This file is part of Pympc.

Pympc is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

Pympc is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Pympc; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
import gtk

class SimpleInputDialog(gtk.Dialog):
    def __init__(self, app, parent, title, message):
        gtk.Dialog.__init__(self, title, parent, gtk.DIALOG_MODAL | 
                gtk.DIALOG_DESTROY_WITH_PARENT | gtk.DIALOG_NO_SEPARATOR,
                (gtk.STOCK_CANCEL, gtk.RESPONSE_REJECT, gtk.STOCK_OK,
                    gtk.RESPONSE_ACCEPT))
        self.app = app
        self.set_default_response(gtk.RESPONSE_ACCEPT)
        self.set_border_width(6)
        self.set_resizable(False)
        label = gtk.Label()
        label.set_markup('<span weight="bold" size="larger">' + message + '</span>')
        self.vbox.pack_start(label)
        self.vbox.set_spacing(12)
        self.connect('close', self.__on_diag_close)

    def __on_diag_close(self, dialog):
        dialog.emit('response', gtk.RESPONSE_REJECT)

    def start(self):
        self.show_all()
        self.run()
        self.hide()
        self.destroy()
