/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import org.apache.log4j.Logger;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.extension.filter.Filter;
import org.parosproxy.paros.extension.filter.FilterDialog;
import org.parosproxy.paros.extension.filter.FilterFactory;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.zaproxy.zap.view.ZapMenuItem;

public class ExtensionFilter
extends ExtensionAdaptor
implements ProxyListener,
Runnable {
    private static final Logger log = Logger.getLogger(ExtensionFilter.class);
    public static final String NAME = "ExtensionFilter";
    public static final int PROXY_LISTENER_ORDER = 0;
    private ZapMenuItem menuToolsFilter = null;
    private FilterFactory filterFactory = new FilterFactory();
    private boolean isStop = false;

    public ExtensionFilter() {
        this.setOrder(8);
    }

    @Override
    public void init() {
        this.setName(NAME);
        this.filterFactory.loadAllFilter();
        Thread thread = new Thread((Runnable)this, "ZAP-ExtensionFilter");
        thread.setDaemon(true);
        thread.start();
    }

    @Override
    public void initModel(Model model) {
        super.initModel(model);
        Filter filter = null;
        List<Filter> list = this.filterFactory.getAllFilter();
        for (int i = 0; i < list.size(); ++i) {
            filter = list.get(i);
            try {
                filter.init(model);
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)"Error initializing filter. Continuing.", (Throwable)exception);
            }
        }
    }

    @Override
    public void initView(ViewDelegate viewDelegate) {
        super.initView(viewDelegate);
        Filter filter = null;
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                filter.initView(viewDelegate);
                continue;
            }
            catch (Exception exception) {
                log.warn((Object)"Error initializing view for filter. Continuing.", (Throwable)exception);
            }
        }
    }

    private ZapMenuItem getMenuToolsFilter() {
        if (this.menuToolsFilter == null) {
            this.menuToolsFilter = new ZapMenuItem("menu.tools.filter");
            this.menuToolsFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FilterDialog filterDialog = new FilterDialog(ExtensionFilter.this.getView().getMainFrame());
                    filterDialog.setAllFilters(ExtensionFilter.this.filterFactory.getAllFilter());
                    filterDialog.showDialog(false);
                }
            });
        }
        return this.menuToolsFilter;
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        if (this.getView() != null) {
            extensionHook.getHookMenu().addToolsMenuItem(this.getMenuToolsFilter());
        }
        extensionHook.addProxyListener(this);
    }

    @Override
    public int getArrangeableListenerOrder() {
        return 0;
    }

    @Override
    public boolean onHttpRequestSend(HttpMessage httpMessage) {
        Filter filter = null;
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return true;
            }
            case protect: {
                if (httpMessage.isInScope()) break;
                return true;
            }
        }
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                if (!filter.isEnabled()) continue;
                filter.onHttpRequestSend(httpMessage);
                continue;
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return true;
    }

    @Override
    public boolean onHttpResponseReceive(HttpMessage httpMessage) {
        Filter filter = null;
        switch (Control.getSingleton().getMode()) {
            case safe: {
                return true;
            }
            case protect: {
                if (httpMessage.isInScope()) break;
                return true;
            }
        }
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                if (!filter.isEnabled()) continue;
                filter.onHttpResponseReceive(httpMessage);
                continue;
            }
            catch (Exception exception) {
                log.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
        return true;
    }

    @Override
    public void destroy() {
        this.isStop = true;
        Filter filter = null;
        for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
            filter = this.filterFactory.getAllFilter().get(i);
            try {
                filter.destroy();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void run() {
        Filter filter = null;
        while (!this.isStop) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            for (int i = 0; i < this.filterFactory.getAllFilter().size(); ++i) {
                filter = this.filterFactory.getAllFilter().get(i);
                try {
                    if (!filter.isEnabled()) continue;
                    filter.timer();
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public String getAuthor() {
        return "Chinotec Technologies";
    }

    public void addFilter(Filter filter) {
        List<Filter> list = this.filterFactory.getAllFilter();
        int n = this.searchFilterIndex(list, filter.getId(), 0, list.size());
        if (n == -1) {
            list.add(filter);
        } else {
            list.add(n, filter);
        }
    }

    public void removeFilter(Filter filter) {
        List<Filter> list = this.filterFactory.getAllFilter();
        list.remove(filter);
    }

    private int searchFilterIndex(List<Filter> list, int n, int n2, int n3) {
        if (n3 <= n2) {
            return -1;
        }
        int n4 = (n2 + n3) / 2;
        int n5 = list.get(n4).getId();
        if (n5 > n) {
            return this.searchFilterIndex(list, n, n2, n4 - 1);
        }
        if (n5 < n) {
            return this.searchFilterIndex(list, n, n4 + 1, n3);
        }
        return n4 + 1;
    }

    @Override
    public boolean supportsDb(String string) {
        return true;
    }
}

