/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.globalexcludeurl;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SortOrder;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.OptionsParam;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.extension.globalexcludeurl.DialogAddToken;
import org.zaproxy.zap.extension.globalexcludeurl.DialogModifyToken;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParam;
import org.zaproxy.zap.extension.globalexcludeurl.GlobalExcludeURLParamToken;
import org.zaproxy.zap.extension.globalexcludeurl.OptionsGlobalExcludeURLTableModel;
import org.zaproxy.zap.view.AbstractMultipleOptionsTablePanel;

public class OptionsGlobalExcludeURLPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private GlobalExcludeURLMultipleOptionsPanel tokensOptionsPanel;
    private OptionsGlobalExcludeURLTableModel globalExcludeURLModel = null;
    private static Logger log = Logger.getLogger(OptionsGlobalExcludeURLPanel.class);

    public OptionsGlobalExcludeURLPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName(Constant.messages.getString("options.globalexcludeurl.title"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 1;
        this.add((Component)new JLabel(Constant.messages.getString("options.globalexcludeurl.label.tokens")), gridBagConstraints);
        this.tokensOptionsPanel = new GlobalExcludeURLMultipleOptionsPanel(this.getGlobalExcludeURLModel());
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tokensOptionsPanel, gridBagConstraints);
    }

    @Override
    public void initParam(Object object) {
        OptionsParam optionsParam = (OptionsParam)object;
        GlobalExcludeURLParam globalExcludeURLParam = optionsParam.getGlobalExcludeURLParam();
        this.getGlobalExcludeURLModel().setTokens(globalExcludeURLParam.getTokens());
        this.tokensOptionsPanel.setRemoveWithoutConfirmation(!globalExcludeURLParam.isConfirmRemoveToken());
    }

    @Override
    public void validateParam(Object object) throws Exception {
    }

    @Override
    public void saveParam(Object object) throws Exception {
        OptionsParam optionsParam = (OptionsParam)object;
        GlobalExcludeURLParam globalExcludeURLParam = optionsParam.getGlobalExcludeURLParam();
        globalExcludeURLParam.setTokens(this.getGlobalExcludeURLModel().getElements());
        globalExcludeURLParam.setConfirmRemoveToken(!this.tokensOptionsPanel.isRemoveWithoutConfirmation());
        globalExcludeURLParam.parse();
        List<String> list = globalExcludeURLParam.getTokensNames();
        Model.getSingleton().getSession().setGlobalExcludeURLRegexs(list);
        Model.getSingleton().getSession().forceGlobalExcludeURLRefresh();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Done saving Global Exclude URL: " + list.toString()));
        }
    }

    private OptionsGlobalExcludeURLTableModel getGlobalExcludeURLModel() {
        if (this.globalExcludeURLModel == null) {
            this.globalExcludeURLModel = new OptionsGlobalExcludeURLTableModel();
        }
        return this.globalExcludeURLModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.globalexcludeurl";
    }

    private static class GlobalExcludeURLMultipleOptionsPanel
    extends AbstractMultipleOptionsTablePanel<GlobalExcludeURLParamToken> {
        private static final long serialVersionUID = -115340627058929308L;
        private static final String REMOVE_DIALOG_TITLE = Constant.messages.getString("options.globalexcludeurl.dialog.token.remove.title");
        private static final String REMOVE_DIALOG_TEXT = Constant.messages.getString("options.globalexcludeurl.dialog.token.remove.text");
        private static final String REMOVE_DIALOG_CONFIRM_BUTTON_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.remove.button.confirm");
        private static final String REMOVE_DIALOG_CANCEL_BUTTON_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.remove.button.cancel");
        private static final String REMOVE_DIALOG_CHECKBOX_LABEL = Constant.messages.getString("options.globalexcludeurl.dialog.token.remove.checkbox.label");
        private DialogAddToken addDialog = null;
        private DialogModifyToken modifyDialog = null;
        private OptionsGlobalExcludeURLTableModel model;

        public GlobalExcludeURLMultipleOptionsPanel(OptionsGlobalExcludeURLTableModel optionsGlobalExcludeURLTableModel) {
            super(optionsGlobalExcludeURLTableModel);
            this.model = optionsGlobalExcludeURLTableModel;
            this.getTable().getColumnExt(0).setPreferredWidth(25);
            this.getTable().getColumnExt(1).setPreferredWidth(350);
            this.getTable().getColumnExt(2).setPreferredWidth(300);
            this.getTable().setHorizontalScrollEnabled(true);
            this.getTable().setAutoCreateRowSorter(true);
            this.getTable().setSortOrder(1, SortOrder.ASCENDING);
        }

        @Override
        public GlobalExcludeURLParamToken showAddDialogue() {
            if (this.addDialog == null) {
                this.addDialog = new DialogAddToken(View.getSingleton().getOptionsDialog(null));
                this.addDialog.pack();
            }
            this.addDialog.setTokens(this.model.getElements());
            this.addDialog.setVisible(true);
            GlobalExcludeURLParamToken globalExcludeURLParamToken = this.addDialog.getToken();
            this.addDialog.clear();
            return globalExcludeURLParamToken;
        }

        @Override
        public GlobalExcludeURLParamToken showModifyDialogue(GlobalExcludeURLParamToken globalExcludeURLParamToken) {
            if (this.modifyDialog == null) {
                this.modifyDialog = new DialogModifyToken(View.getSingleton().getOptionsDialog(null));
                this.modifyDialog.pack();
            }
            this.modifyDialog.setTokens(this.model.getElements());
            this.modifyDialog.setToken(globalExcludeURLParamToken);
            this.modifyDialog.setVisible(true);
            GlobalExcludeURLParamToken globalExcludeURLParamToken2 = this.modifyDialog.getToken();
            this.modifyDialog.clear();
            if (!globalExcludeURLParamToken2.equals(globalExcludeURLParamToken)) {
                return globalExcludeURLParamToken2;
            }
            return null;
        }

        @Override
        public boolean showRemoveDialogue(GlobalExcludeURLParamToken globalExcludeURLParamToken) {
            JCheckBox jCheckBox = new JCheckBox(REMOVE_DIALOG_CHECKBOX_LABEL);
            Object[] objectArray = new Object[]{REMOVE_DIALOG_TEXT, " ", jCheckBox};
            int n = JOptionPane.showOptionDialog(View.getSingleton().getMainFrame(), objectArray, REMOVE_DIALOG_TITLE, 2, 3, null, new String[]{REMOVE_DIALOG_CONFIRM_BUTTON_LABEL, REMOVE_DIALOG_CANCEL_BUTTON_LABEL}, null);
            if (n == 0) {
                this.setRemoveWithoutConfirmation(jCheckBox.isSelected());
                return true;
            }
            return false;
        }
    }
}

