/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.filters;

import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.model.SiteNode;
import org.zaproxy.zap.spider.filters.FetchFilter;

public class MaxChildrenFetchFilter
extends FetchFilter {
    private int maxChildren = -1;
    private Model model;

    @Override
    public FetchFilter.FetchStatus checkFilter(URI uRI) {
        log.debug((Object)("Checking: " + uRI));
        SiteNode siteNode = this.model.getSession().getSiteTree().findClosestParent(uRI);
        if (siteNode != null && this.maxChildren > 0 && siteNode.getChildCount() > this.maxChildren) {
            return FetchFilter.FetchStatus.USER_RULES;
        }
        return FetchFilter.FetchStatus.VALID;
    }

    public void setMaxChildren(int n) {
        this.maxChildren = n;
    }

    public void setModel(Model model) {
        this.model = model;
    }
}

