#ifndef EFL_LOOP_EO_HH
#define EFL_LOOP_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_loop.eo.h"
#include "eo_base.eo.h"
#include "eo_class.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "eo_base.eo.hh"
#include "eo_class.eo.hh"
namespace efl { 
struct Loop;
} 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::Loop> : ::std::true_type {}; } }

namespace eo_cxx {
namespace efl { 
struct Loop {
   ::efl::eolian::return_traits< ::efl::Loop>::type main_get() const;
   ::efl::eolian::return_traits<void>::type iterate() const;
   ::efl::eolian::return_traits<int>::type iterate_may_block( ::efl::eolian::in_traits<int>::type may_block) const;
   ::efl::eolian::return_traits< unsigned char>::type begin() const;
   ::efl::eolian::return_traits<void>::type quit( ::efl::eolian::in_traits< unsigned char>::type exit_code) const;
   ::efl::eolian::return_traits< ::efl::eina::future<void*>>::type job( ::efl::eolian::in_traits<void const*>::type data) const;
   ::efl::eolian::return_traits< ::efl::eina::future<void*>>::type timeout( ::efl::eolian::in_traits<double>::type time,  ::efl::eolian::in_traits<void const*>::type data) const;
   ::efl::eolian::return_traits<bool>::type cxx_register( ::efl::eolian::in_traits< ::eo::Class>::type klass,  ::efl::eolian::in_traits< ::eo::Base>::type provider) const;
   ::efl::eolian::return_traits<bool>::type unregister( ::efl::eolian::in_traits< ::eo::Class>::type klass,  ::efl::eolian::in_traits< ::eo::Base>::type provider) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_LOOP_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::Loop() const;
   operator ::efl::Loop&();
   operator ::efl::Loop const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Loop,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Loop const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
} 
}
namespace efl { 
struct Loop : ::efl::eo::concrete
   , EO_CXX_INHERIT( ::eo::Base)
{
   explicit Loop( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Loop(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Loop(Loop const& other) = default;
   Loop(Loop&& other) = default;
   Loop& operator=(Loop const& other) = default;
   Loop& operator=(Loop&& other) = default;
   Loop()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Loop( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Loop(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits< ::efl::Loop>::type main_get() const;
   ::efl::eolian::return_traits<void>::type iterate() const;
   ::efl::eolian::return_traits<int>::type iterate_may_block( ::efl::eolian::in_traits<int>::type may_block) const;
   ::efl::eolian::return_traits< unsigned char>::type begin() const;
   ::efl::eolian::return_traits<void>::type quit( ::efl::eolian::in_traits< unsigned char>::type exit_code) const;
   ::efl::eolian::return_traits< ::efl::eina::future<void*>>::type job( ::efl::eolian::in_traits<void const*>::type data) const;
   ::efl::eolian::return_traits< ::efl::eina::future<void*>>::type timeout( ::efl::eolian::in_traits<double>::type time,  ::efl::eolian::in_traits<void const*>::type data) const;
   ::efl::eolian::return_traits<bool>::type cxx_register( ::efl::eolian::in_traits< ::eo::Class>::type klass,  ::efl::eolian::in_traits< ::eo::Base>::type provider) const;
   ::efl::eolian::return_traits<bool>::type unregister( ::efl::eolian::in_traits< ::eo::Class>::type klass,  ::efl::eolian::in_traits< ::eo::Base>::type provider) const;
   static Eo_Class const* _eo_class()
   {
      return EFL_LOOP_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct idle_enter_event
   {
      static Eo_Event_Description const* description()
      { return EFL_LOOP_EVENT_IDLE_ENTER; }
      typedef void parameter_type;
   } const idle_enter_event;
   static struct idle_exit_event
   {
      static Eo_Event_Description const* description()
      { return EFL_LOOP_EVENT_IDLE_EXIT; }
      typedef void parameter_type;
   } const idle_exit_event;
   static struct idle_event
   {
      static Eo_Event_Description const* description()
      { return EFL_LOOP_EVENT_IDLE; }
      typedef void parameter_type;
   } const idle_event;
   static struct arguments_event
   {
      static Eo_Event_Description const* description()
      { return EFL_LOOP_EVENT_ARGUMENTS; }
      typedef Efl_Loop_Arguments parameter_type;
   } const arguments_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Loop,  ::eo::Base> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Loop const ,  ::eo::Base const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Loop) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Loop>::value, "");
} 
#include "efl_loop.eo.impl.hh"
#endif
