/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.AbstractLdapNamingEnumeration;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.SearchResultWithControls;
import com.sun.jndi.toolkit.ctx.Continuation;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Vector;
import javax.naming.CompositeName;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.spi.DirectoryManager;

final class LdapSearchEnumeration
extends AbstractLdapNamingEnumeration<SearchResult> {
    private Name startName;
    private LdapCtx.SearchArgs searchArgs = null;
    private final AccessControlContext acc = AccessController.getContext();

    LdapSearchEnumeration(LdapCtx ldapCtx, LdapResult ldapResult, String string, LdapCtx.SearchArgs searchArgs, Continuation continuation) throws NamingException {
        super(ldapCtx, ldapResult, searchArgs.name, continuation);
        this.startName = new LdapName(string);
        this.searchArgs = searchArgs;
    }

    @Override
    protected SearchResult createItem(String string, final Attributes attributes, Vector<Control> vector) throws NamingException {
        Object object;
        String string2;
        String string3;
        Name name;
        Object object2 = null;
        boolean bl = true;
        try {
            name = new LdapName(string);
            if (this.startName != null && name.startsWith(this.startName)) {
                string3 = name.getSuffix(this.startName.size()).toString();
                string2 = name.getSuffix(this.homeCtx.currentParsedDN.size()).toString();
            } else {
                bl = false;
                string2 = string3 = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, string, this.homeCtx.hasLdapsScheme);
            }
        }
        catch (NamingException namingException) {
            bl = false;
            string2 = string3 = LdapURL.toUrlString(this.homeCtx.hostname, this.homeCtx.port_number, string, this.homeCtx.hasLdapsScheme);
        }
        name = new CompositeName();
        if (!string3.equals("")) {
            ((CompositeName)name).add(string3);
        }
        CompositeName compositeName = new CompositeName();
        if (!string2.equals("")) {
            compositeName.add(string2);
        }
        this.homeCtx.setParents(attributes, compositeName);
        if (this.searchArgs.cons.getReturningObjFlag()) {
            if (attributes.get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                try {
                    object2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws NamingException {
                            return Obj.decodeObject(attributes);
                        }
                    }, this.acc);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    throw (NamingException)privilegedActionException.getException();
                }
            }
            if (object2 == null) {
                object2 = new LdapCtx(this.homeCtx, string);
            }
            try {
                object2 = DirectoryManager.getObjectInstance(object2, compositeName, bl ? this.homeCtx : null, this.homeCtx.envprops, attributes);
            }
            catch (NamingException namingException) {
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("problem generating object using object factory");
                namingException.setRootCause(exception);
                throw namingException;
            }
            object = this.searchArgs.reqAttrs;
            if (this.searchArgs.reqAttrs != null) {
                int n;
                BasicAttributes basicAttributes = new BasicAttributes(true);
                for (n = 0; n < ((String[])object).length; ++n) {
                    basicAttributes.put(object[n], null);
                }
                for (n = 0; n < Obj.JAVA_ATTRIBUTES.length; ++n) {
                    if (basicAttributes.get(Obj.JAVA_ATTRIBUTES[n]) != null) continue;
                    attributes.remove(Obj.JAVA_ATTRIBUTES[n]);
                }
            }
        }
        object = vector != null ? new SearchResultWithControls(bl ? ((CompositeName)name).toString() : string3, object2, attributes, bl, this.homeCtx.convertControls(vector)) : new SearchResult(bl ? ((CompositeName)name).toString() : string3, object2, attributes, bl);
        object.setNameInNamespace(string);
        return object;
    }

    @Override
    public void appendUnprocessedReferrals(LdapReferralException ldapReferralException) {
        this.startName = null;
        super.appendUnprocessedReferrals(ldapReferralException);
    }

    @Override
    protected AbstractLdapNamingEnumeration<? extends NameClassPair> getReferredResults(LdapReferralContext ldapReferralContext) throws NamingException {
        return (AbstractLdapNamingEnumeration)ldapReferralContext.search(this.searchArgs.name, this.searchArgs.filter, this.searchArgs.cons);
    }

    @Override
    protected void update(AbstractLdapNamingEnumeration<? extends NameClassPair> abstractLdapNamingEnumeration) {
        super.update(abstractLdapNamingEnumeration);
        LdapSearchEnumeration ldapSearchEnumeration = (LdapSearchEnumeration)abstractLdapNamingEnumeration;
        this.startName = ldapSearchEnumeration.startName;
    }

    void setStartName(Name name) {
        this.startName = name;
    }
}

