/*
 * Copyright (c) 1997, 2015, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * (C) Copyright Taligent, Inc. 1996, 1997 - All Rights Reserved
 * (C) Copyright IBM Corp. 1996 - 1998 - All Rights Reserved
 *
 * The original version of this source code and documentation
 * is copyrighted and owned by Taligent, Inc., a wholly-owned
 * subsidiary of IBM. These materials are provided under terms
 * of a License Agreement between Taligent and Sun. This technology
 * is protected by multiple US and International patents.
 *
 * This notice and attribution to Taligent may not be removed.
 * Taligent is a registered trademark of Taligent, Inc.
 *
 */

package sun.util.resources;

public final class TimeZoneNames_de extends TimeZoneNamesBundle {

    protected final Object[][] getContents() {
        String ACT[] = new String[] {"Acre Normalzeit", "ACT",
                                     "Acre Sommerzeit", "ACST"};
        String ADELAIDE[] = new String[] {"Zentrale Normalzeit (S\u00FCdaustralien)", "ACST",
                                          "Zentrale Sommerzeit (S\u00FCdaustralien)", "ACDT"};
        String AGT[] = new String[] {"Argentinische Zeit", "ART",
                                     "Argentinische Sommerzeit", "ARST"};
        String AKST[] = new String[] {"Alaska Normalzeit", "AKST",
                                      "Alaska Sommerzeit", "AKDT"};
        String AMT[] = new String[] {"Amazonas Normalzeit", "AMT",
                                     "Amazonas Sommerzeit", "AMST"};
        String ARAST[] = new String[] {"Arabische Normalzeit", "AST",
                                       "Arabische Sommerzeit", "ADT"};
        String ARMT[] = new String[] {"Armenische Zeit", "AMT",
                                      "Armenische Sommerzeit", "AMST"};
        String AST[] = new String[] {"Atlantik Normalzeit", "AST",
                                     "Atlantik Sommerzeit", "ADT"};
        String BDT[] = new String[] {"Bangladesch Zeit", "BDT",
                                     "Bangladesch Sommerzeit", "BDST"};
        String BRISBANE[] = new String[] {"\u00D6stliche Normalzeit (Queensland)", "AEST",
                                          "\u00D6stliche Sommerzeit (Queensland)", "AEDT"};
        String BROKEN_HILL[] = new String[] {"Zentrale Normalzeit (S\u00FCdaustralien/New South Wales)", "ACST",
                                             "Zentrale Sommerzeit (S\u00FCdaustralien/New South Wales)", "ACDT"};
        String BRT[] = new String[] {"Brasilianische Zeit", "BRT",
                                     "Brasilianische Sommerzeit", "BRST"};
        String BTT[] = new String[] {"Bhutanische Zeit", "BTT",
                                     "Bhutanische Sommerzeit", "BTST"};
        String CAT[] = new String[] {"Zentralafrikanische Zeit", "CAT",
                                     "Zentralafrikanische Sommerzeit", "CAST"};
        String CET[] = new String[] {"Mitteleurop\u00e4ische Zeit", "MEZ",
                                     "Mitteleurop\u00e4ische Sommerzeit", "MESZ"};
        String CHAST[] = new String[] {"Chatham Normalzeit", "CHAST",
                                       "Chatham Sommerzeit", "CHADT"};
        String ChST[] = new String[] {"Chamorro Normalzeit", "ChST",
                      "Chamorro Sommerzeit", "ChDT"};
        String CHUT[] = new String[] {"Chuuk Zeit", "CHUT",
                                      "Chuuk Sommerzeit", "CHUST"};
        String CIT[] = new String[] {"Zentralindonesische Zeit", "WITA",
                                     "Zentralindonesische Sommerzeit", "CIST"};
        String CLT[] = new String[] {"Chilenische Zeit", "CLT",
                                     "Chilenische Sommerzeit", "CLST"};
        String CST[] = new String[] {"Zentrale Normalzeit", "CST",
                                     "Zentrale Sommerzeit", "CDT"};
        String CTT[] = new String[] {"Chinesische Normalzeit", "CST",
                                     "Chinesische Sommerzeit", "CDT"};
        String CUBA[] = new String[] {"Kubanische Normalzeit", "CST",
                                      "Kubanische Sommerzeit", "CDT"};
        String DARWIN[] = new String[] {"Zentrale Normalzeit (Northern Territory)", "ACST",
                                        "Zentrale Sommerzeit (Northern Territory)", "ACDT"};
        String DUBLIN[] = new String[] {"Greenwich Zeit", "GMT",
                                        "Irische Sommerzeit", "IST"};
        String EAT[] = new String[] {"Ostafrikanische Zeit", "EAT",
                                     "Ostafrikanische Sommerzeit", "EAST"};
        String EASTER[] = new String[] {"Osterinseln Zeit", "EAST",
                                        "Osterinseln Sommerzeit", "EASST"};
        String EET[] = new String[] {"Osteurop\u00e4ische Zeit", "OEZ",
                                     "Osteurop\u00e4ische Sommerzeit", "OESZ"};
        String EGT[] = new String[] {"Ostgr\u00f6nl\u00e4ndische Zeit", "EGT",
                                     "Ostgr\u00f6nl\u00e4ndische Sommerzeit", "EGST"};
        String EST[] = new String[] {"\u00d6stliche Normalzeit", "EST",
                                     "\u00d6stliche Sommerzeit", "EDT"};
        String EST_NSW[] = new String[] {"\u00D6stliche Normalzeit (New South Wales)", "AEST",
                                         "\u00D6stliche Sommerzeit (New South Wales)", "AEDT"};
        String FET[] = new String[] {"Kaliningrader Zeit", "FET",
                                     "Kaliningrader Sommerzeit", "FEST"};
        String GHMT[] = new String[] {"Ghanaische Normalzeit", "GMT",
                                      "Ghanaische Sommerzeit", "GHST"};
        String GAMBIER[] =  new String[] {"Gambier Zeit", "GAMT",
                                          "Gambier Sommerzeit", "GAMST"};
        String GMT[] = new String[] {"Greenwich Zeit", "GMT",
                                   "Greenwich Zeit", "GMT"};
        String GMTBST[] = new String[] {"Greenwich Zeit", "GMT",
                                        "Britische Sommerzeit", "BST"};
        String GST[] = new String[] {"Golf Normalzeit", "GST",
                                     "Golf Sommerzeit", "GDT"};
        String HKT[] =  new String[] {"Hongkong Zeit", "HKT",
                                      "Hongkong Sommerzeit", "HKST"};
        String HST[] = new String[] {"Hawaii Normalzeit", "HST",
                                     "Hawaii Sommerzeit", "HDT"};
        String ICT[] = new String[] {"Indochina Zeit", "ICT",
                                     "Indochina Sommerzeit", "ICST"};
        String IRT[] = new String[] {"Iranische Normalzeit", "IRST",
                                     "Iranische Sommerzeit", "IRDT"};
        String ISRAEL[] = new String[] {"Israelische Normalzeit", "IST",
                                        "Israelische Sommerzeit", "IDT"};
        String IST[] = new String[] {"Indische Normalzeit", "IST",
                                     "Indische Sommerzeit", "IDT"};
        String JST[] = new String[] {"Japanische Normalzeit", "JST",
                                     "Japanische Sommerzeit", "JDT"};
        String KRAT[] = new String[] {"Krasnojarsker Zeit", "KRAT",
                                      "Krasnojarsker Sommerzeit", "KRAST"};
        String KST[] = new String[] {"Koreanische Normalzeit", "KST",
                                     "Koreanische Sommerzeit", "KDT"};
        String LORD_HOWE[] = new String[] {"Lord Howe Normalzeit", "LHST",
                                           "Lord Howe Sommerzeit", "LHDT"};
        String MHT[] = new String[] {"Marshallinseln Zeit", "MHT",
                                     "Marshallinseln Sommerzeit", "MHST"};
        String MMT[] = new String[] {"Myanmar Zeit", "MMT",
                                     "Myanmar Sommerzeit", "MMST"};
        String MSK[] = new String[] {"Moskauer Normalzeit", "MSK",
                                     "Moskauer Sommerzeit", "MSD"};
        String MST[] = new String[] {"Rocky Mountains Normalzeit", "MST",
                                     "Rocky Mountains Sommerzeit", "MDT"};
        String MYT[] = new String[] {"Malaysische Zeit", "MYT",
                                     "Malaysische Sommerzeit", "MYST"};
        String NORONHA[] = new String[] {"Fernando de Noronha Zeit", "FNT",
                                         "Fernando de Noronha Sommerzeit", "FNST"};
        String NOVT[] = new String[] {"Nowosibirsker Zeit", "NOVT",
                                      "Nowosibirsker Sommerzeit", "NOVST"};
        String NPT[] = new String[] {"Nepalesische Zeit", "NPT",
                                     "Nepalesische Sommerzeit", "NPST"};
        String NST[] = new String[] {"Neufundland Normalzeit", "NST",
                                     "Neufundland Sommerzeit", "NDT"};
        String NZST[] = new String[] {"Neuseeland Normalzeit", "NZST",
                                      "Neuseeland Sommerzeit", "NZDT"};
        String PITCAIRN[] = new String[] {"Pitcairn Normalzeit", "PST",
                                          "Pitcairn Sommerzeit", "PDT"};
        String PKT[] = new String[] {"Pakistanische Zeit", "PKT",
                                     "Pakistanische Sommerzeit", "PKST"};
        String PONT[] = new String[] {"Pohnpei Zeit", "PONT",
                                      "Pohnpei Sommerzeit", "PONST"};
        String PST[] = new String[] {"Pazifische Normalzeit", "PST",
                                     "Pazifische Sommerzeit", "PDT"};
        String SAMOA[] = new String[] {"Samoa Normalzeit", "SST",
                                       "Samoa Sommerzeit", "SDT"};
        String IRKT[] = new String[] {"Irkutsk Zeit", "IRKT",
                                      "Irkutsk Sommerzeit", "IRKST"};
        String SAST[] = new String[] {"S\u00fcdafrikanische Normalzeit", "SAST",
                                      "S\u00fcdafrikanische Sommerzeit", "SAST"};
        String SBT[] = new String[] {"Salomoninseln Zeit", "SBT",
                                     "Salomoninseln Sommerzeit", "SBST"};
        String SGT[] = new String[] {"Singapur Zeit", "SGT",
                                     "Singapur Sommerzeit", "SGST"};
        String TASMANIA[] = new String[] {"\u00D6stliche Normalzeit (Tasmanien)", "AEST",
                                          "\u00D6stliche Sommerzeit (Tasmanien)", "AEDT"};
        String TMT[] = new String[] {"Turkmenische Zeit", "TMT",
                                     "Turkmenische Sommerzeit", "TMST"};
        String ULAT[]= new String[] {"Ulaanbaatar Zeit", "ULAT",
                                     "Ulaanbaatar Sommerzeit", "ULAST"};
        String UTC[] = new String[] {"Koordinierte Universalzeit", "UTC",
                                     "Koordinierte Universalzeit", "UTC"};
        String UZT[] = new String[] {"Usbekistan Zeit", "UZT",
                                     "Usbekistan Sommerzeit", "UZST"};
        String VICTORIA[] = new String[] {"\u00D6stliche Normalzeit (Victoria)", "AEST",
                                          "\u00D6stliche Sommerzeit (Victoria)", "AEDT"};
        String VLAT[] = new String[] {"Wladiwostok Zeit", "VLAT",
                                      "Wladiwostok Sommerzeit", "VLAST"};
        String WAT[] = new String[] {"Westafrikanische Zeit", "WAT",
                                     "Westafrikanische Sommerzeit", "WAST"};
        String WET[] = new String[] {"Westeurop\u00e4ische Zeit", "WEZ",
                                     "Westeurop\u00e4ische Sommerzeit", "WESZ"};
        String WIT[] = new String[] {"Westindonesische Zeit", "WIB",
                                     "Westindonesische Sommerzeit", "WIST"};
        String WST_AUS[] = new String[] {"Westliche Normalzeit (Australien)", "AWST",
                                         "Westliche Sommerzeit (Australien)", "AWDT"};
        String WST_SAMOA[] = new String[] {"West Samoa Zeit", "WSST",
                                           "West Samoa Sommerzeit", "WSDT"};
        String XJT[] = new String[] {"Chinesische Normalzeit", "XJT",
                                     "Chinesische Sommerzeit", "XJDT"};
        String YAKT[] = new String[] {"Jakutsk Zeit", "YAKT",
                                      "Jakutsk Sommerzeit", "YAKST"};

        return new Object[][] {
            {"America/Los_Angeles", PST},
            {"PST", PST},
            {"America/Denver", MST},
            {"MST", MST},
            {"America/Phoenix", MST},
            {"PNT", MST},
            {"America/Chicago", CST},
            {"CST", CST},
            {"America/New_York", EST},
            {"EST", EST},
            {"America/Indianapolis", EST},
            {"IET", EST},
            {"Pacific/Honolulu", HST},
            {"HST", HST},
            {"America/Anchorage", AKST},
            {"AST", AKST},
            {"America/Halifax", AST},
            {"America/Sitka", AKST},
            {"America/St_Johns", NST},
            {"CNT", NST},
            {"Europe/Paris", CET},
            {"ECT", CET},
            {"GMT", GMT},
            {"Africa/Casablanca", WET},
            {"Asia/Jerusalem", ISRAEL},
            {"Asia/Tokyo", JST},
            {"JST", JST},
            {"Europe/Bucharest", EET},
            {"Asia/Shanghai", CTT},
            {"CTT", CTT},
            /* Don't change the order of the above zones
             * to keep compatibility with the previous version.
             */

            {"ACT", DARWIN},
            {"AET", EST_NSW},
            {"AGT", AGT},
            {"ART", EET},
            {"Africa/Abidjan", GMT},
            {"Africa/Accra", GHMT},
            {"Africa/Addis_Ababa", EAT},
            {"Africa/Algiers", CET},
            {"Africa/Asmara", EAT},
            {"Africa/Asmera", EAT},
            {"Africa/Bamako", GMT},
            {"Africa/Bangui", WAT},
            {"Africa/Banjul", GMT},
            {"Africa/Bissau", GMT},
            {"Africa/Blantyre", CAT},
            {"Africa/Brazzaville", WAT},
            {"Africa/Bujumbura", CAT},
            {"Africa/Cairo", EET},
            {"Africa/Ceuta", CET},
            {"Africa/Conakry", GMT},
            {"Africa/Dakar", GMT},
            {"Africa/Dar_es_Salaam", EAT},
            {"Africa/Djibouti", EAT},
            {"Africa/Douala", WAT},
            {"Africa/El_Aaiun", WET},
            {"Africa/Freetown", GMT},
            {"Africa/Gaborone", CAT},
            {"Africa/Harare", CAT},
            {"Africa/Johannesburg", SAST},
            {"Africa/Juba", EAT},
            {"Africa/Kampala", EAT},
            {"Africa/Khartoum", EAT},
            {"Africa/Kigali", CAT},
            {"Africa/Kinshasa", WAT},
            {"Africa/Lagos", WAT},
            {"Africa/Libreville", WAT},
            {"Africa/Lome", GMT},
            {"Africa/Luanda", WAT},
            {"Africa/Lubumbashi", CAT},
            {"Africa/Lusaka", CAT},
            {"Africa/Malabo", WAT},
            {"Africa/Maputo", CAT},
            {"Africa/Maseru", SAST},
            {"Africa/Mbabane", SAST},
            {"Africa/Mogadishu", EAT},
            {"Africa/Monrovia", GMT},
            {"Africa/Nairobi", EAT},
            {"Africa/Ndjamena", WAT},
            {"Africa/Niamey", WAT},
            {"Africa/Nouakchott", GMT},
            {"Africa/Ouagadougou", GMT},
            {"Africa/Porto-Novo", WAT},
            {"Africa/Sao_Tome", GMT},
            {"Africa/Timbuktu", GMT},
            {"Africa/Tripoli", EET},
            {"Africa/Tunis", CET},
            {"Africa/Windhoek", WAT},
            {"America/Adak", HST},
            {"America/Anguilla", AST},
            {"America/Antigua", AST},
            {"America/Araguaina", BRT},
            {"America/Argentina/Buenos_Aires", AGT},
            {"America/Argentina/Catamarca", AGT},
            {"America/Argentina/ComodRivadavia", AGT},
            {"America/Argentina/Cordoba", AGT},
            {"America/Argentina/Jujuy", AGT},
            {"America/Argentina/La_Rioja", AGT},
            {"America/Argentina/Mendoza", AGT},
            {"America/Argentina/Rio_Gallegos", AGT},
            {"America/Argentina/Salta", AGT},
            {"America/Argentina/San_Juan", AGT},
            {"America/Argentina/San_Luis", AGT},
            {"America/Argentina/Tucuman", AGT},
            {"America/Argentina/Ushuaia", AGT},
            {"America/Aruba", AST},
            {"America/Asuncion", new String[] {"Paraguay Zeit", "PYT",
                                               "Paraguay Sommerzeit", "PYST"}},
            {"America/Atikokan", EST},
            {"America/Atka", HST},
            {"America/Bahia", BRT},
            {"America/Bahia_Banderas", CST},
            {"America/Barbados", AST},
            {"America/Belem", BRT},
            {"America/Belize", CST},
            {"America/Blanc-Sablon", AST},
            {"America/Boa_Vista", AMT},
            {"America/Bogota", new String[] {"Kolumbianische Zeit", "COT",
                                             "Kolumbianische Sommerzeit", "COST"}},
            {"America/Boise", MST},
            {"America/Buenos_Aires", AGT},
            {"America/Cambridge_Bay", MST},
            {"America/Campo_Grande", AMT},
            {"America/Cancun", EST},
            {"America/Caracas", new String[] {"Venezuelanische Zeit", "VET",
                                              "Venezuelanische Sommerzeit", "VEST"}},
            {"America/Catamarca", AGT},
            {"America/Cayenne", new String[] {"Franz\u00f6sisch-Guiana Zeit", "GFT",
                                              "Franz\u00f6sisch-Guiana Sommerzeit", "GFST"}},
            {"America/Cayman", EST},
            {"America/Chihuahua", MST},
            {"America/Creston", MST},
            {"America/Coral_Harbour", EST},
            {"America/Cordoba", AGT},
            {"America/Costa_Rica", CST},
            {"America/Cuiaba", AMT},
            {"America/Curacao", AST},
            {"America/Danmarkshavn", GMT},
            {"America/Dawson", PST},
            {"America/Dawson_Creek", MST},
            {"America/Detroit", EST},
            {"America/Dominica", AST},
            {"America/Edmonton", MST},
            {"America/Eirunepe", ACT},
            {"America/El_Salvador", CST},
            {"America/Ensenada", PST},
            {"America/Fort_Nelson", MST},
            {"America/Fort_Wayne", EST},
            {"America/Fortaleza", BRT},
            {"America/Glace_Bay", AST},
            {"America/Godthab", new String[] {"Westgr\u00f6nl\u00e4ndische Zeit", "WGT",
                                              "Westgr\u00f6nl\u00e4ndische Sommerzeit", "WGST"}},
            {"America/Goose_Bay", AST},
            {"America/Grand_Turk", AST},
            {"America/Grenada", AST},
            {"America/Guadeloupe", AST},
            {"America/Guatemala", CST},
            {"America/Guayaquil", new String[] {"Ecuadorianische Zeit", "ECT",
                                                "Ecuadorianische Sommerzeit", "ECST"}},
            {"America/Guyana", new String[] {"Guyanische Zeit", "GYT",
                                             "Guyanische Sommerzeit", "GYST"}},
            {"America/Havana", CUBA},
            {"America/Hermosillo", MST},
            {"America/Indiana/Indianapolis", EST},
            {"America/Indiana/Knox", CST},
            {"America/Indiana/Marengo", EST},
            {"America/Indiana/Petersburg", EST},
            {"America/Indiana/Tell_City", CST},
            {"America/Indiana/Vevay", EST},
            {"America/Indiana/Vincennes", EST},
            {"America/Indiana/Winamac", EST},
            {"America/Inuvik", MST},
            {"America/Iqaluit", EST},
            {"America/Jamaica", EST},
            {"America/Jujuy", AGT},
            {"America/Juneau", AKST},
            {"America/Kentucky/Louisville", EST},
            {"America/Kentucky/Monticello", EST},
            {"America/Knox_IN", CST},
            {"America/Kralendijk", AST},
            {"America/La_Paz", new String[] {"Bolivianische Zeit", "BOT",
                                             "Bolivianische Sommerzeit", "BOST"}},
            {"America/Lima", new String[] {"Peruanische Zeit", "PET",
                                           "Peruanische Sommerzeit", "PEST"}},
            {"America/Louisville", EST},
            {"America/Lower_Princes", AST},
            {"America/Maceio", BRT},
            {"America/Managua", CST},
            {"America/Manaus", AMT},
            {"America/Marigot", AST},
            {"America/Martinique", AST},
            {"America/Matamoros", CST},
            {"America/Mazatlan", MST},
            {"America/Mendoza", AGT},
            {"America/Menominee", CST},
            {"America/Merida", CST},
            {"America/Metlakatla", AKST},
            {"America/Mexico_City", CST},
            {"America/Miquelon", new String[] {"Pierre & Miquelon Normalzeit", "PMST",
                                               "Pierre & Miquelon Sommerzeit", "PMDT"}},
            {"America/Moncton", AST},
            {"America/Montevideo", new String[] {"Uruguayische Zeit", "UYT",
                                                 "Uruguayische Sommerzeit", "UYST"}},
            {"America/Monterrey", CST},
            {"America/Montreal", EST},
            {"America/Montserrat", AST},
            {"America/Nassau", EST},
            {"America/Nipigon", EST},
            {"America/Nome", AKST},
            {"America/Noronha", NORONHA},
            {"America/North_Dakota/Beulah", CST},
            {"America/North_Dakota/Center", CST},
            {"America/North_Dakota/New_Salem", CST},
            {"America/Ojinaga", MST},
            {"America/Panama", EST},
            {"America/Pangnirtung", EST},
            {"America/Paramaribo", new String[] {"Suriname Zeit", "SRT",
                                                 "Suriname Sommerzeit", "SRST"}},
            {"America/Port-au-Prince", EST},
            {"America/Port_of_Spain", AST},
            {"America/Porto_Acre", ACT},
            {"America/Porto_Velho", AMT},
            {"America/Puerto_Rico", AST},
            {"America/Rainy_River", CST},
            {"America/Rankin_Inlet", CST},
            {"America/Recife", BRT},
            {"America/Regina", CST},
            {"America/Resolute", CST},
            {"America/Rio_Branco", ACT},
            {"America/Rosario", AGT},
            {"America/Santa_Isabel", PST},
            {"America/Santarem", BRT},
            {"America/Santiago", CLT},
            {"America/Santo_Domingo", AST},
            {"America/Sao_Paulo", BRT},
            {"America/Scoresbysund", EGT},
            {"America/Shiprock", MST},
            {"America/St_Barthelemy", AST},
            {"America/St_Kitts", AST},
            {"America/St_Lucia", AST},
            {"America/St_Thomas", AST},
            {"America/St_Vincent", AST},
            {"America/Swift_Current", CST},
            {"America/Tegucigalpa", CST},
            {"America/Thule", AST},
            {"America/Thunder_Bay", EST},
            {"America/Tijuana", PST},
            {"America/Toronto", EST},
            {"America/Tortola", AST},
            {"America/Vancouver", PST},
            {"America/Virgin", AST},
            {"America/Whitehorse", PST},
            {"America/Winnipeg", CST},
            {"America/Yakutat", AKST},
            {"America/Yellowknife", MST},
            {"Antarctica/Casey", WST_AUS},
            {"Antarctica/Davis", new String[] {"Davis Zeit", "DAVT",
                                               "Davis Sommerzeit", "DAVST"}},
            {"Antarctica/DumontDUrville", new String[] {"Dumont-d'Urville Zeit", "DDUT",
                                                        "Dumont-d'Urville Sommerzeit", "DDUST"}},
            {"Antarctica/Macquarie", new String[] {"Macquarieinsel Zeit", "MIST",
                                                   "Macquarieinsel Sommerzeit", "MIDT"}},
            {"Antarctica/Mawson", new String[] {"Mawson Zeit", "MAWT",
                                                "Mawson Sommerzeit", "MAWST"}},
            {"Antarctica/McMurdo", NZST},
            {"Antarctica/Palmer", CLT},
            {"Antarctica/Rothera", new String[] {"Rothera Zeit", "ROTT",
                                                 "Rothera Sommerzeit", "ROTST"}},
            {"Antarctica/South_Pole", NZST},
            {"Antarctica/Syowa", new String[] {"Syowa Zeit", "SYOT",
                                               "Syowa Sommerzeit", "SYOST"}},
            {"Antarctica/Troll", new String[] {"Koordinierte Universalzeit", "UTC",
                                               "Mitteleurop\u00e4ische Sommerzeit", "MESZ"}},
            {"Antarctica/Vostok", new String[] {"Vostok Zeit", "VOST",
                                                "Vostok Sommerzeit", "VOSST"}},
            {"Arctic/Longyearbyen", CET},
            {"Asia/Aden", ARAST},
            {"Asia/Almaty", new String[] {"Alma Ata Zeit", "ALMT",
                                          "Alma-Ata Sommerzeit", "ALMST"}},
            {"Asia/Amman", EET},
            {"Asia/Anadyr", new String[] {"Anadyr Zeit", "ANAT",
                                          "Anadyr Sommerzeit", "ANAST"}},
            {"Asia/Aqtau", new String[] {"Aqtau Zeit", "AQTT",
                                         "Aqtau Sommerzeit", "AQTST"}},
            {"Asia/Aqtobe", new String[] {"Aqtobe Zeit", "AQTT",
                                          "Aqtobe Sommerzeit", "AQTST"}},
            {"Asia/Ashgabat", TMT},
            {"Asia/Ashkhabad", TMT},
            {"Asia/Baghdad", ARAST},
            {"Asia/Bahrain", ARAST},
            {"Asia/Baku", new String[] {"Aserbaidschanische Zeit", "AZT",
                                        "Aserbaidschanische Sommerzeit", "AZST"}},
            {"Asia/Bangkok", ICT},
            {"Asia/Beirut", EET},
            {"Asia/Bishkek", new String[] {"Kirgisische Zeit", "KGT",
                                           "Kirgisische Sommerzeit", "KGST"}},
            {"Asia/Brunei", new String[] {"Brunei Zeit", "BNT",
                                          "Brunei Sommerzeit", "BNST"}},
            {"Asia/Calcutta", IST},
            {"Asia/Chita", YAKT},
            {"Asia/Choibalsan", new String[] {"Choibalsan Zeit", "CHOT",
                                              "Choibalsan Sommerzeit", "CHOST"}},
            {"Asia/Chongqing", CTT},
            {"Asia/Chungking", CTT},
            {"Asia/Colombo", IST},
            {"Asia/Dacca", BDT},
            {"Asia/Dhaka", BDT},
            {"Asia/Dili", new String[] {"Timor-Leste Normalzeit", "TLT",
                                        "Timor-Leste Sommerzeit", "TLST"}},
            {"Asia/Damascus", EET},
            {"Asia/Dubai", GST},
            {"Asia/Dushanbe", new String[] {"Tadschikische Zeit", "TJT",
                                            "Tadschikische Sommerzeit", "TJST"}},
            {"Asia/Gaza", EET},
            {"Asia/Harbin", CTT},
            {"Asia/Hebron", EET},
            {"Asia/Ho_Chi_Minh", ICT},
            {"Asia/Hong_Kong", HKT},
            {"Asia/Hovd", new String[] {"Hovd Zeit", "HOVT",
                                        "Hovd Sommerzeit", "HOVST"}},
            {"Asia/Irkutsk", IRKT},
            {"Asia/Istanbul", EET},
            {"Asia/Jakarta", WIT},
            {"Asia/Jayapura", new String[] {"Ostindonesische Zeit", "WIT",
                                            "Ostindonesische Sommerzeit", "EIST"}},
            {"Asia/Kabul", new String[] {"Afghanistanische Zeit", "AFT",
                                         "Afghanistanische Sommerzeit", "AFST"}},
            {"Asia/Kamchatka", new String[] {"Petropawlowsk-Kamtschatkische Zeit", "PETT",
                                             "Petropawlowsk-Kamtschatkische Sommerzeit", "PETST"}},
            {"Asia/Karachi", PKT},
            {"Asia/Kashgar", XJT},
            {"Asia/Kathmandu", NPT},
            {"Asia/Katmandu", NPT},
            {"Asia/Khandyga", YAKT},
            {"Asia/Kolkata", IST},
            {"Asia/Krasnoyarsk", KRAT},
            {"Asia/Kuala_Lumpur", MYT},
            {"Asia/Kuching", MYT},
            {"Asia/Kuwait", ARAST},
            {"Asia/Macao", CTT},
            {"Asia/Macau", CTT},
            {"Asia/Magadan", new String[] {"Magadanische Zeit", "MAGT",
                                           "Magadanische Sommerzeit", "MAGST"}},
            {"Asia/Makassar", CIT},
            {"Asia/Manila", new String[] {"Philippinische Zeit", "PHT",
                                          "Philippinische Sommerzeit", "PHST"}},
            {"Asia/Muscat", GST},
            {"Asia/Nicosia", EET},
            {"Asia/Novokuznetsk", KRAT},
            {"Asia/Novosibirsk", NOVT},
            {"Asia/Oral", new String[] {"Oral Zeit", "ORAT",
                                        "Oral Sommerzeit", "ORAST"}},
            {"Asia/Omsk", new String[] {"Omsk Zeit", "OMST",
                                        "Omsk Sommerzeit", "OMSST"}},
            {"Asia/Phnom_Penh", ICT},
            {"Asia/Pontianak", WIT},
            {"Asia/Pyongyang", KST},
            {"Asia/Qatar", ARAST},
            {"Asia/Qyzylorda", new String[] {"Qyzylorda Zeit", "QYZT",
                                             "Qyzylorda Sommerzeit", "QYZST"}},
            {"Asia/Rangoon", MMT},
            {"Asia/Riyadh", ARAST},
            {"Asia/Saigon", ICT},
            {"Asia/Sakhalin", new String[] {"Sakhalin Zeit", "SAKT",
                                            "Sakhalin Sommerzeit", "SAKST"}},
            {"Asia/Samarkand", UZT},
            {"Asia/Seoul", KST},
            {"Asia/Singapore", SGT},
            {"Asia/Srednekolymsk", new String[] {"Srednekolymsk Time", "SRET",
                                                 "Srednekolymsk Daylight Time", "SREDT"}},
            {"Asia/Taipei", CTT},
            {"Asia/Tel_Aviv", ISRAEL},
            {"Asia/Tashkent", UZT},
            {"Asia/Tbilisi", new String[] {"Georgische Zeit", "GET",
                                           "Georgische Sommerzeit", "GEST"}},
            {"Asia/Tehran", IRT},
            {"Asia/Thimbu", BTT},
            {"Asia/Thimphu", BTT},
            {"Asia/Ujung_Pandang", CIT},
            {"Asia/Ulaanbaatar", ULAT},
            {"Asia/Ulan_Bator", ULAT},
            {"Asia/Urumqi", XJT},
            {"Asia/Ust-Nera", new String[] {"Ust-Nera Zeit", "VLAT",
                                            "Ust-Nera Sommerzeit", "VLAST"}},
            {"Asia/Vientiane", ICT},
            {"Asia/Vladivostok", VLAT},
            {"Asia/Yakutsk", YAKT},
            {"Asia/Yangon", MMT},
            {"Asia/Yekaterinburg", new String[] {"Jekaterinburger Zeit", "YEKT",
                                                 "Jekaterinburger Sommerzeit", "YEKST"}},
            {"Asia/Yerevan", ARMT},
            {"Atlantic/Azores", new String[] {"Azoren Zeit", "AZOT",
                                              "Azoren Sommerzeit", "AZOST"}},
            {"Atlantic/Bermuda", AST},
            {"Atlantic/Canary", WET},
            {"Atlantic/Cape_Verde", new String[] {"Kap Verde Zeit", "CVT",
                                                  "Kap Verde Sommerzeit", "CVST"}},
            {"Atlantic/Faeroe", WET},
            {"Atlantic/Faroe", WET},
            {"Atlantic/Jan_Mayen", CET},
            {"Atlantic/Madeira", WET},
            {"Atlantic/Reykjavik", GMT},
            {"Atlantic/South_Georgia", new String[] {"South Georgia Normalzeit", "GST",
                                                     "South Georgia Sommerzeit", "GDT"}},
            {"Atlantic/St_Helena", GMT},
            {"Atlantic/Stanley", new String[] {"Falkland Inseln Zeit", "FKT",
                                               "Falkland Inseln Sommerzeit", "FKST"}},
            {"Australia/ACT", EST_NSW},
            {"Australia/Adelaide", ADELAIDE},
            {"Australia/Brisbane", BRISBANE},
            {"Australia/Broken_Hill", BROKEN_HILL},
            {"Australia/Canberra", EST_NSW},
            {"Australia/Currie", EST_NSW},
            {"Australia/Darwin", DARWIN},
            {"Australia/Eucla", new String[] {"Zentral-Westliche Normalzeit (Australien)", "ACWST",
                                              "Zentral-Westliche Sommerzeit (Australien)", "ACWDT"}},
            {"Australia/Hobart", TASMANIA},
            {"Australia/LHI", LORD_HOWE},
            {"Australia/Lindeman", BRISBANE},
            {"Australia/Lord_Howe", LORD_HOWE},
            {"Australia/Melbourne", VICTORIA},
            {"Australia/North", DARWIN},
            {"Australia/NSW", EST_NSW},
            {"Australia/Perth", WST_AUS},
            {"Australia/Queensland", BRISBANE},
            {"Australia/South", ADELAIDE},
            {"Australia/Sydney", EST_NSW},
            {"Australia/Tasmania", TASMANIA},
            {"Australia/Victoria", VICTORIA},
            {"Australia/West", WST_AUS},
            {"Australia/Yancowinna", BROKEN_HILL},
            {"BET", BRT},
            {"BST", BDT},
            {"Brazil/Acre", ACT},
            {"Brazil/DeNoronha", NORONHA},
            {"Brazil/East", BRT},
            {"Brazil/West", AMT},
            {"Canada/Atlantic", AST},
            {"Canada/Central", CST},
            {"Canada/East-Saskatchewan", CST},
            {"Canada/Eastern", EST},
            {"Canada/Mountain", MST},
            {"Canada/Newfoundland", NST},
            {"Canada/Pacific", PST},
            {"Canada/Yukon", PST},
            {"Canada/Saskatchewan", CST},
            {"CAT", CAT},
            {"CET", CET},
            {"Chile/Continental", CLT},
            {"Chile/EasterIsland", EASTER},
            {"CST6CDT", CST},
            {"Cuba", CUBA},
            {"EAT", EAT},
            {"EET", EET},
            {"Egypt", EET},
            {"Eire", DUBLIN},
            {"EST5EDT", EST},
            {"Etc/Greenwich", GMT},
            {"Etc/UCT", UTC},
            {"Etc/Universal", UTC},
            {"Etc/UTC", UTC},
            {"Etc/Zulu", UTC},
            {"Europe/Amsterdam", CET},
            {"Europe/Andorra", CET},
            {"Europe/Athens", EET},
            {"Europe/Belfast", GMTBST},
            {"Europe/Belgrade", CET},
            {"Europe/Berlin", CET},
            {"Europe/Bratislava", CET},
            {"Europe/Brussels", CET},
            {"Europe/Budapest", CET},
            {"Europe/Busingen", CET},
            {"Europe/Chisinau", EET},
            {"Europe/Copenhagen", CET},
            {"Europe/Dublin", DUBLIN},
            {"Europe/Gibraltar", CET},
            {"Europe/Guernsey", GMTBST},
            {"Europe/Helsinki", EET},
            {"Europe/Isle_of_Man", GMTBST},
            {"Europe/Istanbul", EET},
            {"Europe/Jersey", GMTBST},
            {"Europe/Kaliningrad", EET},
            {"Europe/Kiev", EET},
            {"Europe/Lisbon", WET},
            {"Europe/Ljubljana", CET},
            {"Europe/London", GMTBST},
            {"Europe/Luxembourg", CET},
            {"Europe/Madrid", CET},
            {"Europe/Malta", CET},
            {"Europe/Mariehamn", EET},
            {"Europe/Minsk", MSK},
            {"Europe/Monaco", CET},
            {"Europe/Moscow", MSK},
            {"Europe/Nicosia", EET},
            {"Europe/Oslo", CET},
            {"Europe/Podgorica", CET},
            {"Europe/Prague", CET},
            {"Europe/Riga", EET},
            {"Europe/Rome", CET},
            {"Europe/Samara", new String[] {"Samarische Zeit", "SAMT",
                                            "Samarische Sommerzeit", "SAMST"}},
            {"Europe/San_Marino", CET},
            {"Europe/Sarajevo", CET},
            {"Europe/Simferopol", MSK},
            {"Europe/Skopje", CET},
            {"Europe/Sofia", EET},
            {"Europe/Stockholm", CET},
            {"Europe/Tallinn", EET},
            {"Europe/Tirane", CET},
            {"Europe/Tiraspol", EET},
            {"Europe/Uzhgorod", EET},
            {"Europe/Vaduz", CET},
            {"Europe/Vatican", CET},
            {"Europe/Vienna", CET},
            {"Europe/Vilnius", EET},
            {"Europe/Volgograd", MSK},
            {"Europe/Warsaw", CET},
            {"Europe/Zagreb", CET},
            {"Europe/Zaporozhye", EET},
            {"Europe/Zurich", CET},
            {"GB", GMTBST},
            {"GB-Eire", GMTBST},
            {"Greenwich", GMT},
            {"Hongkong", HKT},
            {"Iceland", GMT},
            {"Iran", IRT},
            {"IST", IST},
            {"Indian/Antananarivo", EAT},
            {"Indian/Chagos", new String[] {"Indischer Ozean Territorium Zeit", "IOT",
                                            "Indischer Ozean Territorium Sommerzeit", "IOST"}},
            {"Indian/Christmas", new String[] {"Christmas Island Zeit", "CXT",
                                               "Christmas Island Sommerzeit", "CXST"}},
            {"Indian/Cocos", new String[] {"Cocos Islands Zeit", "CCT",
                                           "Cocos Islands Sommerzeit", "CCST"}},
            {"Indian/Comoro", EAT},
            {"Indian/Kerguelen", new String[] {"Franz\u00f6sisch S\u00fcd- u. Antarktische Landzeit", "TFT",
                                               "Franz\u00f6sisch S\u00fcd- u. Antarktische Landsommerzeit", "TFST"}},
            {"Indian/Mahe", new String[] {"Seychellen Zeit", "SCT",
                                          "Seychellen Sommerzeit", "SCST"}},
            {"Indian/Maldives", new String[] {"Maledivische Zeit", "MVT",
                                              "Maledivische Sommerzeit", "MVST"}},
            {"Indian/Mauritius", new String[] {"Mauritius Zeit", "MUT",
                                               "Mauritius Sommerzeit", "MUST"}},
            {"Indian/Mayotte", EAT},
            {"Indian/Reunion", new String[] {"Reunion Zeit", "RET",
                                             "Reunion Sommerzeit", "REST"}},
            {"Israel", ISRAEL},
            {"Jamaica", EST},
            {"Japan", JST},
            {"Kwajalein", MHT},
            {"Libya", EET},
            {"MET", new String[] {"Zentraleurop\u00e4ische Zeit", "MET",
                                  "Zentraleurop\u00e4ische Sommerzeit", "MEST"}},
            {"Mexico/BajaNorte", PST},
            {"Mexico/BajaSur", MST},
            {"Mexico/General", CST},
            {"MIT", WST_SAMOA},
            {"MST7MDT", MST},
            {"Navajo", MST},
            {"NET", ARMT},
            {"NST", NZST},
            {"NZ", NZST},
            {"NZ-CHAT", CHAST},
            {"PLT", PKT},
            {"Portugal", WET},
            {"PRT", AST},
            {"Pacific/Apia", WST_SAMOA},
            {"Pacific/Auckland", NZST},
            {"Pacific/Bougainville", new String[] {"Bougainville Standard Time", "BST",
                                                   "Bougainville Daylight Time", "BST"}},
            {"Pacific/Chatham", CHAST},
            {"Pacific/Chuuk", CHUT},
            {"Pacific/Easter", EASTER},
            {"Pacific/Efate", new String[] {"Vanuatu Zeit", "VUT",
                                            "Vanuatu Sommerzeit", "VUST"}},
            {"Pacific/Enderbury", new String[] {"Phoenix Inseln Zeit", "PHOT",
                                                "Phoenix Inseln Sommerzeit", "PHOST"}},
            {"Pacific/Fakaofo", new String[] {"Tokelau Zeit", "TKT",
                                              "Tokelau Sommerzeit", "TKST"}},
            {"Pacific/Fiji", new String[] {"Fidschi Zeit", "FJT",
                                           "Fidschi Sommerzeit", "FJST"}},
            {"Pacific/Funafuti", new String[] {"Tuvalu Zeit", "TVT",
                                               "Tuvalu Sommerzeit", "TVST"}},
            {"Pacific/Galapagos", new String[] {"Galapagos Zeit", "GALT",
                                                "Galapagos Sommerzeit", "GALST"}},
            {"Pacific/Gambier", GAMBIER},
            {"Pacific/Guadalcanal", SBT},
            {"Pacific/Guam", ChST},
            {"Pacific/Johnston", HST},
            {"Pacific/Kiritimati", new String[] {"Line Inseln Zeit", "LINT",
                                                 "Line Inseln Sommerzeit", "LINST"}},
            {"Pacific/Kosrae", new String[] {"Kosrae Zeit", "KOST",
                                             "Kosrae Sommerzeit", "KOSST"}},
            {"Pacific/Kwajalein", MHT},
            {"Pacific/Majuro", MHT},
            {"Pacific/Marquesas", new String[] {"Marquesas Zeit", "MART",
                                                "Marquesas Sommerzeit", "MARST"}},
            {"Pacific/Midway", SAMOA},
            {"Pacific/Nauru", new String[] {"Nauru Zeit", "NRT",
                                            "Nauru Sommerzeit", "NRST"}},
            {"Pacific/Niue", new String[] {"Niue Zeit", "NUT",
                                           "Niue Sommerzeit", "NUST"}},
            {"Pacific/Norfolk", new String[] {"Norfolk Zeit", "NFT",
                                              "Norfolk Sommerzeit", "NFST"}},
            {"Pacific/Noumea", new String[] {"Neukaledonische Zeit", "NCT",
                                             "Neukaledonische Sommerzeit", "NCST"}},
            {"Pacific/Pago_Pago", SAMOA},
            {"Pacific/Palau", new String[] {"Palau Zeit", "PWT",
                                            "Palau Sommerzeit", "PWST"}},
            {"Pacific/Pitcairn", PITCAIRN},
            {"Pacific/Pohnpei", PONT},
            {"Pacific/Ponape", PONT},
            {"Pacific/Port_Moresby", new String[] {"Papua-Neuguinea Zeit", "PGT",
                                                   "Papua-Neuguinea Sommerzeit", "PGST"}},
            {"Pacific/Rarotonga", new String[] {"Cook-Inseln Zeit", "CKT",
                                                "Cook-Inseln Sommerzeit", "CKHST"}},
            {"Pacific/Saipan", ChST},
            {"Pacific/Samoa", SAMOA},
            {"Pacific/Tahiti", new String[] {"Tahiti Zeit", "TAHT",
                                             "Tahiti Sommerzeit", "TAHST"}},
            {"Pacific/Tarawa", new String[] {"Gilbert-Inseln Zeit", "GILT",
                                             "Gilbert-Inseln Sommerzeit", "GILST"}},
            {"Pacific/Tongatapu", new String[] {"Tonga Zeit", "TOT",
                                                "Tonga Sommerzeit", "TOST"}},
            {"Pacific/Truk", CHUT},
            {"Pacific/Wake", new String[] {"Wake Zeit", "WAKT",
                                           "Wake Sommerzeit", "WAKST"}},
            {"Pacific/Wallis", new String[] {"Wallis u. Futuna Zeit", "WFT",
                                             "Wallis u. Futuna Sommerzeit", "WFST"}},
            {"Pacific/Yap", CHUT},
            {"Poland", CET},
            {"PRC", CTT},
            {"PST8PDT", PST},
            {"ROK", KST},
            {"Singapore", SGT},
            {"SST", SBT},
            {"SystemV/AST4", AST},
            {"SystemV/AST4ADT", AST},
            {"SystemV/CST6", CST},
            {"SystemV/CST6CDT", CST},
            {"SystemV/EST5", EST},
            {"SystemV/EST5EDT", EST},
            {"SystemV/HST10", HST},
            {"SystemV/MST7", MST},
            {"SystemV/MST7MDT", MST},
            {"SystemV/PST8", PST},
            {"SystemV/PST8PDT", PST},
            {"SystemV/YST9", AKST},
            {"SystemV/YST9YDT", AKST},
            {"Turkey", EET},
            {"UCT", UTC},
            {"Universal", UTC},
            {"US/Alaska", AKST},
            {"US/Aleutian", HST},
            {"US/Arizona", MST},
            {"US/Central", CST},
            {"US/Eastern", EST},
            {"US/Hawaii", HST},
            {"US/Indiana-Starke", CST},
            {"US/East-Indiana", EST},
            {"US/Michigan", EST},
            {"US/Mountain", MST},
            {"US/Pacific", PST},
            {"US/Pacific-New", PST},
            {"US/Samoa", SAMOA},
            {"UTC", UTC},
            {"VST", ICT},
            {"W-SU", MSK},
            {"WET", WET},
            {"Zulu", UTC},
        };
    }
}
