/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.properties;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.core.properties.PropertiesCustomizer;
import com.sun.tools.visualvm.core.properties.PropertiesSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

class PropertiesConfigurator
extends JPanel {
    private static Dimension MIN_SIZE = new Dimension(400, 300);
    private static Dimension MAX_SIZE = new Dimension(700, 600);
    private static Map<String, Dimension> SAVED_SIZES = new HashMap<String, Dimension>();
    private final PropertiesCustomizer customizer;
    private final ChangeListener listener = new ChangeListener(){

        public void stateChanged(ChangeEvent e) {
            PropertiesConfigurator.this.update();
        }
    };
    private JButton okButton;

    public static void editProperties(DataSource dataSource, int propertiesCategory) {
        PropertiesCustomizer<DataSource> customizer = PropertiesSupport.sharedInstance().getCustomizer(dataSource, null);
        customizer.selectCategory(propertiesCategory);
        PropertiesConfigurator pc = new PropertiesConfigurator(customizer);
        DialogDescriptor dd = new DialogDescriptor((Object)pc, NbBundle.getMessage(PropertiesConfigurator.class, (String)"CAP_EditProperties", (Object[])new Object[]{DataSourceDescriptorFactory.getDescriptor(dataSource).getName()}), true, new Object[]{pc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)pc.okButton, 0, null, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        String className = dataSource.getClass().getName();
        Dimension savedSize = SAVED_SIZES.get(className);
        if (savedSize != null) {
            pc.setPreferredSize(savedSize);
        }
        d.pack();
        d.setVisible(true);
        SAVED_SIZES.put(className, pc.getSize());
        pc.cleanup();
        if (dd.getValue() == pc.okButton) {
            customizer.propertiesChanged();
        } else {
            customizer.propertiesCancelled();
        }
    }

    private PropertiesConfigurator(PropertiesCustomizer customizer) {
        this.customizer = customizer;
        this.initComponents();
        this.update();
        customizer.addChangeListener(this.listener);
    }

    private void cleanup() {
        this.customizer.removeChangeListener(this.listener);
        this.removeAll();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                PropertiesConfigurator.this.okButton.setEnabled(PropertiesConfigurator.this.customizer.settingsValid());
            }
        });
    }

    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width = Math.max(prefSize.width, PropertiesConfigurator.MIN_SIZE.width);
        prefSize.width = Math.min(prefSize.width, PropertiesConfigurator.MAX_SIZE.width);
        prefSize.height = Math.max(prefSize.height, PropertiesConfigurator.MIN_SIZE.height);
        prefSize.height = Math.min(prefSize.height, PropertiesConfigurator.MAX_SIZE.height);
        return prefSize;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.add((Component)this.customizer, "Center");
        this.okButton = new JButton(NbBundle.getMessage(PropertiesConfigurator.class, (String)"LBL_OK"));
    }
}

