/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.BreakException;
import org.jruby.truffle.language.control.BreakID;

public class CatchBreakNode
extends RubyNode {
    private final BreakID breakID;
    @Node.Child
    private RubyNode body;
    private final ConditionProfile matchingBreakProfile = ConditionProfile.createCountingProfile();

    public CatchBreakNode(BreakID breakID, RubyNode body) {
        this.breakID = breakID;
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        try {
            return this.body.execute(frame);
        }
        catch (BreakException e) {
            if (this.matchingBreakProfile.profile(e.getBreakID() == this.breakID)) {
                return e.getResult();
            }
            throw e;
        }
    }
}

