/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;

public class ClearScrollResponse
extends ActionResponse
implements StatusToXContentObject {
    private boolean succeeded;
    private int numFreed;

    public ClearScrollResponse(boolean succeeded, int numFreed) {
        this.succeeded = succeeded;
        this.numFreed = numFreed;
    }

    ClearScrollResponse() {
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public int getNumFreed() {
        return this.numFreed;
    }

    @Override
    public RestStatus status() {
        return this.numFreed == 0 ? RestStatus.NOT_FOUND : RestStatus.OK;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("succeeded", this.succeeded);
        builder.field("num_freed", this.numFreed);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.succeeded = in.readBoolean();
        this.numFreed = in.readVInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.succeeded);
        out.writeVInt(this.numFreed);
    }

    static final class Fields {
        static final String SUCCEEDED = "succeeded";
        static final String NUMFREED = "num_freed";

        Fields() {
        }
    }
}

