/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestResponseListener;

public class RestIndicesExistsAction
extends BaseRestHandler {
    public RestIndicesExistsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}", this);
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        IndicesExistsRequest indicesExistsRequest = new IndicesExistsRequest(Strings.splitStringByCommaToArray(request.param("index")));
        indicesExistsRequest.indicesOptions(IndicesOptions.fromRequest(request, indicesExistsRequest.indicesOptions()));
        indicesExistsRequest.local(request.paramAsBoolean("local", indicesExistsRequest.local()));
        return channel -> client.admin().indices().exists(indicesExistsRequest, (ActionListener<IndicesExistsResponse>)new RestResponseListener<IndicesExistsResponse>(channel){

            @Override
            public RestResponse buildResponse(IndicesExistsResponse response) {
                if (response.isExists()) {
                    return new BytesRestResponse(RestStatus.OK, "text/plain; charset=UTF-8", BytesArray.EMPTY);
                }
                return new BytesRestResponse(RestStatus.NOT_FOUND, "text/plain; charset=UTF-8", BytesArray.EMPTY);
            }
        });
    }
}

