/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.lucene.util.CollectionUtil;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.rounding.Rounding;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.ExtendedBounds;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.HistogramFactory;
import org.elasticsearch.search.aggregations.bucket.histogram.InternalOrder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class InternalDateHistogram
extends InternalMultiBucketAggregation<InternalDateHistogram, Bucket>
implements Histogram,
HistogramFactory {
    private final List<Bucket> buckets;
    private final InternalOrder order;
    private final DocValueFormat format;
    private final boolean keyed;
    private final long minDocCount;
    private final long offset;
    private final EmptyBucketInfo emptyBucketInfo;

    InternalDateHistogram(String name, List<Bucket> buckets, InternalOrder order, long minDocCount, long offset, EmptyBucketInfo emptyBucketInfo, DocValueFormat formatter, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.buckets = buckets;
        this.order = order;
        this.offset = offset;
        assert (minDocCount == 0L == (emptyBucketInfo != null));
        this.minDocCount = minDocCount;
        this.emptyBucketInfo = emptyBucketInfo;
        this.format = formatter;
        this.keyed = keyed;
    }

    public InternalDateHistogram(StreamInput in) throws IOException {
        super(in);
        this.order = InternalOrder.Streams.readOrder(in);
        this.minDocCount = in.readVLong();
        this.emptyBucketInfo = this.minDocCount == 0L ? new EmptyBucketInfo(in) : null;
        this.offset = in.readLong();
        this.format = in.readNamedWriteable(DocValueFormat.class);
        this.keyed = in.readBoolean();
        this.buckets = in.readList(stream -> new Bucket(stream, this.keyed, this.format));
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        InternalOrder.Streams.writeOrder(this.order, out);
        out.writeVLong(this.minDocCount);
        if (this.minDocCount == 0L) {
            this.emptyBucketInfo.writeTo(out);
        }
        out.writeLong(this.offset);
        out.writeNamedWriteable(this.format);
        out.writeBoolean(this.keyed);
        out.writeList(this.buckets);
    }

    @Override
    public String getWriteableName() {
        return "date_histogram";
    }

    @Override
    public List<Histogram.Bucket> getBuckets() {
        return Collections.unmodifiableList(this.buckets);
    }

    @Override
    public InternalDateHistogram create(List<Bucket> buckets) {
        return new InternalDateHistogram(this.name, buckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, prototype.keyed, prototype.format, aggregations);
    }

    private List<Bucket> reduceBuckets(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        PriorityQueue<IteratorAndCurrent> pq = new PriorityQueue<IteratorAndCurrent>(aggregations.size()){

            protected boolean lessThan(IteratorAndCurrent a, IteratorAndCurrent b) {
                return ((IteratorAndCurrent)a).current.key < ((IteratorAndCurrent)b).current.key;
            }
        };
        for (InternalAggregation aggregation : aggregations) {
            InternalDateHistogram histogram = (InternalDateHistogram)aggregation;
            if (histogram.buckets.isEmpty()) continue;
            pq.add((Object)new IteratorAndCurrent(histogram.buckets.iterator()));
        }
        ArrayList<Bucket> reducedBuckets = new ArrayList<Bucket>();
        if (pq.size() > 0) {
            Bucket reduced;
            ArrayList<Bucket> currentBuckets = new ArrayList<Bucket>();
            double key = ((IteratorAndCurrent)((IteratorAndCurrent)pq.top())).current.key;
            do {
                IteratorAndCurrent top = (IteratorAndCurrent)pq.top();
                if ((double)((IteratorAndCurrent)top).current.key != key) {
                    Bucket reduced2 = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext);
                    if (reduced2.getDocCount() >= this.minDocCount) {
                        reducedBuckets.add(reduced2);
                    }
                    currentBuckets.clear();
                    key = ((IteratorAndCurrent)top).current.key;
                }
                currentBuckets.add(top.current);
                if (top.iterator.hasNext()) {
                    Bucket next = (Bucket)top.iterator.next();
                    assert (next.key > ((IteratorAndCurrent)top).current.key) : "shards must return data sorted by key";
                    top.current = next;
                    pq.updateTop();
                    continue;
                }
                pq.pop();
            } while (pq.size() > 0);
            if (!currentBuckets.isEmpty() && (reduced = ((Bucket)currentBuckets.get(0)).reduce(currentBuckets, reduceContext)).getDocCount() >= this.minDocCount) {
                reducedBuckets.add(reduced);
            }
        }
        return reducedBuckets;
    }

    private void addEmptyBuckets(List<Bucket> list, InternalAggregation.ReduceContext reduceContext) {
        long key;
        Bucket lastBucket = null;
        ExtendedBounds bounds = this.emptyBucketInfo.bounds;
        ListIterator<Bucket> iter = list.listIterator();
        InternalAggregations reducedEmptySubAggs = InternalAggregations.reduce(Collections.singletonList(this.emptyBucketInfo.subAggregations), reduceContext);
        if (bounds != null) {
            Bucket firstBucket;
            Bucket bucket = firstBucket = iter.hasNext() ? list.get(iter.nextIndex()) : null;
            if (firstBucket == null) {
                if (bounds.getMin() != null && bounds.getMax() != null) {
                    key = bounds.getMin();
                    long max = bounds.getMax();
                    while (key <= max) {
                        iter.add(new Bucket(key, 0L, this.keyed, this.format, reducedEmptySubAggs));
                        key = this.nextKey(key).longValue();
                    }
                }
            } else if (bounds.getMin() != null && (key = bounds.getMin().longValue()) < firstBucket.key) {
                while (key < firstBucket.key) {
                    iter.add(new Bucket(key, 0L, this.keyed, this.format, reducedEmptySubAggs));
                    key = this.nextKey(key).longValue();
                }
            }
        }
        while (iter.hasNext()) {
            Bucket nextBucket = list.get(iter.nextIndex());
            if (lastBucket != null) {
                key = this.nextKey(lastBucket.key).longValue();
                while (key < nextBucket.key) {
                    iter.add(new Bucket(key, 0L, this.keyed, this.format, reducedEmptySubAggs));
                    key = this.nextKey(key).longValue();
                }
                assert (key == nextBucket.key);
            }
            lastBucket = iter.next();
        }
        if (bounds != null && lastBucket != null && bounds.getMax() != null && bounds.getMax() > lastBucket.key) {
            long key2 = this.emptyBucketInfo.rounding.nextRoundingValue(lastBucket.key);
            long max = bounds.getMax();
            while (key2 <= max) {
                iter.add(new Bucket(key2, 0L, this.keyed, this.format, reducedEmptySubAggs));
                key2 = this.emptyBucketInfo.rounding.nextRoundingValue(key2);
            }
        }
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        List<Bucket> reducedBuckets = this.reduceBuckets(aggregations, reduceContext);
        if (this.minDocCount == 0L) {
            this.addEmptyBuckets(reducedBuckets, reduceContext);
        }
        if (this.order != InternalOrder.KEY_ASC) {
            if (this.order == InternalOrder.KEY_DESC) {
                ArrayList<Bucket> reverse = new ArrayList<Bucket>(reducedBuckets);
                Collections.reverse(reverse);
                reducedBuckets = reverse;
            } else {
                CollectionUtil.introSort(reducedBuckets, this.order.comparator());
            }
        }
        return new InternalDateHistogram(this.getName(), reducedBuckets, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject("buckets");
        } else {
            builder.startArray("buckets");
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    @Override
    public Number getKey(MultiBucketsAggregation.Bucket bucket) {
        return ((Bucket)bucket).key;
    }

    @Override
    public Number nextKey(Number key) {
        return this.emptyBucketInfo.rounding.nextRoundingValue(key.longValue() - this.offset) + this.offset;
    }

    @Override
    public InternalAggregation createAggregation(List<MultiBucketsAggregation.Bucket> buckets) {
        List<Bucket> buckets2 = new ArrayList(buckets.size());
        for (MultiBucketsAggregation.Bucket b : buckets) {
            buckets2.add((Bucket)b);
        }
        buckets2 = Collections.unmodifiableList(buckets2);
        return new InternalDateHistogram(this.name, buckets2, this.order, this.minDocCount, this.offset, this.emptyBucketInfo, this.format, this.keyed, this.pipelineAggregators(), this.getMetaData());
    }

    @Override
    public Bucket createBucket(Number key, long docCount, InternalAggregations aggregations) {
        return new Bucket(key.longValue(), docCount, this.keyed, this.format, aggregations);
    }

    private static class IteratorAndCurrent {
        private final Iterator<Bucket> iterator;
        private Bucket current;

        IteratorAndCurrent(Iterator<Bucket> iterator) {
            this.iterator = iterator;
            this.current = iterator.next();
        }
    }

    static class EmptyBucketInfo {
        final Rounding rounding;
        final InternalAggregations subAggregations;
        final ExtendedBounds bounds;

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations) {
            this(rounding, subAggregations, null);
        }

        EmptyBucketInfo(Rounding rounding, InternalAggregations subAggregations, ExtendedBounds bounds) {
            this.rounding = rounding;
            this.subAggregations = subAggregations;
            this.bounds = bounds;
        }

        EmptyBucketInfo(StreamInput in) throws IOException {
            this.rounding = Rounding.Streams.read(in);
            this.subAggregations = InternalAggregations.readAggregations(in);
            this.bounds = in.readOptionalWriteable(ExtendedBounds::new);
        }

        void writeTo(StreamOutput out) throws IOException {
            Rounding.Streams.write(this.rounding, out);
            this.subAggregations.writeTo(out);
            out.writeOptionalWriteable(this.bounds);
        }
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Histogram.Bucket {
        final long key;
        final long docCount;
        final InternalAggregations aggregations;
        private final transient boolean keyed;
        protected final transient DocValueFormat format;

        public Bucket(long key, long docCount, boolean keyed, DocValueFormat format, InternalAggregations aggregations) {
            this.format = format;
            this.keyed = keyed;
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
        }

        public Bucket(StreamInput in, boolean keyed, DocValueFormat format) throws IOException {
            this.format = format;
            this.keyed = keyed;
            this.key = in.readLong();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }

        @Override
        public String getKeyAsString() {
            return this.format.format(this.key);
        }

        @Override
        public Object getKey() {
            return new DateTime(this.key, DateTimeZone.UTC);
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        Bucket reduce(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
            ArrayList<InternalAggregations> aggregations = new ArrayList<InternalAggregations>(buckets.size());
            long docCount = 0L;
            for (Bucket bucket : buckets) {
                docCount += bucket.docCount;
                aggregations.add((InternalAggregations)bucket.getAggregations());
            }
            InternalAggregations aggs = InternalAggregations.reduce(aggregations, context);
            return new Bucket(this.key, docCount, this.keyed, this.format, aggs);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            String keyAsString = this.format.format(this.key);
            if (this.keyed) {
                builder.startObject(keyAsString);
            } else {
                builder.startObject();
            }
            if (this.format != DocValueFormat.RAW) {
                builder.field("key_as_string", keyAsString);
            }
            builder.field("key", this.key);
            builder.field("doc_count", this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        public DocValueFormat getFormatter() {
            return this.format;
        }

        public boolean getKeyed() {
            return this.keyed;
        }
    }
}

