/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.NameRecord;
import jogamp.graph.font.typecast.ot.table.Table;

public class NameTable
implements Table {
    private DirectoryEntry _de;
    private short _formatSelector;
    private short _numberOfNameRecords;
    private short _stringStorageOffset;
    private NameRecord[] _records;

    protected NameTable(DirectoryEntry directoryEntry, DataInput dataInput) throws IOException {
        this._de = (DirectoryEntry)directoryEntry.clone();
        this._formatSelector = dataInput.readShort();
        this._numberOfNameRecords = dataInput.readShort();
        this._stringStorageOffset = dataInput.readShort();
        this._records = new NameRecord[this._numberOfNameRecords];
        for (int i = 0; i < this._numberOfNameRecords; ++i) {
            this._records[i] = new NameRecord(dataInput);
        }
        byte[] byArray = new byte[this._de.getLength() - this._stringStorageOffset];
        dataInput.readFully(byArray);
        for (int i = 0; i < this._numberOfNameRecords; ++i) {
            this._records[i].loadString(new DataInputStream(new ByteArrayInputStream(byArray)));
        }
    }

    public short getNumberOfNameRecords() {
        return this._numberOfNameRecords;
    }

    public NameRecord getRecord(int n) {
        if (this._numberOfNameRecords > n) {
            return this._records[n];
        }
        return null;
    }

    public StringBuilder getRecordsRecordString(StringBuilder stringBuilder, int n) {
        if (this._numberOfNameRecords > n) {
            this._records[n].getRecordString(stringBuilder);
        } else {
            stringBuilder.append("n/a");
        }
        return stringBuilder;
    }

    public StringBuilder getNamedRecordString(StringBuilder stringBuilder, short s) {
        boolean bl = false;
        for (int i = 0; !bl && i < this._numberOfNameRecords; ++i) {
            if (this._records[i].getNameId() != s) continue;
            this._records[i].getRecordString(stringBuilder);
            bl = true;
        }
        if (!bl) {
            stringBuilder.append("n/a");
        }
        return stringBuilder;
    }

    @Override
    public int getType() {
        return 1851878757;
    }

    @Override
    public DirectoryEntry getDirectoryEntry() {
        return this._de;
    }
}

