/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.graph.nodes;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.ComponentSelectionReason;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.DependencyEdge;
import org.gradle.api.tasks.diagnostics.internal.graph.nodes.RenderableDependency;

public class DependencyReportHeader
implements RenderableDependency {
    private final DependencyEdge dependency;

    public DependencyReportHeader(DependencyEdge dependency) {
        this.dependency = dependency;
    }

    public ComponentIdentifier getId() {
        return this.dependency.getActual();
    }

    @Override
    public String getName() {
        return this.getId().getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.getReasonDescription(this.dependency.getReason());
    }

    @Override
    public RenderableDependency.ResolutionState getResolutionState() {
        return this.dependency.isResolvable() ? RenderableDependency.ResolutionState.RESOLVED : RenderableDependency.ResolutionState.FAILED;
    }

    @Override
    public Set<? extends RenderableDependency> getChildren() {
        return Collections.emptySet();
    }

    private String getReasonDescription(ComponentSelectionReason reason) {
        return !reason.isExpected() ? reason.getDescription() : null;
    }
}

