/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.scala.internal.toolchain;

import java.io.File;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.language.scala.ScalaPlatform;
import org.gradle.language.scala.internal.toolchain.DefaultScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.NotFoundScalaToolProvider;
import org.gradle.language.scala.internal.toolchain.ScalaToolChainInternal;
import org.gradle.platform.base.internal.toolchain.ToolProvider;
import org.gradle.process.internal.daemon.WorkerDaemonManager;

public class DownloadingScalaToolChain
implements ScalaToolChainInternal {
    private final File gradleUserHomeDir;
    private final File rootProjectDir;
    private final WorkerDaemonManager compilerDaemonManager;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final JavaVersion javaVersion;

    public DownloadingScalaToolChain(File gradleUserHomeDir, File rootProjectDir, WorkerDaemonManager compilerDaemonManager, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.rootProjectDir = rootProjectDir;
        this.compilerDaemonManager = compilerDaemonManager;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.javaVersion = JavaVersion.current();
    }

    public String getName() {
        return "Scala Toolchain";
    }

    public String getDisplayName() {
        return "Scala Toolchain (JDK " + this.javaVersion.getMajorVersion() + " (" + this.javaVersion + "))";
    }

    public ToolProvider select(ScalaPlatform targetPlatform) {
        try {
            Configuration scalaClasspath = this.resolveDependency("org.scala-lang:scala-compiler:" + targetPlatform.getScalaVersion());
            Configuration zincClasspath = this.resolveDependency("com.typesafe.zinc:zinc:0.3.7");
            Set resolvedScalaClasspath = scalaClasspath.resolve();
            Set resolvedZincClasspath = zincClasspath.resolve();
            return new DefaultScalaToolProvider(this.gradleUserHomeDir, this.rootProjectDir, this.compilerDaemonManager, resolvedScalaClasspath, resolvedZincClasspath);
        }
        catch (ResolveException resolveException) {
            return new NotFoundScalaToolProvider((Exception)((Object)resolveException));
        }
    }

    private Configuration resolveDependency(Object dependencyNotation) {
        Dependency dependency = this.dependencyHandler.create(dependencyNotation);
        return this.configurationContainer.detachedConfiguration(new Dependency[]{dependency});
    }
}

