/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.visitors;

import java.util.ArrayList;
import java.util.List;
import org.gradle.foundation.ProjectView;
import org.gradle.foundation.TaskView;
import org.gradle.gradleplugin.foundation.filters.AllowAllProjectAndTaskFilter;
import org.gradle.gradleplugin.foundation.filters.ProjectAndTaskFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllProjectsAndTasksVisitor {
    public static <P, T> void visitProjectAndTasks(List<ProjectView> projects, Visitor<P, T> visitor, P rootProjectObject) {
        AllProjectsAndTasksVisitor.visitProjectAndTasks(projects, visitor, new AllowAllProjectAndTaskFilter(), rootProjectObject);
    }

    public static <P, T> void visitProjectAndTasks(List<ProjectView> projects, Visitor<P, T> visitor, ProjectAndTaskFilter filter, P rootProjectObject) {
        AllProjectsAndTasksVisitor.visitProjects(visitor, filter, projects, rootProjectObject);
    }

    public static <P, T> List<P> visitProjects(Visitor<P, T> visitor, ProjectAndTaskFilter filter, List<ProjectView> projects, P parentProjectObject) {
        ArrayList<P> projectObjects = new ArrayList<P>();
        for (ProjectView project : projects) {
            if (!filter.doesAllowProject(project)) continue;
            P userProjectObject = visitor.visitProject(project, parentProjectObject);
            projectObjects.add(userProjectObject);
            AllProjectsAndTasksVisitor.visitProjects(visitor, filter, project.getSubProjects(), userProjectObject);
            AllProjectsAndTasksVisitor.visitTasks(visitor, filter, project, userProjectObject);
        }
        return projectObjects;
    }

    private static <P, T> List<T> visitTasks(Visitor<P, T> visitor, ProjectAndTaskFilter filter, ProjectView project, P userProjectObject) {
        ArrayList<T> taskObjects = new ArrayList<T>();
        for (TaskView task : project.getTasks()) {
            if (!filter.doesAllowTask(task)) continue;
            T taskObject = visitor.visitTask(task, project, userProjectObject);
            taskObjects.add(taskObject);
        }
        return taskObjects;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Visitor<P, T> {
        public P visitProject(ProjectView var1, P var2);

        public T visitTask(TaskView var1, ProjectView var2, P var3);
    }
}

