/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.internal.Transformers;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;
import org.gradle.internal.time.TimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOperationExecutor
implements BuildOperationExecutor {
    private final InternalBuildListener listener;
    private final TimeProvider timeProvider;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final AtomicLong nextId = new AtomicLong();
    private final ThreadLocal<OperationDetails> currentOperation = new ThreadLocal();

    public DefaultBuildOperationExecutor(InternalBuildListener listener, TimeProvider timeProvider, ProgressLoggerFactory progressLoggerFactory) {
        this.listener = listener;
        this.timeProvider = timeProvider;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public BuildOperationExecutor.Operation getCurrentOperation() {
        OperationDetails current = this.currentOperation.get();
        if (current == null) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return current;
    }

    @Override
    public void run(String displayName, Action<? super BuildOperationContext> action) {
        this.run(BuildOperationDetails.displayName(displayName).build(), Transformers.toTransformer(action));
    }

    @Override
    public void run(BuildOperationDetails operationDetails, Action<? super BuildOperationContext> action) {
        this.run(operationDetails, Transformers.toTransformer(action));
    }

    @Override
    public <T> T run(String displayName, Transformer<T, ? super BuildOperationContext> factory) {
        return this.run(BuildOperationDetails.displayName(displayName).build(), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(BuildOperationDetails operationDetails, Transformer<T, ? super BuildOperationContext> factory) {
        OperationIdentifier parentId;
        OperationDetails parent;
        OperationDetails operationBefore = this.currentOperation.get();
        OperationDetails operationDetails2 = parent = operationDetails.getParent() != null ? (OperationDetails)operationDetails.getParent() : operationBefore;
        if (parent == null) {
            parentId = null;
        } else {
            if (!parent.running.get()) {
                throw new IllegalStateException(String.format("Cannot start operation (%s) as parent operation (%s) has already completed.", operationDetails.getDisplayName(), parent.operationDetails.getDisplayName()));
            }
            parentId = parent.id;
        }
        OperationIdentifier id = new OperationIdentifier(this.nextId.getAndIncrement());
        OperationDetails currentOperation = new OperationDetails(parent, id, operationDetails);
        currentOperation.running.set(true);
        this.currentOperation.set(currentOperation);
        try {
            long startTime = this.timeProvider.getCurrentTime();
            BuildOperationInternal operation = new BuildOperationInternal(id, parentId, operationDetails.getName(), operationDetails.getDisplayName(), operationDetails.getOperationDescriptor());
            this.listener.started(operation, new OperationStartEvent(startTime));
            Object result = null;
            Throwable failure = null;
            BuildOperationContextImpl context = new BuildOperationContextImpl();
            try {
                ProgressLogger progressLogger;
                if (operationDetails.getProgressDisplayName() != null) {
                    progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationExecutor.class);
                    progressLogger.setDescription(operationDetails.getDisplayName());
                    progressLogger.setShortDescription(operationDetails.getProgressDisplayName());
                    progressLogger.started();
                } else {
                    progressLogger = null;
                }
                try {
                    result = factory.transform((Object)context);
                }
                finally {
                    if (progressLogger != null) {
                        progressLogger.completed();
                    }
                }
                if (parent != null && !parent.running.get()) {
                    throw new IllegalStateException(String.format("Parent operation (%s) completed before this operation (%s).", parent.operationDetails.getDisplayName(), operationDetails.getDisplayName()));
                }
            }
            catch (Throwable t) {
                context.failed(t);
                failure = t;
            }
            long endTime = this.timeProvider.getCurrentTime();
            this.listener.finished(operation, new OperationResult(startTime, endTime, context.failure));
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
            Object object = result;
            return (T)object;
        }
        finally {
            this.currentOperation.set(operationBefore);
            currentOperation.running.set(false);
        }
    }

    private static class BuildOperationContextImpl
    implements BuildOperationContext {
        Throwable failure;

        private BuildOperationContextImpl() {
        }

        public void failed(Throwable t) {
            this.failure = t;
        }
    }

    private static class OperationDetails
    implements BuildOperationExecutor.Operation {
        final AtomicBoolean running = new AtomicBoolean();
        final OperationDetails parent;
        final OperationIdentifier id;
        final BuildOperationDetails operationDetails;

        OperationDetails(OperationDetails parent, OperationIdentifier id, BuildOperationDetails operationDetails) {
            this.parent = parent;
            this.id = id;
            this.operationDetails = operationDetails;
        }

        public Object getId() {
            return this.id;
        }
    }
}

