/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.javascript.base;

import org.gradle.api.Action;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.ArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyArtifactRepository;
import org.gradle.api.artifacts.repositories.IvyPatternRepositoryLayout;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.internal.Actions;

public class JavaScriptRepositoriesExtension {
    public static final String NAME = "javaScript";
    public static final String GRADLE_PUBLIC_JAVASCRIPT_REPO_URL = "https://repo.gradle.org/gradle/javascript-public";
    public static final String GOOGLE_APIS_REPO_URL = "http://ajax.googleapis.com/ajax/libs";
    private final RepositoryHandler repositories;

    public JavaScriptRepositoriesExtension(RepositoryHandler repositories) {
        this.repositories = repositories;
    }

    public ArtifactRepository gradle() {
        return this.gradle((Action<? super MavenArtifactRepository>)Actions.doNothing());
    }

    public MavenArtifactRepository gradle(final Action<? super MavenArtifactRepository> action) {
        return this.repositories.maven((Action)new Action<MavenArtifactRepository>(){

            public void execute(MavenArtifactRepository repository) {
                repository.setName("gradleJs");
                repository.setUrl((Object)JavaScriptRepositoriesExtension.GRADLE_PUBLIC_JAVASCRIPT_REPO_URL);
                action.execute((Object)repository);
            }
        });
    }

    public IvyArtifactRepository googleApis() {
        return this.googleApis((Action<? super IvyArtifactRepository>)Actions.doNothing());
    }

    public IvyArtifactRepository googleApis(final Action<? super IvyArtifactRepository> action) {
        return this.repositories.ivy((Action)new Action<IvyArtifactRepository>(){

            public void execute(IvyArtifactRepository repo) {
                repo.setName("googleApisJs");
                repo.setUrl((Object)JavaScriptRepositoriesExtension.GOOGLE_APIS_REPO_URL);
                repo.layout("pattern", (Action)new Action<IvyPatternRepositoryLayout>(){

                    public void execute(IvyPatternRepositoryLayout layout) {
                        layout.artifact("[organization]/[revision]/[module].[ext]");
                        layout.ivy("[organization]/[revision]/[module].xml");
                    }
                });
                action.execute((Object)repo);
            }
        });
    }
}

