#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: HTTP
version: 4000.3.6
id: HTTP-4000.3.6-Ajugn70iIEo18w47MRac6D
key: HTTP-4000.3.6-Ajugn70iIEo18w47MRac6D
license: BSD3
maintainer: Ganesh Sittampalam <ganesh@earth.li>
homepage: https://github.com/haskell/HTTP
synopsis: A library for client-side HTTP
description:
    The HTTP package supports client-side web programming in Haskell. It lets you set up
    HTTP connections, transmitting requests and processing the responses coming back, all
    from within the comforts of Haskell. It'\''s dependent on the network package to operate,
    but other than that, the implementation is all written in Haskell.
    .
    A basic API for issuing single HTTP requests + receiving responses is provided. On top
    of that, a session-level abstraction is also on offer  (the @BrowserAction@ monad);
    it taking care of handling the management of persistent connections, proxies,
    state (cookies) and authentication credentials required to handle multi-step
    interactions with a web server.
    .
    The representation of the bytes flowing across is extensible via the use of a type class,
    letting you pick the representation of requests and responses that best fits your use.
    Some pre-packaged, common instances are provided for you (@ByteString@, @String@).
    .
    Here'\''s an example use:
    .
    >
    >    do
    >      rsp <- Network.HTTP.simpleHTTP (getRequest "http://www.haskell.org/")
    >              -- fetch document and return it (as a '\''String'\''.)
    >      fmap (take 100) (getResponseBody rsp)
    >
    >    do
    >      (_, rsp)
    >         <- Network.Browser.browse $ do
    >               setAllowRedirects True -- handle HTTP redirects
    >               request $ getRequest "http://www.haskell.org/"
    >      return (take 100 (rspBody rsp))
    .
    __Note:__ This package does not support HTTPS connections.
    If you need HTTPS, take a look at the following packages:
    .
    * <http://hackage.haskell.org/package/http-streams http-streams>
    .
    * <http://hackage.haskell.org/package/http-client http-client> (in combination with
    <http://hackage.haskell.org/package/http-client-tls http-client-tls>)
    .
    * <http://hackage.haskell.org/package/req req>
    .
    * <http://hackage.haskell.org/package/wreq wreq>
    .
category: Network
author: Warrick Gray <warrick.gray@hotmail.com>
exposed: True
exposed-modules:
    Network.BufferType Network.Stream Network.StreamDebugger
    Network.StreamSocket Network.TCP Network.HTTP Network.HTTP.Headers
    Network.HTTP.Base Network.HTTP.Stream Network.HTTP.Auth
    Network.HTTP.Cookie Network.HTTP.Proxy Network.HTTP.HandleStream
    Network.Browser
hidden-modules: Network.HTTP.Base64 Network.HTTP.MD5Aux
                Network.HTTP.Utils Paths_HTTP
abi: 62f8741a5743a3ad05578810cdb30495
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/HTTP-4000.3.6
library-dirs: /usr/lib/ghc-8.0.1/site-local/HTTP-4000.3.6
data-dir: /usr/share/arm-linux-ghc-8.0.1/HTTP-4000.3.6
hs-libraries: HSHTTP-4000.3.6-Ajugn70iIEo18w47MRac6D
depends:
    array-0.5.1.1 base-4.9.0.0 bytestring-0.10.8.1
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG
    network-uri-2.6.1.0-8yR4gjnzE4eDGhJR7PHfVJ
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY time-1.6.0.1
haddock-interfaces: /usr/share/doc/haskell-http/html/HTTP.haddock
haddock-html: /usr/share/doc/haskell-http/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
