#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: lens
version: 4.15.1
id: lens-4.15.1-AQi0y6GexOY2BzSazyYQSD
key: lens-4.15.1-AQi0y6GexOY2BzSazyYQSD
license: BSD3
copyright: Copyright (C) 2012-2016 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
synopsis: Lenses, Folds and Traversals
description:
    This package comes \"Batteries Included\" with many useful lenses for the types
    commonly used from the Haskell Platform, and with tools for automatically
    generating lenses and isomorphisms for user-supplied data types.
    .
    The combinators in @Control.Lens@ provide a highly generic toolbox for composing
    families of getters, folds, isomorphisms, traversals, setters and lenses and their
    indexed variants.
    .
    An overview, with a large number of examples can be found in the <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals README>.
    .
    An introductory video on the style of code used in this library by Simon Peyton Jones is available from <http://skillsmatter.com/podcast/scala/lenses-compositional-data-access-and-manipulation Skills Matter>.
    .
    A video on how to use lenses and how they are constructed is available on <http://youtu.be/cefnmjtAolY?hd=1 youtube>.
    .
    Slides for that second talk can be obtained from <http://comonad.com/haskell/Lenses-Folds-and-Traversals-NYC.pdf comonad.com>.
    .
    More information on the care and feeding of lenses, including a brief tutorial and motivation
    for their types can be found on the <https://github.com/ekmett/lens/wiki lens wiki>.
    .
    A small game of @pong@ and other more complex examples that manage their state using lenses can be found in the <https://github.com/ekmett/lens/blob/master/examples/ example folder>.
    .
    /Lenses, Folds and Traversals/
    .
    With some signatures simplified, the core of the hierarchy of lens-like constructions looks like:
    .
    .
    <<http://i.imgur.com/ALlbPRa.png>>
    .
    <Hierarchy.png (Local Copy)>
    .
    You can compose any two elements of the hierarchy above using @(.)@ from the @Prelude@, and you can
    use any element of the hierarchy as any type it linked to above it.
    .
    The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
    .
    For instance:
    .
    * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
    .
    * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
    .
    /Minimizing Dependencies/
    .
    If you want to provide lenses and traversals for your own types in your own libraries, then you
    can do so without incurring a dependency on this (or any other) lens package at all.
    .
    /e.g./ for a data type:
    .
    > data Foo a = Foo Int Int a
    .
    You can define lenses such as
    .
    > -- bar :: Lens'\'' (Foo a) Int
    > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
    > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
    .
    > -- quux :: Lens (Foo a) (Foo b) a b
    > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
    > quux f (Foo a b c) = fmap (Foo a b) (f c)
    .
    without the need to use any type that isn'\''t already defined in the @Prelude@.
    .
    And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
    .
    > -- traverseBarAndBaz :: Traversal'\'' (Foo a) Int
    > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
    > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
    .
    What is provided in this library is a number of stock lenses and traversals for
    common haskell types, a wide array of combinators for working them, and more
    exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses, Generics
author: Edward A. Kmett
exposed: True
exposed-modules:
    Control.Exception.Lens Control.Lens Control.Lens.At
    Control.Lens.Combinators Control.Lens.Cons Control.Lens.Each
    Control.Lens.Empty Control.Lens.Equality Control.Lens.Extras
    Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
    Control.Lens.Internal Control.Lens.Internal.Bazaar
    Control.Lens.Internal.ByteString Control.Lens.Internal.Coerce
    Control.Lens.Internal.Context Control.Lens.Internal.Deque
    Control.Lens.Internal.Exception Control.Lens.Internal.FieldTH
    Control.Lens.Internal.PrismTH Control.Lens.Internal.Fold
    Control.Lens.Internal.Getter Control.Lens.Internal.Indexed
    Control.Lens.Internal.Instances Control.Lens.Internal.Iso
    Control.Lens.Internal.Level Control.Lens.Internal.List
    Control.Lens.Internal.Magma Control.Lens.Internal.Prism
    Control.Lens.Internal.Review Control.Lens.Internal.Setter
    Control.Lens.Internal.TH Control.Lens.Internal.Zoom
    Control.Lens.Iso Control.Lens.Lens Control.Lens.Level
    Control.Lens.Operators Control.Lens.Plated Control.Lens.Prism
    Control.Lens.Reified Control.Lens.Review Control.Lens.Setter
    Control.Lens.TH Control.Lens.Traversal Control.Lens.Tuple
    Control.Lens.Type Control.Lens.Wrapped Control.Lens.Zoom
    Control.Monad.Error.Lens Control.Parallel.Strategies.Lens
    Control.Seq.Lens Data.Array.Lens Data.Bits.Lens
    Data.ByteString.Lens Data.ByteString.Strict.Lens
    Data.ByteString.Lazy.Lens Data.Complex.Lens Data.Data.Lens
    Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
    Data.Map.Lens Data.Sequence.Lens Data.Set.Lens Data.Text.Lens
    Data.Text.Strict.Lens Data.Text.Lazy.Lens Data.Tree.Lens
    Data.Typeable.Lens Data.Vector.Lens Data.Vector.Generic.Lens
    GHC.Generics.Lens System.Exit.Lens System.FilePath.Lens
    System.IO.Error.Lens Language.Haskell.TH.Lens Numeric.Lens
hidden-modules: Paths_lens
abi: b98db808265a3b7de3f4796d8f72909c
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/lens-4.15.1
library-dirs: /usr/lib/ghc-8.0.1/site-local/lens-4.15.1
data-dir: /usr/share/arm-linux-ghc-8.0.1/lens-4.15.1
hs-libraries: HSlens-4.15.1-AQi0y6GexOY2BzSazyYQSD
depends:
    array-0.5.1.1 base-4.9.0.0
    base-orphans-0.5.4-5IQvrjd7gNP548VkOOyIq6
    bifunctors-5.4.1-Ac6G6TmMVPE36jXOz0jDKq bytestring-0.10.8.1
    comonad-5-IFpew4VeZSgJKPLIcHpKjC containers-0.5.7.1
    contravariant-1.4-KgMYVwXYQBGKuyyJtYdP11
    distributive-0.5.2-SlRGCHnocy81GrFzDcKVs
    exceptions-0.8.3-5cAKIsqc1DD7jaNW3zLxAN filepath-1.4.1.0
    free-4.12.4-3djEuuVf78E7uL6ewIYMHB ghc-prim-0.5.0.0
    hashable-1.2.6.0-En2FSYN34Tp8YO8pqagtg1
    kan-extensions-5.0.1-E4ZgWfVsXrP8SVkhqQWNWJ
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    parallel-3.2.1.0-6VcN0yUHtcs831TgbJiSSi
    profunctors-5.2-1HLm9WoKgF5GvKRjOhOJmS
    reflection-2.1.2-Lwt0A3NRHka1hAeW9AOpLq
    semigroupoids-5.1-mvlh42rhjC5vNXakyMT7n
    semigroups-0.18.2-2lmUSJvrDkM6JBURGRclWz
    tagged-0.8.5-I7Gu0uzBLkQJCVUvdvwKKq template-haskell-2.11.0.0
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ transformers-0.5.2.0
    transformers-compat-0.5.1.4-81lZyuOJOvsD0zyCv2TKld
    unordered-containers-0.2.8.0-HozSxlbOa6oDZVsS46CFCU
    vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
    void-0.7.2-Gq1uNTFl2JaJr51CTc0tGb
haddock-interfaces: /usr/share/doc/haskell-lens/html/lens.haddock
haddock-html: /usr/share/doc/haskell-lens/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
