#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: tls
version: 1.3.10
id: tls-1.3.10-5d4ZGYPYLXm4OuJ05dFsfM
key: tls-1.3.10-5d4ZGYPYLXm4OuJ05dFsfM
license: BSD3
copyright: Vincent Hanquez <vincent@snarc.org>
maintainer: Vincent Hanquez <vincent@snarc.org>
stability: experimental
homepage: http://github.com/vincenthz/hs-tls
synopsis: TLS/SSL protocol native implementation (Server and Client)
description:
    Native Haskell TLS and SSL protocol implementation for server and client.
    .
    This provides a high-level implementation of a sensitive security protocol,
    eliminating a common set of security issues through the use of the advanced
    type system, high level constructions and common Haskell features.
    .
    Currently implement the SSL3.0, TLS1.0, TLS1.1 and TLS1.2 protocol,
    and support RSA and Ephemeral (Elliptic curve and regular) Diffie Hellman key exchanges,
    and many extensions.
    .
    Some debug tools linked with tls, are available through the
    <http://hackage.haskell.org/package/tls-debug/>.
category: Network
author: Vincent Hanquez <vincent@snarc.org>
exposed: True
exposed-modules:
    Network.TLS Network.TLS.Cipher Network.TLS.Compression
    Network.TLS.Internal Network.TLS.Extra Network.TLS.Extra.Cipher
    Network.TLS.Extra.FFDHE
hidden-modules: Network.TLS.Cap Network.TLS.Struct Network.TLS.Core
                Network.TLS.Context Network.TLS.Context.Internal
                Network.TLS.Credentials Network.TLS.Backend Network.TLS.Crypto
                Network.TLS.Crypto.DH Network.TLS.Crypto.ECDH Network.TLS.ErrT
                Network.TLS.Extension Network.TLS.Extension.EC
                Network.TLS.Handshake Network.TLS.Handshake.Common
                Network.TLS.Handshake.Certificate Network.TLS.Handshake.Key
                Network.TLS.Handshake.Client Network.TLS.Handshake.Server
                Network.TLS.Handshake.Process Network.TLS.Handshake.Signature
                Network.TLS.Handshake.State Network.TLS.Hooks Network.TLS.IO
                Network.TLS.Imports Network.TLS.MAC Network.TLS.Measurement
                Network.TLS.Packet Network.TLS.Parameters Network.TLS.Record
                Network.TLS.Record.Types Network.TLS.Record.Engage
                Network.TLS.Record.Disengage Network.TLS.Record.State
                Network.TLS.RNG Network.TLS.State Network.TLS.Session
                Network.TLS.Sending Network.TLS.Receiving Network.TLS.Util
                Network.TLS.Util.ASN1 Network.TLS.Util.Serialization
                Network.TLS.Types Network.TLS.Wire Network.TLS.X509
abi: 4c9de75405d1a35ecdcfbaba2ded928b
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/tls-1.3.10
library-dirs: /usr/lib/ghc-8.0.1/site-local/tls-1.3.10
data-dir: /usr/share/arm-linux-ghc-8.0.1/tls-1.3.10
hs-libraries: HStls-1.3.10-5d4ZGYPYLXm4OuJ05dFsfM
depends:
    asn1-encoding-0.9.5-KEv9oQIytIt80KsOUoTGaP
    asn1-types-0.3.2-GaKqhjzvrVE1bhI34X9Z4G
    async-2.1.1-9CmNvQft9hOA1w6AR7WdJM base-4.9.0.0 bytestring-0.10.8.1
    cereal-0.5.4.0-1RWVeyNi1If1ir8gxayRPi
    cryptonite-0.22-7bAfM4r9KLCJIhVfr7jYAd
    data-default-class-0.1.2.0-6eetmQ6CbQOLoXb6k5kODu
    memory-0.14.2-6gBSLDcT37k2vocvCRPqMi
    mtl-2.2.1-6qsR1PHUy5lL47Hpoa4jCM
    network-2.6.3.1-G4Up1CPKbp7DeFsnywOnGG transformers-0.5.2.0
    x509-1.6.5-BgKAsefughVEbw7EPM0QMy
    x509-store-1.6.2-CGBkBmJA2tJDWaUOQjfok8
    x509-validation-1.6.5-BypmrfeUpWHBYjxcQOfGNL
haddock-interfaces: /usr/share/doc/haskell-tls/html/tls.haddock
haddock-html: /usr/share/doc/haskell-tls/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
