/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.impl;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultAssumption;
import com.oracle.truffle.api.impl.DefaultCallTarget;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.impl.DefaultDirectCallNode;
import com.oracle.truffle.api.impl.DefaultIndirectCallNode;
import com.oracle.truffle.api.impl.DefaultLoopNode;
import com.oracle.truffle.api.impl.DefaultMaterializedFrame;
import com.oracle.truffle.api.impl.DefaultTVMCI;
import com.oracle.truffle.api.impl.DefaultVirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RepeatingNode;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.WeakHashMap;

public final class DefaultTruffleRuntime
implements TruffleRuntime {
    private final ThreadLocal<DefaultFrameInstance> stackTraces = new ThreadLocal();
    private final Map<RootCallTarget, Void> callTargets = Collections.synchronizedMap(new WeakHashMap());
    private final DefaultTVMCI tvmci = new DefaultTVMCI();

    public DefaultTVMCI getTvmci() {
        return this.tvmci;
    }

    @Override
    public String getName() {
        return "Default Truffle Runtime";
    }

    @Override
    public RootCallTarget createCallTarget(RootNode rootNode) {
        DefaultCallTarget target = new DefaultCallTarget(rootNode);
        rootNode.setCallTarget(target);
        this.getTvmci().onLoad(target);
        this.callTargets.put(target, null);
        return target;
    }

    @Override
    public DirectCallNode createDirectCallNode(CallTarget target) {
        Objects.requireNonNull(target);
        return new DefaultDirectCallNode(target);
    }

    @Override
    public IndirectCallNode createIndirectCallNode() {
        return new DefaultIndirectCallNode();
    }

    @Override
    public VirtualFrame createVirtualFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new DefaultVirtualFrame(frameDescriptor, arguments);
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments) {
        return this.createMaterializedFrame(arguments, new FrameDescriptor());
    }

    @Override
    public MaterializedFrame createMaterializedFrame(Object[] arguments, FrameDescriptor frameDescriptor) {
        return new DefaultMaterializedFrame(new DefaultVirtualFrame(frameDescriptor, arguments));
    }

    @Override
    public CompilerOptions createCompilerOptions() {
        return new DefaultCompilerOptions();
    }

    @Override
    public Assumption createAssumption() {
        return this.createAssumption(null);
    }

    @Override
    public Assumption createAssumption(String name) {
        return new DefaultAssumption(name);
    }

    @Override
    public <T> T iterateFrames(FrameInstanceVisitor<T> visitor) {
        T result = null;
        DefaultFrameInstance frameInstance = this.getThreadLocalStackTrace();
        while (frameInstance != null) {
            result = visitor.visitFrame(frameInstance);
            if (result != null) {
                return result;
            }
            frameInstance = frameInstance.callerFrame;
        }
        return result;
    }

    @Override
    public FrameInstance getCallerFrame() {
        DefaultFrameInstance currentFrame = this.getThreadLocalStackTrace();
        if (currentFrame != null) {
            return currentFrame.callerFrame;
        }
        return null;
    }

    @Override
    public Collection<RootCallTarget> getCallTargets() {
        return Collections.unmodifiableSet(this.callTargets.keySet());
    }

    @Override
    public FrameInstance getCurrentFrame() {
        return this.getThreadLocalStackTrace();
    }

    private DefaultFrameInstance getThreadLocalStackTrace() {
        return this.stackTraces.get();
    }

    private void setThreadLocalStackTrace(DefaultFrameInstance topFrame) {
        this.stackTraces.set(topFrame);
    }

    void pushFrame(VirtualFrame frame, CallTarget target) {
        this.setThreadLocalStackTrace(new DefaultFrameInstance(frame, target, null, this.getThreadLocalStackTrace()));
    }

    void pushFrame(VirtualFrame frame, CallTarget target, Node parentCallNode) {
        DefaultFrameInstance currentFrame = this.getThreadLocalStackTrace();
        if (currentFrame != null) {
            currentFrame = new DefaultFrameInstance(currentFrame.frame, currentFrame.target, parentCallNode, currentFrame.callerFrame);
        }
        this.setThreadLocalStackTrace(new DefaultFrameInstance(frame, target, null, currentFrame));
    }

    void popFrame() {
        DefaultFrameInstance callerFrame = this.getThreadLocalStackTrace().callerFrame;
        if (callerFrame != null) {
            this.setThreadLocalStackTrace(new DefaultFrameInstance(callerFrame.frame, callerFrame.target, null, callerFrame.callerFrame));
        } else {
            this.setThreadLocalStackTrace(null);
        }
    }

    @Override
    public <T> T getCapability(Class<T> capability) {
        Iterator<T> it = ServiceLoader.load(capability).iterator();
        try {
            return it.hasNext() ? (T)it.next() : null;
        }
        catch (ServiceConfigurationError e) {
            return null;
        }
    }

    @Override
    public void notifyTransferToInterpreter() {
    }

    @Override
    public LoopNode createLoopNode(RepeatingNode repeating) {
        if (!(repeating instanceof Node)) {
            throw new IllegalArgumentException("Repeating node must be of type Node.");
        }
        return new DefaultLoopNode(repeating);
    }

    @Override
    public boolean isProfilingEnabled() {
        return false;
    }

    private static class DefaultFrameInstance
    implements FrameInstance {
        private final CallTarget target;
        private final VirtualFrame frame;
        private final Node callNode;
        private final DefaultFrameInstance callerFrame;

        DefaultFrameInstance(VirtualFrame frame, CallTarget target, Node callNode, DefaultFrameInstance callerFrame) {
            this.target = target;
            this.frame = frame;
            this.callNode = callNode;
            this.callerFrame = callerFrame;
        }

        @Override
        public final Frame getFrame(FrameInstance.FrameAccess access, boolean slowPath) {
            if (access == FrameInstance.FrameAccess.NONE) {
                return null;
            }
            if (access == FrameInstance.FrameAccess.MATERIALIZE) {
                return this.frame.materialize();
            }
            return this.frame;
        }

        @Override
        public final boolean isVirtualFrame() {
            return false;
        }

        @Override
        public final CallTarget getCallTarget() {
            return this.target;
        }

        @Override
        public Node getCallNode() {
            return this.callNode;
        }
    }
}

