/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.interop.java;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.java.JavaFunctionObject;
import com.oracle.truffle.api.interop.java.JavaInteropReflect;
import com.oracle.truffle.api.interop.java.JavaObject;
import com.oracle.truffle.api.interop.java.ToJavaNode;
import com.oracle.truffle.api.interop.java.ToJavaNodeGen;
import com.oracle.truffle.api.interop.java.TypeAndClass;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.lang.reflect.Method;

public final class JavaInterop {
    private JavaInterop() {
    }

    public static <T> T asJavaObject(Class<T> type, TruffleObject foreignObject) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, ToJavaNodeGen.create(), foreignObject, type);
        Object convertedValue = Truffle.getRuntime().createCallTarget(root).call(new Object[0]);
        return type.cast(convertedValue);
    }

    public static TruffleObject asTruffleObject(Object obj) {
        if (obj instanceof TruffleObject) {
            return (TruffleObject)obj;
        }
        if (obj instanceof Class) {
            return new JavaObject(null, (Class)obj);
        }
        if (obj == null) {
            return JavaObject.NULL;
        }
        if (TruffleOptions.AOT) {
            throw new IllegalArgumentException();
        }
        return JavaInteropReflect.asTruffleViaReflection(obj);
    }

    public static Object asTruffleValue(Object obj) {
        return JavaInterop.isPrimitive(obj) ? obj : JavaInterop.asTruffleObject(obj);
    }

    public static boolean isPrimitive(Object obj) {
        if (obj instanceof TruffleObject) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        return ToJavaNode.isPrimitive(obj);
    }

    public static <T> T asJavaFunction(Class<T> functionalType, TruffleObject function) {
        TemporaryConvertRoot root = new TemporaryConvertRoot(TruffleLanguage.class, ToJavaNodeGen.create(), function, functionalType);
        return functionalType.cast(Truffle.getRuntime().createCallTarget(root).call(new Object[0]));
    }

    public static <T> TruffleObject asTruffleFunction(Class<T> functionalType, T implementation) {
        Method method = JavaInterop.functionalInterfaceMethod(functionalType);
        if (method == null) {
            throw new IllegalArgumentException();
        }
        return new JavaFunctionObject(method, implementation);
    }

    public static boolean isNull(TruffleObject foreignObject) {
        if (foreignObject == null) {
            return true;
        }
        return JavaInterop.boolMessage(Message.IS_NULL, foreignObject);
    }

    public static boolean isArray(TruffleObject foreignObject) {
        if (foreignObject == null) {
            return false;
        }
        return JavaInterop.boolMessage(Message.HAS_SIZE, foreignObject);
    }

    public static boolean isBoxed(TruffleObject foreignObject) {
        if (foreignObject == null) {
            return false;
        }
        return JavaInterop.boolMessage(Message.IS_BOXED, foreignObject);
    }

    public static Object unbox(TruffleObject foreignObject) {
        if (foreignObject == null) {
            return null;
        }
        try {
            return ToJavaNode.message(null, Message.UNBOX, foreignObject, new Object[0]);
        }
        catch (InteropException iex) {
            return null;
        }
    }

    private static boolean boolMessage(Message message, TruffleObject foreignObject) {
        try {
            Object isTrue = ToJavaNode.message(null, message, foreignObject, new Object[0]);
            return Boolean.TRUE.equals(isTrue);
        }
        catch (InteropException iex) {
            return false;
        }
    }

    private static <T> Method functionalInterfaceMethod(Class<T> functionalType) {
        if (!functionalType.isInterface()) {
            return null;
        }
        Method[] arr = functionalType.getMethods();
        if (arr.length == 1) {
            return arr[0];
        }
        Method found = null;
        for (Method m : arr) {
            if ((m.getModifiers() & 0x400) == 0) continue;
            try {
                Object.class.getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (found != null) {
                    return null;
                }
                found = m;
            }
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    static boolean isJavaFunctionInterface(Class<?> type) {
        if (!type.isInterface() || type == TruffleObject.class) {
            return false;
        }
        if (type.getAnnotation(FunctionalInterface.class) != null) {
            return true;
        }
        return type.getMethods().length == 1;
    }

    private static class TemporaryConvertRoot
    extends RootNode {
        @Node.Child
        private ToJavaNode node;
        private final Object value;
        private final Class<?> type;

        TemporaryConvertRoot(Class<? extends TruffleLanguage> lang, ToJavaNode node, Object value, Class<?> type) {
            super(lang, null, null);
            this.node = node;
            this.value = value;
            this.type = type;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.node.execute(frame, this.value, new TypeAndClass(null, this.type));
        }
    }
}

