/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.pack;

import java.nio.ByteOrder;
import org.jruby.truffle.core.format.pack.SimplePackListener;

public class SimplePackParser {
    public static final int COUNT_NONE = -1;
    public static final int COUNT_STAR = -2;
    public static final int SIZE_NATIVE = -1;
    private final SimplePackListener listener;
    private final byte[] bytes;
    private int n;

    public SimplePackParser(SimplePackListener listener, byte[] bytes) {
        this.listener = listener;
        this.bytes = bytes;
    }

    public void parse() {
        block65: while (this.n < this.bytes.length) {
            byte b = this.bytes[this.n];
            switch (b) {
                case 67: 
                case 73: 
                case 74: 
                case 76: 
                case 78: 
                case 81: 
                case 83: 
                case 86: 
                case 99: 
                case 105: 
                case 106: 
                case 108: 
                case 110: 
                case 113: 
                case 115: 
                case 118: {
                    boolean signed;
                    int size;
                    ++this.n;
                    switch (b) {
                        case 67: 
                        case 99: {
                            size = 8;
                            break;
                        }
                        case 83: 
                        case 110: 
                        case 115: 
                        case 118: {
                            size = 16;
                            break;
                        }
                        case 73: 
                        case 78: 
                        case 86: 
                        case 105: {
                            size = 32;
                            break;
                        }
                        case 74: 
                        case 81: 
                        case 106: 
                        case 113: {
                            size = 64;
                            break;
                        }
                        case 76: 
                        case 108: {
                            size = -1;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(Character.toString((char)b));
                        }
                    }
                    switch (b) {
                        case 99: 
                        case 105: 
                        case 106: 
                        case 108: 
                        case 113: 
                        case 115: {
                            signed = true;
                            break;
                        }
                        case 67: 
                        case 73: 
                        case 74: 
                        case 76: 
                        case 78: 
                        case 81: 
                        case 83: 
                        case 86: 
                        case 110: 
                        case 118: {
                            signed = false;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(Character.toString((char)b));
                        }
                    }
                    ByteOrder byteOrder = null;
                    switch (b) {
                        case 86: 
                        case 118: {
                            byteOrder = ByteOrder.LITTLE_ENDIAN;
                            break;
                        }
                        case 78: 
                        case 110: {
                            byteOrder = ByteOrder.BIG_ENDIAN;
                            break;
                        }
                        case 74: 
                        case 106: {
                            byteOrder = ByteOrder.nativeOrder();
                        }
                    }
                    block66: while (this.n < this.bytes.length) {
                        byte m = this.bytes[this.n];
                        switch (m) {
                            case 60: 
                            case 62: {
                                ++this.n;
                                switch (m) {
                                    case 60: {
                                        byteOrder = ByteOrder.LITTLE_ENDIAN;
                                        continue block66;
                                    }
                                    case 62: {
                                        byteOrder = ByteOrder.BIG_ENDIAN;
                                        continue block66;
                                    }
                                }
                                throw new UnsupportedOperationException(Character.toString((char)m));
                            }
                            case 33: 
                            case 95: {
                                ++this.n;
                                switch (b) {
                                    case 73: 
                                    case 74: 
                                    case 76: 
                                    case 81: 
                                    case 83: 
                                    case 105: 
                                    case 106: 
                                    case 108: 
                                    case 113: 
                                    case 115: {
                                        if (byteOrder != null) break;
                                        byteOrder = ByteOrder.nativeOrder();
                                        break;
                                    }
                                    default: {
                                        this.listener.error(String.format("'%c' allowed only after types sSiIlLqQjJ", Character.valueOf((char)m)));
                                    }
                                }
                                if (size != -1) continue block66;
                                size = 64;
                                continue block66;
                            }
                            case 0: 
                            case 9: 
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 32: {
                                ++this.n;
                                continue block66;
                            }
                        }
                        break;
                    }
                    if (size == -1) {
                        size = 32;
                    }
                    if (byteOrder == null) {
                        byteOrder = ByteOrder.nativeOrder();
                    }
                    int count = this.count();
                    this.listener.integer(size, signed, byteOrder, count);
                    continue block65;
                }
                case 85: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.utf8Character(this.count());
                    continue block65;
                }
                case 119: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.berInteger(this.count());
                    continue block65;
                }
                case 68: 
                case 69: 
                case 70: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: {
                    ByteOrder byteOrder;
                    int size;
                    ++this.n;
                    switch (b) {
                        case 70: 
                        case 101: 
                        case 102: 
                        case 103: {
                            size = 32;
                            break;
                        }
                        case 68: 
                        case 69: 
                        case 71: 
                        case 100: {
                            size = 64;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(Character.toString((char)b));
                        }
                    }
                    switch (b) {
                        case 68: 
                        case 70: 
                        case 100: 
                        case 102: {
                            byteOrder = ByteOrder.nativeOrder();
                            break;
                        }
                        case 69: 
                        case 101: {
                            byteOrder = ByteOrder.LITTLE_ENDIAN;
                            break;
                        }
                        case 71: 
                        case 103: {
                            byteOrder = ByteOrder.BIG_ENDIAN;
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(Character.toString((char)b));
                        }
                    }
                    this.disallowNative(b);
                    int count = this.count();
                    this.listener.floatingPoint(size, byteOrder, count);
                    continue block65;
                }
                case 65: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringSpacePadded(this.count());
                    continue block65;
                }
                case 97: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringNullPadded(this.count());
                    continue block65;
                }
                case 90: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.binaryStringNullStar(this.count());
                    continue block65;
                }
                case 98: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.bitStringMSBLast(this.count());
                    continue block65;
                }
                case 66: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.bitStringMSBFirst(this.count());
                    continue block65;
                }
                case 72: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.hexStringHighFirst(this.count());
                    continue block65;
                }
                case 104: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.hexStringLowFirst(this.count());
                    continue block65;
                }
                case 117: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.uuString(this.count());
                    continue block65;
                }
                case 77: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.mimeString(this.count());
                    continue block65;
                }
                case 109: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.base64String(this.count());
                    continue block65;
                }
                case 80: 
                case 112: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.pointer();
                    continue block65;
                }
                case 64: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.at(this.count());
                    continue block65;
                }
                case 88: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.back(this.count());
                    continue block65;
                }
                case 120: {
                    ++this.n;
                    this.disallowNative(b);
                    this.listener.nullByte(this.count());
                    continue block65;
                }
                case 37: {
                    ++this.n;
                    this.listener.error("% is not supported");
                    continue block65;
                }
                case 40: {
                    ++this.n;
                    this.listener.startSubSequence();
                    continue block65;
                }
                case 41: {
                    ++this.n;
                    this.listener.finishSubSequence(this.count());
                    continue block65;
                }
                case 0: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ++this.n;
                    continue block65;
                }
                case 35: {
                    ++this.n;
                    while (this.n < this.bytes.length) {
                        switch (this.bytes[this.n]) {
                            case 10: 
                            case 13: {
                                ++this.n;
                                continue block65;
                            }
                        }
                        ++this.n;
                    }
                    continue block65;
                }
            }
            throw new UnsupportedOperationException(Character.toString((char)b));
        }
    }

    private int count() {
        int count = -1;
        block4: while (this.n < this.bytes.length) {
            byte b = this.bytes[this.n];
            switch (b) {
                case 42: {
                    ++this.n;
                    return -2;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    if (count == -1) {
                        count = 0;
                    }
                    count *= 10;
                    count += this.bytes[this.n] - 48;
                    ++this.n;
                    continue block4;
                }
            }
            break;
        }
        return count;
    }

    private void disallowNative(byte b) {
        byte m;
        if (this.n < this.bytes.length && ((m = this.bytes[this.n]) == 33 || m == 95)) {
            ++this.n;
            this.listener.error(String.format("'%c' allowed only after types sSiIlLqQjJ", Character.valueOf((char)b)));
        }
    }
}

