/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.backtrace;

import com.oracle.truffle.api.nodes.Node;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyBaseNode;
import org.jruby.truffle.language.backtrace.Activation;
import org.jruby.truffle.language.backtrace.BacktraceFormatter;

public class Backtrace {
    private final Activation[] activations;
    private final Throwable javaThrowable;

    public Backtrace(Activation[] activations, Throwable javaThrowable) {
        this.activations = activations;
        this.javaThrowable = javaThrowable;
    }

    public List<Activation> getActivations() {
        return Collections.unmodifiableList(Arrays.asList(this.activations));
    }

    public Throwable getJavaThrowable() {
        return this.javaThrowable;
    }

    public String toString() {
        Activation activation;
        Node node;
        RubyContext context = null;
        if (this.activations.length > 0 && (node = (activation = this.activations[0]).getCallNode()) != null && node instanceof RubyBaseNode) {
            context = ((RubyBaseNode)node).getContext();
        }
        if (context != null) {
            BacktraceFormatter backtraceFormatter = new BacktraceFormatter(context, EnumSet.of(BacktraceFormatter.FormattingFlags.INCLUDE_CORE_FILES));
            StringBuilder builder = new StringBuilder();
            for (String line : backtraceFormatter.formatBacktrace(context, null, this)) {
                builder.append("\n");
                builder.append(line);
            }
            return builder.toString().substring(1);
        }
        return "";
    }
}

