/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.constants;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.language.LexicalScope;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.constants.GetConstantNode;
import org.jruby.truffle.language.constants.LookupConstantWithLexicalScopeNode;
import org.jruby.truffle.language.constants.LookupConstantWithLexicalScopeNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class ReadConstantWithLexicalScopeNode
extends RubyNode {
    private final LexicalScope lexicalScope;
    private final String name;
    @Node.Child
    private LookupConstantWithLexicalScopeNode lookupConstantNode;
    @Node.Child
    private GetConstantNode getConstantNode = GetConstantNode.create();

    public ReadConstantWithLexicalScopeNode(LexicalScope lexicalScope, String name) {
        this.lexicalScope = lexicalScope;
        this.name = name;
        this.lookupConstantNode = LookupConstantWithLexicalScopeNodeGen.create(lexicalScope, name);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        RubyConstant constant = this.lookupConstantNode.executeLookupConstant(frame);
        DynamicObject module = this.lexicalScope.getLiveModule();
        return this.getConstantNode.executeGetConstant(frame, module, this.name, constant, this.lookupConstantNode);
    }

    public Object readConstant(VirtualFrame frame, Object module, String name) {
        return this.execute(frame);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        RubyConstant constant;
        try {
            constant = this.lookupConstantNode.executeLookupConstant(frame);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNameErrorClass()) {
                return this.nil();
            }
            throw e;
        }
        if (constant == null) {
            return this.nil();
        }
        return this.create7BitString("constant", UTF8Encoding.INSTANCE);
    }
}

