/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.core.cast.ProcOrNullNode;
import org.jruby.truffle.core.cast.ProcOrNullNodeGen;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.methods.CallInternalMethodNode;
import org.jruby.truffle.language.methods.CallInternalMethodNodeGen;
import org.jruby.truffle.language.methods.DeclarationContext;
import org.jruby.truffle.language.methods.InternalMethod;

@NodeChildren(value={@NodeChild(value="method"), @NodeChild(value="arguments"), @NodeChild(value="block")})
public abstract class CallBoundMethodNode
extends RubyNode {
    @Node.Child
    private CallInternalMethodNode callInternalMethodNode = CallInternalMethodNodeGen.create(null, null);
    @Node.Child
    private ProcOrNullNode procOrNullNode = ProcOrNullNodeGen.create(null);

    public abstract Object executeCallBoundMethod(VirtualFrame var1, DynamicObject var2, Object[] var3, Object var4);

    @Specialization
    protected Object call(VirtualFrame frame, DynamicObject method, Object[] arguments, Object block) {
        InternalMethod internalMethod = Layouts.METHOD.getMethod(method);
        DynamicObject typedBlock = this.procOrNullNode.executeProcOrNull(block);
        Object[] frameArguments = this.packArguments(method, internalMethod, arguments, typedBlock);
        return this.callInternalMethodNode.executeCallMethod(frame, internalMethod, frameArguments);
    }

    private Object[] packArguments(DynamicObject method, InternalMethod internalMethod, Object[] arguments, DynamicObject block) {
        return RubyArguments.pack(null, null, internalMethod, DeclarationContext.METHOD, null, Layouts.METHOD.getReceiver(method), block, arguments);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().DISPATCH_CACHE;
    }
}

