/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.symbol.SymbolTable;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

@NodeChildren(value={@NodeChild(value="object"), @NodeChild(value="name")})
public abstract class ObjectIVarGetNode
extends RubyNode {
    private final boolean checkName;

    public ObjectIVarGetNode(boolean checkName) {
        this.checkName = checkName;
    }

    public abstract Object executeIVarGet(DynamicObject var1, String var2);

    @Specialization(guards={"name == cachedName"}, limit="getCacheLimit()")
    public Object ivarGetCached(DynamicObject object, String name, @Cached(value="name") String cachedName, @Cached(value="createReadFieldNode(checkName(cachedName, object))") ReadObjectFieldNode readObjectFieldNode) {
        return readObjectFieldNode.execute(object);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(contains={"ivarGetCached"})
    public Object ivarGetUncached(DynamicObject object, String name) {
        return object.get(this.checkName(name, object), this.nil());
    }

    protected String checkName(String name, DynamicObject object) {
        return this.checkName ? SymbolTable.checkInstanceVariableName(this.getContext(), name, object, this) : name;
    }

    protected ReadObjectFieldNode createReadFieldNode(String name) {
        return ReadObjectFieldNodeGen.create(name, this.nil());
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().INSTANCE_VARIABLE_CACHE;
    }
}

