/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TagBinding
extends BasePrimitiveBinding
implements MultiNodeBinding {
    private final String myTextIfEmpty;

    public TagBinding(@NotNull MutableAccessor accessor, @NotNull Tag tagAnnotation) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        if (tagAnnotation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagAnnotation", "com/intellij/util/xmlb/TagBinding", "<init>"));
        }
        super(accessor, tagAnnotation.value(), null);
        this.myTextIfEmpty = tagAnnotation.textIfEmpty();
    }

    @Override
    @Nullable
    public Object deserializeList(Object context, @NotNull List<Element> elements) {
        List<Element> children;
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/util/xmlb/TagBinding", "deserializeList"));
        }
        if (elements.size() == 1) {
            children = elements.get(0).getChildren();
        } else {
            String name2 = elements.get(0).getName();
            children = new ArrayList<Element>();
            for (Element element : elements) {
                assert (element.getName().equals(name2));
                children.addAll(element.getChildren());
            }
        }
        this.deserialize(context, children);
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    @Nullable
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        if (this.myBinding == null) {
            String value = XmlSerializerImpl.getTextValue(element, this.myTextIfEmpty);
            XmlSerializerImpl.doSet(context, value, this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.deserialize(context, element.getChildren());
        }
        return context;
    }

    private void deserialize(Object o, @NotNull List<Element> children) {
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/util/xmlb/TagBinding", "deserialize"));
        }
        assert (this.myBinding != null);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(o, children.get(0), null);
        } else {
            this.myAccessor.set(o, Binding.deserializeList(this.myBinding, this.myAccessor.read(o), children));
        }
    }

    @Override
    public boolean isBoundTo(@NotNull Element node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/util/xmlb/TagBinding", "isBoundTo"));
        }
        return node.getName().equals(this.myName);
    }
}

