/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.backend.ast;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.common.Symbol;

public class JsName
extends HasMetadata
implements Symbol {
    private static int ordinalGenerator;
    private final JsScope enclosing;
    private final int ordinal;
    @NotNull
    private final String ident;
    private final boolean temporary;

    JsName(JsScope enclosing, @NotNull String ident, boolean temporary) {
        int n;
        if (ident == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ident", "org/jetbrains/kotlin/js/backend/ast/JsName", "<init>"));
        }
        this.enclosing = enclosing;
        this.ident = ident;
        this.temporary = temporary;
        if (temporary) {
            int n2 = ordinalGenerator;
            n = n2;
            ordinalGenerator = n2 + 1;
        } else {
            n = 0;
        }
        this.ordinal = n;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public JsScope getEnclosing() {
        return this.enclosing;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    @NotNull
    public String getIdent() {
        String string = this.ident;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsName", "getIdent"));
        }
        return string;
    }

    @NotNull
    public JsNameRef makeRef() {
        JsNameRef jsNameRef = new JsNameRef(this);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/backend/ast/JsName", "makeRef"));
        }
        return jsNameRef;
    }

    public String toString() {
        return this.ident;
    }
}

