/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.reference;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.reference.AccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.BackingFieldAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.CompanionObjectIntrinsicAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.ReferenceAccessTranslator;
import org.jetbrains.kotlin.js.translate.reference.VariableAccessTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.BindingUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.PsiUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

public final class ReferenceTranslator {
    private ReferenceTranslator() {
    }

    @NotNull
    public static JsExpression translateSimpleName(@NotNull KtSimpleNameExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        JsExpression jsExpression = ReferenceTranslator.getAccessTranslator(expression, context).translateAsGet();
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateSimpleName"));
        }
        return jsExpression;
    }

    @NotNull
    public static JsExpression translateAsValueReference(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
        }
        JsExpression alias = context.getAliasForDescriptor(descriptor2);
        if (alias != null) {
            JsExpression jsExpression = alias;
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
            }
            return jsExpression;
        }
        if (ReferenceTranslator.shouldTranslateAsFQN(descriptor2, context)) {
            JsNameRef jsNameRef = context.getQualifiedReference(descriptor2);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
            }
            return jsNameRef;
        }
        if (descriptor2 instanceof PropertyDescriptor) {
            PropertyDescriptor property = (PropertyDescriptor)descriptor2;
            if (context.isFromCurrentModule(property)) {
                JsNameRef jsNameRef = context.getInnerReference(property);
                if (jsNameRef == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
                }
                return jsNameRef;
            }
            JsNameRef qualifier = context.getInnerReference(property.getContainingDeclaration());
            JsName name2 = context.getNameForDescriptor(property);
            JsNameRef jsNameRef = new JsNameRef(name2, (JsExpression)qualifier);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
            }
            return jsNameRef;
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            if (!context.isFromCurrentModule(descriptor2)) {
                JsExpression jsExpression = ReferenceTranslator.getLazyReferenceToObject((ClassDescriptor)descriptor2, context);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
                }
                return jsExpression;
            }
            JsNameRef functionRef = JsAstUtils.pureFqn(context.getNameForObjectInstance((ClassDescriptor)descriptor2), null);
            JsInvocation jsInvocation = new JsInvocation((JsExpression)functionRef, new JsExpression[0]);
            if (jsInvocation == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
            }
            return jsInvocation;
        }
        JsNameRef jsNameRef = context.getInnerReference(descriptor2);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsValueReference"));
        }
        return jsNameRef;
    }

    @NotNull
    public static JsExpression translateAsTypeReference(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
        }
        if (AnnotationsUtils.isNativeObject(descriptor2)) {
            JsNameRef jsNameRef = context.getQualifiedReference(descriptor2);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
            }
            return jsNameRef;
        }
        if (!ReferenceTranslator.shouldTranslateAsFQN(descriptor2, context)) {
            if ((DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) && !context.isFromCurrentModule(descriptor2)) {
                JsExpression jsExpression = ReferenceTranslator.getPrototypeIfNecessary(descriptor2, ReferenceTranslator.getLazyReferenceToObject(descriptor2, context));
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
                }
                return jsExpression;
            }
            JsNameRef jsNameRef = context.getInnerReference(descriptor2);
            if (jsNameRef == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
            }
            return jsNameRef;
        }
        JsExpression jsExpression = ReferenceTranslator.getPrototypeIfNecessary(descriptor2, context.getQualifiedReference(descriptor2));
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "translateAsTypeReference"));
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getPrototypeIfNecessary(@NotNull ClassDescriptor descriptor2, @NotNull JsExpression reference) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getPrototypeIfNecessary"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getPrototypeIfNecessary"));
        }
        if (DescriptorUtils.isObject(descriptor2) || DescriptorUtils.isEnumEntry(descriptor2)) {
            JsNameRef getPrototypeRef = JsAstUtils.pureFqn("getPrototypeOf", (JsExpression)JsAstUtils.pureFqn("Object", null));
            JsInvocation getPrototypeInvocation = new JsInvocation((JsExpression)getPrototypeRef, reference);
            MetadataProperties.setSideEffects(getPrototypeInvocation, SideEffectKind.PURE);
            reference = JsAstUtils.pureFqn("constructor", (JsExpression)getPrototypeInvocation);
        }
        JsExpression jsExpression = reference;
        if (jsExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getPrototypeIfNecessary"));
        }
        return jsExpression;
    }

    @NotNull
    private static JsExpression getLazyReferenceToObject(@NotNull ClassDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getLazyReferenceToObject"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getLazyReferenceToObject"));
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        JsNameRef qualifier = context.getInnerReference(container2);
        JsNameRef jsNameRef = new JsNameRef(context.getNameForDescriptor(descriptor2), (JsExpression)qualifier);
        if (jsNameRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getLazyReferenceToObject"));
        }
        return jsNameRef;
    }

    private static boolean shouldTranslateAsFQN(@NotNull DeclarationDescriptor descriptor2, @NotNull TranslationContext context) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "shouldTranslateAsFQN"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "shouldTranslateAsFQN"));
        }
        return ReferenceTranslator.isLocalVarOrFunction(descriptor2) || AnnotationsUtils.isNativeObject(descriptor2) || AnnotationsUtils.isLibraryObject(descriptor2) || context.isPublicInlineFunction();
    }

    private static boolean isLocalVarOrFunction(DeclarationDescriptor descriptor2) {
        return descriptor2.getContainingDeclaration() instanceof FunctionDescriptor && !(descriptor2 instanceof ClassDescriptor);
    }

    @NotNull
    public static AccessTranslator getAccessTranslator(@NotNull KtSimpleNameExpression referenceExpression, @NotNull TranslationContext context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        if (KtPsiUtil.isBackingFieldReference(BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), referenceExpression))) {
            BackingFieldAccessTranslator backingFieldAccessTranslator = BackingFieldAccessTranslator.newInstance(referenceExpression, context);
            if (backingFieldAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return backingFieldAccessTranslator;
        }
        if (ReferenceTranslator.canBePropertyAccess(referenceExpression, context)) {
            VariableAccessTranslator variableAccessTranslator = VariableAccessTranslator.newInstance(context, referenceExpression, null);
            if (variableAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return variableAccessTranslator;
        }
        if (CompanionObjectIntrinsicAccessTranslator.isCompanionObjectReference(referenceExpression, context)) {
            CompanionObjectIntrinsicAccessTranslator companionObjectIntrinsicAccessTranslator = CompanionObjectIntrinsicAccessTranslator.newInstance(referenceExpression, context);
            if (companionObjectIntrinsicAccessTranslator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
            }
            return companionObjectIntrinsicAccessTranslator;
        }
        ReferenceAccessTranslator referenceAccessTranslator = ReferenceAccessTranslator.newInstance(referenceExpression, context);
        if (referenceAccessTranslator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "getAccessTranslator"));
        }
        return referenceAccessTranslator;
    }

    public static boolean canBePropertyAccess(@NotNull KtExpression expression, @NotNull TranslationContext context) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/reference/ReferenceTranslator", "canBePropertyAccess"));
        }
        KtSimpleNameExpression simpleNameExpression = null;
        if (expression instanceof KtQualifiedExpression) {
            simpleNameExpression = PsiUtils.getSelectorAsSimpleName((KtQualifiedExpression)expression);
        } else if (expression instanceof KtSimpleNameExpression) {
            simpleNameExpression = (KtSimpleNameExpression)expression;
        }
        if (simpleNameExpression == null) {
            return false;
        }
        DeclarationDescriptor descriptor2 = BindingUtils.getDescriptorForReferenceExpression(context.bindingContext(), simpleNameExpression);
        return descriptor2 instanceof VariableDescriptor && !(descriptor2 instanceof ValueParameterDescriptor);
    }
}

