/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.svg;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Stack;
import org.freehep.graphics2d.TagHandler;
import org.freehep.graphics2d.TagString;
import org.freehep.graphicsio.svg.SVGGraphics2D;

public class SVGTagHandler
extends TagHandler {
    private static final float scriptShiftRatio = 0.5f;
    private static final float scriptSizeFactor = 0.6666667f;
    private static final String mM = "mM";
    private float x;
    private float y;
    private boolean print;
    private boolean stylable;
    private Font font;
    private Stack fontStack;
    private FontRenderContext fontContext;

    public SVGTagHandler(boolean stylable, Font font, FontRenderContext fontContext) {
        this.stylable = stylable;
        this.font = font;
        this.fontContext = fontContext;
    }

    public int stringWidth(TagString s) {
        this.x = 0.0f;
        this.y = 0.0f;
        this.fontStack = new Stack();
        this.print = false;
        this.parse(s);
        this.print = true;
        return (int)this.x;
    }

    /*
     * WARNING - void declaration
     */
    protected String openTag(String tag) {
        void var2_2;
        String tagString;
        if (tag.equalsIgnoreCase("b")) {
            tagString = "font-weight:bold";
        } else if (tag.equalsIgnoreCase("i")) {
            tagString = "font-style:italic";
        } else if (tag.equalsIgnoreCase("v")) {
            tagString = "";
        } else if (tag.equalsIgnoreCase("over")) {
            tagString = "text-decoration:overline";
        } else if (tag.equalsIgnoreCase("sup")) {
            this.y -= this.font.getLineMetrics(mM, this.fontContext).getAscent() * 0.5f;
            this.fontStack.push(this.font);
            this.font = this.font.deriveFont(this.font.getSize2D() * 0.6666667f);
            tagString = "baseline-shift:super;font-size:" + this.font.getSize2D();
        } else if (tag.equalsIgnoreCase("sub")) {
            this.y += this.font.getLineMetrics(mM, this.fontContext).getAscent() * 0.5f;
            this.fontStack.push(this.font);
            this.font = this.font.deriveFont(this.font.getSize2D() * 0.6666667f);
            tagString = "baseline-shift:sub;font-size:" + this.font.getSize2D();
        } else {
            return super.openTag(tag);
        }
        return "<tspan " + SVGGraphics2D.style(this.stylable, (String)var2_2) + ">";
    }

    protected String closeTag(String tag) {
        if (!(tag.equalsIgnoreCase("b") || tag.equalsIgnoreCase("i") || tag.equalsIgnoreCase("v") || tag.equalsIgnoreCase("over"))) {
            if (tag.equalsIgnoreCase("sup")) {
                this.font = (Font)this.fontStack.pop();
                this.y += this.font.getLineMetrics(mM, this.fontContext).getAscent() * 0.5f;
            } else if (tag.equalsIgnoreCase("sub")) {
                this.font = (Font)this.fontStack.pop();
                this.y -= this.font.getLineMetrics(mM, this.fontContext).getAscent() * 0.5f;
            } else {
                return super.closeTag(tag);
            }
        }
        return "</tspan>";
    }

    protected String defaultEntity(String entity) {
        if (this.print) {
            return "&" + entity + ";";
        }
        return super.defaultEntity(entity);
    }

    protected String entity(String entity) {
        if (this.print) {
            return "&" + entity + ";";
        }
        return "m";
    }

    protected String text(String text) {
        double width = this.font.getStringBounds(text, this.fontContext).getWidth();
        this.x = (float)((double)this.x + width);
        return text;
    }

    public static void main(String[] args) {
        String text = "&lt;Vector<sup><b>Graphics</b></sup> &amp; Card<i><sub>Adapter</sub></i>&gt;";
        TagString s = new TagString(text);
        SVGTagHandler handler = new SVGTagHandler(true, new Font("Helvetica", 18, 0), new FontRenderContext(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f), true, true));
        System.out.println("\"" + s + "\"");
        System.out.println(handler.parse(s));
    }
}

