/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class ConstrainedGridLayout
implements LayoutManager2 {
    private Dimension gridSize;
    private Dimension aspectRatio;
    private Dimension containerFormat;
    public static final String GRID_SIZE_ERROR = "Grid size must have width and height > 0.";
    public static final String ASPECT_RATIO_ERROR = "Aspect ratio must have width and height > 0.";
    public static final String CONSTRAINT_ERROR = "Constraint must be a Rectangle with positive width and height.";
    public static final String CONSTRAINED_GRID_LAYOUT_CONSTRAINT = "ConstrainedGridLayout.RectangularConstraint";
    public static final int MINIMUM_LAYOUT = 0;
    public static final int PREFERRED_LAYOUT = 1;
    private static final int[] primes = new int[]{1, 2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97};
    private static final int[][] factorization = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 4, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 2, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0}, {1, 3, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {1, 4, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0}, {1, 2, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 3, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0}, {1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 5, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, {1, 1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 0, 2, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {1, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public ConstrainedGridLayout(Dimension gridSize, Dimension aspectRatio) {
        if (gridSize.width <= 0 || gridSize.height <= 0 || gridSize.width > 100 || gridSize.height > 100) {
            throw new IllegalArgumentException(GRID_SIZE_ERROR);
        }
        if (aspectRatio.width <= 0 || aspectRatio.height <= 0 || aspectRatio.width > 100 || aspectRatio.height > 100) {
            throw new IllegalArgumentException(ASPECT_RATIO_ERROR);
        }
        this.gridSize = new Dimension(gridSize);
        this.aspectRatio = new Dimension(aspectRatio);
        this.containerFormat = new Dimension();
        this.containerFormat = ConstrainedGridLayout.getSmallestDimension(this.containerFormat, aspectRatio, gridSize);
    }

    public Dimension getGridSize() {
        return new Dimension(this.gridSize);
    }

    public void setGridSize(Dimension gridSize) {
        if (gridSize.width <= 0 || gridSize.height <= 0 || gridSize.width > 100 || gridSize.height > 100) {
            throw new IllegalArgumentException(GRID_SIZE_ERROR);
        }
        this.gridSize.setSize(gridSize);
        this.containerFormat = ConstrainedGridLayout.getSmallestDimension(this.containerFormat, this.aspectRatio, gridSize);
    }

    public Dimension getAspectRatio() {
        return new Dimension(this.aspectRatio);
    }

    public void setAspectRatio(Dimension aspectRatio) {
        if (aspectRatio.width <= 0 || aspectRatio.height <= 0) {
            throw new IllegalArgumentException(ASPECT_RATIO_ERROR);
        }
        this.aspectRatio.setSize(aspectRatio);
        this.containerFormat = ConstrainedGridLayout.getSmallestDimension(this.containerFormat, aspectRatio, this.gridSize);
    }

    public Rectangle getConstraints(Component comp) {
        JComponent jc;
        Object constraint;
        Rectangle r = null;
        if (comp instanceof JComponent && (constraint = (jc = (JComponent)comp).getClientProperty(CONSTRAINED_GRID_LAYOUT_CONSTRAINT)) instanceof Rectangle) {
            r = (Rectangle)constraint;
        }
        return r != null ? new Rectangle(r) : null;
    }

    public void setConstraints(Component comp, Rectangle constraints) {
        if (comp instanceof JComponent) {
            Rectangle copy = new Rectangle(constraints);
            JComponent jc = (JComponent)comp;
            jc.putClientProperty(CONSTRAINED_GRID_LAYOUT_CONSTRAINT, copy);
        }
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void removeLayoutComponent(Component comp) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 1);
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.getLayoutSize(parent, 0);
    }

    protected Dimension getLayoutSize(Container parent, int selectionFlag) {
        int cellHeight = 0;
        int cellWidth = 0;
        for (int i = 0; i < parent.getComponentCount(); ++i) {
            Component c = parent.getComponent(i);
            Rectangle r = this.getConstraints(c);
            if (c == null || r == null) continue;
            Dimension componentSize = null;
            switch (selectionFlag) {
                case 0: {
                    componentSize = c.getMinimumSize();
                    break;
                }
                case 1: {
                    componentSize = c.getPreferredSize();
                }
            }
            cellWidth = Math.max(cellWidth, componentSize.width / r.width);
            cellHeight = Math.max(cellHeight, componentSize.height / r.height);
        }
        int totalWidth = cellWidth * this.gridSize.width;
        int totalHeight = cellHeight * this.gridSize.height;
        int widthMultiple = totalWidth / this.containerFormat.width;
        int heightMultiple = totalHeight / this.containerFormat.height;
        int finalMultiple = Math.max(widthMultiple, heightMultiple);
        Dimension containerSize = new Dimension(this.containerFormat.width * finalMultiple, this.containerFormat.height * finalMultiple);
        if (parent instanceof JComponent) {
            ((JComponent)parent).setPreferredSize(containerSize);
        }
        return containerSize;
    }

    public boolean adjustSize(Dimension trialSize) {
        int originalWidth = trialSize.width;
        int originalHeight = trialSize.height;
        int widthMultiple = Math.max(1, trialSize.width / this.containerFormat.width);
        int heightMultiple = Math.max(1, trialSize.height / this.containerFormat.height);
        int finalMultiple = Math.min(widthMultiple, heightMultiple);
        trialSize.width = this.containerFormat.width * finalMultiple;
        trialSize.height = this.containerFormat.height * finalMultiple;
        return originalWidth != trialSize.width || originalHeight != trialSize.height;
    }

    public boolean adjustSize(Container parent, int sizeIncrement) {
        boolean sizeChanged = false;
        if (parent instanceof JComponent) {
            JComponent jc = (JComponent)parent;
            Insets insets = jc.getInsets();
            Dimension size = jc.getSize();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            int originalMultiple = size.width / this.containerFormat.width;
            int newMultiple = Math.max(1, originalMultiple + sizeIncrement);
            if (originalMultiple != newMultiple) {
                size.width = this.containerFormat.width * newMultiple;
                size.height = this.containerFormat.height * newMultiple;
                size.width += insets.left + insets.right;
                size.height += insets.top + insets.bottom;
                sizeChanged = true;
                jc.setPreferredSize(size);
            }
        }
        if (sizeChanged) {
            SwingUtilities.invokeLater(new RunAnotherLayout(parent));
        }
        return sizeChanged;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layoutContainer(Container parent) {
        boolean needAnotherLayout = false;
        Object object = parent.getTreeLock();
        synchronized (object) {
            int n = parent.getComponentCount();
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            size.width -= insets.left + insets.right;
            size.height -= insets.top + insets.bottom;
            if (parent instanceof JComponent) {
                JComponent jc = (JComponent)parent;
                needAnotherLayout = this.adjustSize(size);
                if (needAnotherLayout) {
                    Dimension fullSize = new Dimension(size);
                    fullSize.width += insets.left + insets.right;
                    fullSize.height += insets.top + insets.bottom;
                    jc.setPreferredSize(fullSize);
                }
            }
            if (n > 0) {
                Dimension cellSize = new Dimension(size.width / this.gridSize.width, size.height / this.gridSize.height);
                for (int i = 0; i < n; ++i) {
                    Component c = parent.getComponent(i);
                    Rectangle r = this.getConstraints(c);
                    if (r == null) continue;
                    int x = insets.left + r.x * cellSize.width;
                    int y = insets.top + r.y * cellSize.height;
                    int w = r.width * cellSize.width;
                    int h = r.height * cellSize.height;
                    c.setBounds(x, y, w, h);
                }
            }
        }
        if (needAnotherLayout) {
            SwingUtilities.invokeLater(new RunAnotherLayout(parent));
        }
    }

    public Rectangle getConstrainedBounds(Container parent, Rectangle constrainedBounds, Rectangle inputBounds) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        int xPixelsPerDivision = size.width / this.gridSize.width;
        int yPixelsPerDivision = size.height / this.gridSize.height;
        int x0 = inputBounds.x - insets.left;
        int y0 = inputBounds.y - insets.top;
        int iw = Math.round((float)inputBounds.width * (float)this.gridSize.width / (float)parent.getWidth());
        int ih = Math.round((float)inputBounds.height * (float)this.gridSize.height / (float)parent.getHeight());
        iw = Math.max(1, Math.min(iw, this.gridSize.width));
        ih = Math.max(1, Math.min(ih, this.gridSize.height));
        int ix0 = Math.round((float)x0 * (float)this.gridSize.width / (float)parent.getWidth());
        int iy0 = Math.round((float)y0 * (float)this.gridSize.width / (float)parent.getHeight());
        ix0 = Math.max(0, Math.min(ix0, this.gridSize.width - iw));
        iy0 = Math.max(0, Math.min(iy0, this.gridSize.height - ih));
        x0 = xPixelsPerDivision * ix0 + insets.left;
        y0 = yPixelsPerDivision * iy0 + insets.top;
        Rectangle result = constrainedBounds;
        if (result == null) {
            result = new Rectangle();
        }
        result.width = xPixelsPerDivision * iw;
        result.height = yPixelsPerDivision * ih;
        result.x = x0;
        result.y = y0;
        return result;
    }

    public Rectangle getConstraints(Container parent, Rectangle constraints, Rectangle inputBounds) {
        Insets insets = parent.getInsets();
        Dimension size = parent.getSize();
        size.width -= insets.left + insets.right;
        size.height -= insets.top + insets.bottom;
        int x0 = inputBounds.x - insets.left;
        int y0 = inputBounds.y - insets.top;
        int iw = Math.round((float)inputBounds.width * (float)this.gridSize.width / (float)parent.getWidth());
        int ih = Math.round((float)inputBounds.height * (float)this.gridSize.height / (float)parent.getHeight());
        iw = Math.max(1, Math.min(iw, this.gridSize.width));
        ih = Math.max(1, Math.min(ih, this.gridSize.height));
        int ix0 = Math.round((float)x0 * (float)this.gridSize.width / (float)parent.getWidth());
        int iy0 = Math.round((float)y0 * (float)this.gridSize.width / (float)parent.getHeight());
        ix0 = Math.max(0, Math.min(ix0, this.gridSize.width - iw));
        iy0 = Math.max(0, Math.min(iy0, this.gridSize.height - ih));
        Rectangle result = constraints;
        if (result == null) {
            result = new Rectangle();
        }
        result.width = iw;
        result.height = ih;
        result.x = ix0;
        result.y = iy0;
        return result;
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (constraints instanceof Rectangle) {
            Rectangle r = (Rectangle)constraints;
            if (r.width <= 0 || r.height <= 0) {
                throw new IllegalArgumentException(CONSTRAINT_ERROR);
            }
            this.setConstraints(comp, r);
        } else if (constraints != null) {
            throw new IllegalArgumentException(CONSTRAINT_ERROR);
        }
    }

    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    public void invalidateLayout(Container target) {
    }

    private static Dimension getSmallestDimension(Dimension containerFormat, Dimension aspectRatio, Dimension gridSize) {
        int[] widthFactors = new int[primes.length];
        int[] widthCommonDenominator = new int[primes.length];
        int[] heightFactors = new int[primes.length];
        int[] heightCommonDenominator = new int[primes.length];
        ConstrainedGridLayout.primeFactorsOfProduct(widthFactors, aspectRatio.width, gridSize.width, gridSize.height);
        ConstrainedGridLayout.primeFactorsOfProduct(heightFactors, aspectRatio.height, gridSize.width, gridSize.height);
        ConstrainedGridLayout.leastCommonDenominator(widthCommonDenominator, aspectRatio.width, gridSize.width);
        ConstrainedGridLayout.leastCommonDenominator(heightCommonDenominator, aspectRatio.height, gridSize.height);
        ConstrainedGridLayout.removeFactors(widthFactors, widthCommonDenominator);
        ConstrainedGridLayout.removeFactors(heightFactors, heightCommonDenominator);
        ConstrainedGridLayout.removeCommonFactors(widthFactors, heightFactors);
        ConstrainedGridLayout.addFactors(widthFactors, widthCommonDenominator);
        ConstrainedGridLayout.addFactors(heightFactors, heightCommonDenominator);
        containerFormat.setSize(ConstrainedGridLayout.product(widthFactors), ConstrainedGridLayout.product(heightFactors));
        return containerFormat;
    }

    private static void primeFactorsOfProduct(int[] result, int a, int b, int c) {
        int[] factorsA = factorization[a];
        int[] factorsB = factorization[b];
        int[] factorsC = factorization[c];
        for (int i = 0; i < result.length; ++i) {
            result[i] = factorsA[i] + factorsB[i] + factorsC[i];
        }
    }

    private static void leastCommonDenominator(int[] result, int a, int b) {
        int[] factorsA = factorization[a];
        int[] factorsB = factorization[b];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Math.max(factorsA[i], factorsB[i]);
        }
    }

    private static void removeFactors(int[] a, int[] b) {
        for (int i = 0; i < Math.min(a.length, b.length); ++i) {
            int n = i;
            a[n] = a[n] - b[i];
        }
    }

    private static void addFactors(int[] a, int[] b) {
        for (int i = 0; i < Math.min(a.length, b.length); ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    private static void removeCommonFactors(int[] a, int[] b) {
        int i = 0;
        while (i < Math.min(a.length, b.length)) {
            int common = Math.min(a[i], b[i]);
            int n = i;
            a[n] = a[n] - common;
            int n2 = i++;
            b[n2] = b[n2] - common;
        }
    }

    private static int product(int[] arrays1) {
        int result = 1;
        for (int i = 0; i < arrays1.length; ++i) {
            int number = primes[i];
            for (int j = 0; j < arrays1[i]; ++j) {
                result *= number;
            }
        }
        return result;
    }

    private class RunAnotherLayout
    implements Runnable {
        Container parent;

        public RunAnotherLayout(Container parent) {
            this.parent = parent;
        }

        public void run() {
            Window window = SwingUtilities.getWindowAncestor(this.parent);
            if (window != null) {
                window.pack();
            }
        }
    }
}

