/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.ConversionException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.core.scanner.ScannerParamFilter;

public class ScannerParam
extends AbstractParam {
    private static final String ACTIVE_SCAN_BASE_KEY = "scanner";
    private static final String HOST_PER_SCAN = "scanner.hostPerScan";
    private static final String THREAD_PER_HOST = "scanner.threadPerHost";
    private static final String DELAY_IN_MS = "scanner.delayInMs";
    private static final String INJECT_PLUGIN_ID_IN_HEADER = "scanner.pluginHeader";
    private static final String HANDLE_ANTI_CSRF_TOKENS = "scanner.antiCSFR";
    private static final String PROMPT_IN_ATTACK_MODE = "scanner.attackPrompt";
    private static final String RESCAN_IN_ATTACK_MODE = "scanner.attackRescan";
    private static final String PROMPT_TO_CLEAR_FINISHED = "scanner.clearFinished";
    private static final String MAX_RESULTS_LIST = "scanner.maxResults";
    private static final String MAX_SCANS_IN_UI = "scanner.maxScansInUI";
    private static final String SHOW_ADV_DIALOG = "scanner.advDialog";
    private static final String DEFAULT_POLICY = "scanner.defaultPolicy";
    private static final String ATTACK_POLICY = "scanner.attackPolicy";
    private static final String ALLOW_ATTACK_ON_START = "scanner.attackOnStart";
    private static final String MAX_CHART_TIME_IN_MINS = "scanner.chartTimeInMins";
    private static final String EXCLUDED_PARAMS_KEY = "scanner.excludedParameters";
    private static final String EXCLUDED_PARAM_NAME = "name";
    private static final String EXCLUDED_PARAM_TYPE = "type";
    private static final String EXCLUDED_PARAM_URL = "url";
    private static final String TARGET_INJECTABLE = "scanner.injectable";
    private static final String TARGET_ENABLED_RPC = "scanner.enabledRPC";
    private static final String SCAN_HEADERS_ALL_REQUESTS = "scanner.scanHeadersAllRequests";
    public static final int TARGET_QUERYSTRING = 1;
    public static final int TARGET_POSTDATA = 2;
    public static final int TARGET_COOKIE = 4;
    public static final int TARGET_HTTPHEADERS = 8;
    public static final int TARGET_URLPATH = 16;
    public static final int RPC_MULTIPART = 1;
    public static final int RPC_XML = 2;
    public static final int RPC_JSON = 4;
    public static final int RPC_GWT = 8;
    public static final int RPC_ODATA = 16;
    public static final int RPC_DWR = 32;
    public static final int RPC_CUSTOM = 128;
    public static final int RPC_USERDEF = 256;
    public static final int TARGET_INJECTABLE_DEFAULT = 3;
    public static final int TARGET_ENABLED_RPC_DEFAULT = 63;
    private static final int DEFAULT_MAX_CHART_TIME_IN_MINS = 10;
    private int hostPerScan = 2;
    private int threadPerHost = 1;
    private int delayInMs = 0;
    private int maxResultsToList = 1000;
    private int maxScansInUI = 5;
    private boolean injectPluginIdInHeader = false;
    private boolean handleAntiCSRFTokens = false;
    private boolean promptInAttackMode = true;
    private boolean rescanInAttackMode = true;
    private boolean promptToClearFinishedScans = true;
    private boolean showAdvancedDialog = false;
    private boolean allowAttackOnStart = false;
    private String defaultPolicy;
    private String attackPolicy;
    private int maxChartTimeInMins = 10;
    private int targetParamsInjectable = 3;
    private int targetParamsEnabledRPC = 63;
    private boolean scanHeadersAllRequests;
    private final List<ScannerParamFilter> excludedParams = new ArrayList<ScannerParamFilter>();
    private final Map<Integer, List<ScannerParamFilter>> excludedParamsMap = new HashMap<Integer, List<ScannerParamFilter>>();
    private static final Logger logger = Logger.getLogger(ScannerParam.class);

    @Override
    protected void parse() {
        this.removeOldOptions();
        try {
            this.threadPerHost = this.getConfig().getInt(THREAD_PER_HOST, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.hostPerScan = this.getConfig().getInt(HOST_PER_SCAN, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.delayInMs = this.getConfig().getInt(DELAY_IN_MS, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maxResultsToList = this.getConfig().getInt(MAX_RESULTS_LIST, 1000);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maxScansInUI = this.getConfig().getInt(MAX_SCANS_IN_UI, 5);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.injectPluginIdInHeader = this.getConfig().getBoolean(INJECT_PLUGIN_ID_IN_HEADER, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.handleAntiCSRFTokens = this.getConfig().getBoolean(HANDLE_ANTI_CSRF_TOKENS, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.promptInAttackMode = this.getConfig().getBoolean(PROMPT_IN_ATTACK_MODE, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.rescanInAttackMode = this.getConfig().getBoolean(RESCAN_IN_ATTACK_MODE, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.promptToClearFinishedScans = this.getConfig().getBoolean(PROMPT_TO_CLEAR_FINISHED, true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.showAdvancedDialog = this.getConfig().getBoolean(SHOW_ADV_DIALOG, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.defaultPolicy = this.getConfig().getString(DEFAULT_POLICY, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.attackPolicy = this.getConfig().getString(ATTACK_POLICY, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.targetParamsInjectable = this.getConfig().getInt(TARGET_INJECTABLE, 3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.targetParamsEnabledRPC = this.getConfig().getInt(TARGET_ENABLED_RPC, 63);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.allowAttackOnStart = this.getConfig().getBoolean(ALLOW_ATTACK_ON_START, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.maxChartTimeInMins = this.getConfig().getInt(MAX_CHART_TIME_IN_MINS, 10);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.scanHeadersAllRequests = this.getConfig().getBoolean(SCAN_HEADERS_ALL_REQUESTS, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            List list = ((HierarchicalConfiguration)this.getConfig()).configurationsAt(EXCLUDED_PARAMS_KEY);
            this.excludedParams.clear();
            this.excludedParamsMap.clear();
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (HierarchicalConfiguration hierarchicalConfiguration : list) {
                String string = hierarchicalConfiguration.getString(EXCLUDED_PARAM_NAME, "");
                if (string.isEmpty() || arrayList.contains(string)) continue;
                arrayList.add(string);
                this.addScannerParamFilter(string, hierarchicalConfiguration.getInt(EXCLUDED_PARAM_TYPE, -1), hierarchicalConfiguration.getString(EXCLUDED_PARAM_URL));
            }
        }
        catch (ConversionException conversionException) {
            logger.error((Object)("Error while loading the exluded parameter list: " + conversionException.getMessage()), (Throwable)conversionException);
        }
        if (this.excludedParams.isEmpty()) {
            this.addScannerParamFilter("(?i)ASP.NET_SessionId", -1, "*");
            this.addScannerParamFilter("(?i)ASPSESSIONID.*", -1, "*");
            this.addScannerParamFilter("(?i)PHPSESSID", -1, "*");
            this.addScannerParamFilter("(?i)SITESERVER", -1, "*");
            this.addScannerParamFilter("(?i)sessid", -1, "*");
            this.addScannerParamFilter("__VIEWSTATE", 2, "*");
            this.addScannerParamFilter("__EVENTVALIDATION", 2, "*");
            this.addScannerParamFilter("__EVENTTARGET", 2, "*");
            this.addScannerParamFilter("__EVENTARGUMENT", 2, "*");
            this.addScannerParamFilter("(?i)jsessionid", -1, "*");
            this.addScannerParamFilter("cfid", 4, "*");
            this.addScannerParamFilter("cftoken", 4, "*");
        }
    }

    private void removeOldOptions() {
        if (this.getConfig().containsKey("scanner.deleteOnShutdown")) {
            this.getConfig().clearProperty("scanner.deleteOnShutdown");
        }
    }

    private void addScannerParamFilter(String string, int n, String string2) {
        ScannerParamFilter scannerParamFilter = new ScannerParamFilter();
        scannerParamFilter.setParamName(string);
        scannerParamFilter.setType(n);
        scannerParamFilter.setWildcardedUrl(string2);
        List<ScannerParamFilter> list = this.excludedParamsMap.get(scannerParamFilter.getType());
        if (list == null) {
            list = new ArrayList<ScannerParamFilter>();
            this.excludedParamsMap.put(scannerParamFilter.getType(), list);
        }
        this.excludedParams.add(scannerParamFilter);
        list.add(scannerParamFilter);
    }

    public List<ScannerParamFilter> getExcludedParamList() {
        return this.excludedParams;
    }

    public List<ScannerParamFilter> getExcludedParamList(int n) {
        return this.excludedParamsMap.get(n);
    }

    public void setExcludedParamList(List<ScannerParamFilter> list) {
        ((HierarchicalConfiguration)this.getConfig()).clearTree(EXCLUDED_PARAMS_KEY);
        this.excludedParams.clear();
        this.excludedParamsMap.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            String string = "scanner.excludedParameters(" + i + ").";
            ScannerParamFilter scannerParamFilter = list.get(i);
            this.getConfig().setProperty(string + EXCLUDED_PARAM_NAME, (Object)scannerParamFilter.getParamName());
            this.getConfig().setProperty(string + EXCLUDED_PARAM_TYPE, (Object)scannerParamFilter.getType());
            this.getConfig().setProperty(string + EXCLUDED_PARAM_URL, (Object)scannerParamFilter.getWildcardedUrl());
            this.addScannerParamFilter(scannerParamFilter.getParamName(), scannerParamFilter.getType(), scannerParamFilter.getWildcardedUrl());
        }
    }

    public int getThreadPerHost() {
        return this.threadPerHost;
    }

    public void setThreadPerHost(int n) {
        this.threadPerHost = n;
        this.getConfig().setProperty(THREAD_PER_HOST, (Object)Integer.toString(this.threadPerHost));
    }

    public int getHostPerScan() {
        return this.hostPerScan;
    }

    public void setHostPerScan(int n) {
        this.hostPerScan = n;
        this.getConfig().setProperty(HOST_PER_SCAN, (Object)Integer.toString(this.hostPerScan));
    }

    public int getMaxResultsToList() {
        return this.maxResultsToList;
    }

    public void setMaxResultsToList(int n) {
        this.maxResultsToList = n;
        this.getConfig().setProperty(MAX_RESULTS_LIST, (Object)Integer.toString(this.maxResultsToList));
    }

    public void setDelayInMs(int n) {
        this.delayInMs = n;
        this.getConfig().setProperty(DELAY_IN_MS, (Object)Integer.toString(this.delayInMs));
    }

    public int getDelayInMs() {
        return this.delayInMs;
    }

    public boolean isInjectPluginIdInHeader() {
        return this.injectPluginIdInHeader;
    }

    public void setInjectPluginIdInHeader(boolean bl) {
        this.injectPluginIdInHeader = bl;
        this.getConfig().setProperty(INJECT_PLUGIN_ID_IN_HEADER, (Object)bl);
    }

    public boolean getHandleAntiCSRFTokens() {
        return this.handleAntiCSRFTokens;
    }

    public void setHandleAntiCSRFTokens(boolean bl) {
        this.handleAntiCSRFTokens = bl;
        this.getConfig().setProperty(HANDLE_ANTI_CSRF_TOKENS, (Object)bl);
    }

    public boolean isRescanInAttackMode() {
        return this.rescanInAttackMode;
    }

    public void setRescanInAttackMode(boolean bl) {
        this.rescanInAttackMode = bl;
        this.getConfig().setProperty(RESCAN_IN_ATTACK_MODE, (Object)bl);
    }

    public boolean isPromptInAttackMode() {
        return this.promptInAttackMode;
    }

    public void setPromptInAttackMode(boolean bl) {
        this.promptInAttackMode = bl;
        this.getConfig().setProperty(PROMPT_IN_ATTACK_MODE, (Object)bl);
    }

    public int getTargetParamsInjectable() {
        return this.targetParamsInjectable;
    }

    public void setTargetParamsInjectable(int n) {
        this.targetParamsInjectable = n;
        this.getConfig().setProperty(TARGET_INJECTABLE, (Object)this.targetParamsInjectable);
    }

    public int getTargetParamsEnabledRPC() {
        return this.targetParamsEnabledRPC;
    }

    public void setTargetParamsEnabledRPC(int n) {
        this.targetParamsEnabledRPC = n;
        this.getConfig().setProperty(TARGET_ENABLED_RPC, (Object)this.targetParamsEnabledRPC);
    }

    public boolean isPromptToClearFinishedScans() {
        return this.promptToClearFinishedScans;
    }

    public void setPromptToClearFinishedScans(boolean bl) {
        this.promptToClearFinishedScans = bl;
        this.getConfig().setProperty(PROMPT_TO_CLEAR_FINISHED, (Object)this.promptToClearFinishedScans);
    }

    public int getMaxScansInUI() {
        return this.maxScansInUI;
    }

    public void setMaxScansInUI(int n) {
        this.maxScansInUI = n;
        this.getConfig().setProperty(MAX_SCANS_IN_UI, (Object)this.maxScansInUI);
    }

    public boolean isShowAdvancedDialog() {
        return this.showAdvancedDialog;
    }

    public void setShowAdvancedDialog(boolean bl) {
        this.showAdvancedDialog = bl;
        this.getConfig().setProperty(SHOW_ADV_DIALOG, (Object)this.showAdvancedDialog);
    }

    public String getDefaultPolicy() {
        return this.defaultPolicy;
    }

    public String getAttackPolicy() {
        return this.attackPolicy;
    }

    public void setDefaultPolicy(String string) {
        this.defaultPolicy = string;
        this.getConfig().setProperty(DEFAULT_POLICY, (Object)this.defaultPolicy);
    }

    public void setAttackPolicy(String string) {
        this.attackPolicy = string;
        this.getConfig().setProperty(ATTACK_POLICY, (Object)this.attackPolicy);
    }

    public boolean isAllowAttackOnStart() {
        return this.allowAttackOnStart;
    }

    public void setAllowAttackOnStart(boolean bl) {
        this.allowAttackOnStart = bl;
        this.getConfig().setProperty(ALLOW_ATTACK_ON_START, (Object)this.allowAttackOnStart);
    }

    public int getMaxChartTimeInMins() {
        return this.maxChartTimeInMins;
    }

    public void setMaxChartTimeInMins(int n) {
        this.maxChartTimeInMins = n;
        this.getConfig().setProperty(MAX_CHART_TIME_IN_MINS, (Object)this.maxChartTimeInMins);
    }

    public boolean isScanHeadersAllRequests() {
        return this.scanHeadersAllRequests;
    }

    public void setScanHeadersAllRequests(boolean bl) {
        if (bl == this.scanHeadersAllRequests) {
            return;
        }
        this.scanHeadersAllRequests = bl;
        this.getConfig().setProperty(SCAN_HEADERS_ALL_REQUESTS, (Object)this.scanHeadersAllRequests);
    }
}

