/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.NameValuePair;
import org.parosproxy.paros.network.HttpMessage;

public class ScannerParamFilter
implements Cloneable {
    private String wildcardedUrl;
    private String paramNameRegex;
    private int paramType;
    private Pattern paramNamePattern;
    private Pattern urlPattern;
    private static final Map<Integer, String> typeMap = new HashMap<Integer, String>();

    public ScannerParamFilter() {
        this.wildcardedUrl = "*";
        this.paramType = -1;
        this.paramNamePattern = null;
        this.urlPattern = null;
    }

    public ScannerParamFilter(String string, int n, String string2) {
        this.paramType = n;
        this.setParamName(string);
        this.setWildcardedUrl(string2);
    }

    public int getType() {
        return this.paramType;
    }

    public void setType(int n) {
        this.paramType = n;
    }

    public String getParamName() {
        return this.paramNameRegex;
    }

    public final void setParamName(String string) {
        this.paramNameRegex = string;
        this.paramNamePattern = Pattern.compile(string);
    }

    public static boolean isValidParamNameRegex(String string) {
        try {
            Pattern.compile(string);
            return true;
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return false;
        }
    }

    public String getWildcardedUrl() {
        return this.wildcardedUrl;
    }

    public final void setWildcardedUrl(String string) {
        this.wildcardedUrl = string;
        if (string == null || string.equals("*")) {
            this.urlPattern = null;
        } else {
            String string2 = string.toUpperCase(Locale.ROOT);
            string2 = Pattern.quote(string2);
            string2 = string2.replaceAll("\\?", "\\\\E.\\\\Q");
            string2 = string2.replaceAll("\\*", "\\\\E.*\\\\Q");
            string2 = string2.replaceAll("\\\\Q\\\\E", "");
            this.urlPattern = Pattern.compile(string2);
        }
    }

    public boolean isToExclude(HttpMessage httpMessage, NameValuePair nameValuePair) {
        return !(this.paramType != -1 && nameValuePair.getType() != this.paramType || this.urlPattern != null && !this.urlPattern.matcher(httpMessage.getRequestHeader().getURI().toString().toUpperCase(Locale.ROOT)).matches() || !this.paramNamePattern.matcher(nameValuePair.getName()).matches());
    }

    public ScannerParamFilter clone() {
        return new ScannerParamFilter(this.paramNameRegex, this.paramType, this.wildcardedUrl);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.paramNameRegex == null ? 0 : this.paramNameRegex.hashCode());
        n = 31 * n + this.paramType;
        n = 31 * n + (this.wildcardedUrl == null ? 0 : this.wildcardedUrl.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof ScannerParamFilter) {
            ScannerParamFilter scannerParamFilter = (ScannerParamFilter)object;
            return scannerParamFilter.getType() == this.getType() && scannerParamFilter.getWildcardedUrl().equals(this.getWildcardedUrl()) && scannerParamFilter.getParamName().equals(this.getParamName());
        }
        return false;
    }

    public String getTypeString() {
        return typeMap.get(this.paramType);
    }

    public void setType(String string) {
        int n = -1;
        for (Map.Entry<Integer, String> entry : typeMap.entrySet()) {
            if (!entry.getValue().equalsIgnoreCase(string)) continue;
            n = entry.getKey();
            break;
        }
        this.setType(n);
    }

    public static final Collection<String> getListTypes() {
        return typeMap.values();
    }

    public static final String getStringType(int n) {
        return typeMap.get(n);
    }

    static {
        typeMap.put(-1, Constant.messages.getString("variant.param.type.all"));
        typeMap.put(1, Constant.messages.getString("variant.param.type.query"));
        typeMap.put(2, Constant.messages.getString("variant.param.type.postdata"));
        typeMap.put(16, Constant.messages.getString("variant.param.type.path"));
        typeMap.put(8, Constant.messages.getString("variant.param.type.header"));
        typeMap.put(4, Constant.messages.getString("variant.param.type.cookie"));
    }
}

