/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import dguitar.gui.Bar;
import dguitar.gui.BarPanel;
import dguitar.gui.MusicCursorPosition;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class MusicCursor
extends JLabel {
    private MusicCursorPosition musicCursorPosition;
    private Color colorBorder;
    private JComponent component;
    private int leftOffset = 8;
    private int rightOffset = 10;

    public MusicCursor(BarPanel BP) {
        this.commonConstructor(BP);
    }

    public MusicCursor(Bar b) {
        this.commonConstructor(b);
    }

    private void commonConstructor(JComponent aComponent) {
        if (aComponent == null) {
            throw new NullPointerException("the parameter for MusicCursor(JLayeredPane) is null!");
        }
        this.component = aComponent;
        this.musicCursorPosition = new MusicCursorPosition();
        this.musicCursorPosition.setWidth(this.leftOffset + this.rightOffset);
        this.colorBorder = Color.RED;
        this.setBorder(BorderFactory.createLineBorder(this.colorBorder));
        this.setOpaque(false);
    }

    public Dimension getMinimumSize() {
        int h = this.component.getHeight() - 2;
        return new Dimension(this.musicCursorPosition.getWidth(), h);
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public String toString() {
        String resp = "MusicCursor" + this.musicCursorPosition;
        return resp;
    }

    private void pointUpdated() {
        int h = this.component.getHeight() - 2;
        Point p = this.musicCursorPosition.getPoint();
        int w = this.musicCursorPosition.getWidth();
        this.setBounds(p.x - this.leftOffset, p.y, w, h);
    }

    public void setMusicCursorPosition(MusicCursorPosition musicCursorPosition) {
        this.musicCursorPosition = musicCursorPosition;
        this.pointUpdated();
    }

    public MusicCursorPosition getMusicCursorPosition() {
        return this.musicCursorPosition;
    }

    public void setLeftOffset(int halfWidth) {
        this.leftOffset = halfWidth;
    }

    public int getLeftOffset() {
        return this.leftOffset;
    }

    public void setRightOffset(int rightOffset) {
        this.rightOffset = rightOffset;
    }

    public void setWidth(int value) {
        this.musicCursorPosition.setWidth(value);
        this.rightOffset = value - this.leftOffset;
        this.pointUpdated();
    }

    public int getRightOffset() {
        return this.rightOffset;
    }

    public void setColorBorder(Color aColorBorder) {
        if (aColorBorder != null) {
            this.colorBorder = aColorBorder;
            this.setBorder(BorderFactory.createLineBorder(this.colorBorder));
        }
    }

    public Color getColorBorder() {
        return this.colorBorder;
    }
}

