/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.TermsQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryShardContext;

abstract class TermBasedFieldType
extends MappedFieldType {
    TermBasedFieldType() {
    }

    protected TermBasedFieldType(MappedFieldType ref) {
        super(ref);
    }

    protected BytesRef indexedValueForSearch(Object value) {
        return BytesRefs.toBytesRef(value);
    }

    @Override
    public Query termQuery(Object value, QueryShardContext context) {
        this.failIfNotIndexed();
        TermQuery query = new TermQuery(new Term(this.name(), this.indexedValueForSearch(value)));
        if (this.boost() == 1.0f || context != null && context.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
            return query;
        }
        return new BoostQuery((Query)query, this.boost());
    }

    @Override
    public Query termsQuery(List<?> values, QueryShardContext context) {
        this.failIfNotIndexed();
        BytesRef[] bytesRefs = new BytesRef[values.size()];
        for (int i = 0; i < bytesRefs.length; ++i) {
            bytesRefs[i] = this.indexedValueForSearch(values.get(i));
        }
        return new TermsQuery(this.name(), bytesRefs);
    }
}

