define(["dialogHelper","imageLoader","emby-checkbox","emby-button","paper-icon-button-light","css!css/metadataeditor.css"],function(dialogHelper,imageLoader){"use strict";function getBaseRemoteOptions(){var options={};return options.itemId=currentItemId,options}function reloadBrowsableImages(page){Dashboard.showLoadingMsg();var options=getBaseRemoteOptions();options.type=browsableImageType,options.startIndex=browsableImageStartIndex,options.limit=browsableImagePageSize,options.IncludeAllLanguages=page.querySelector("#chkAllLanguages").checked;var provider=selectedProvider||"";provider&&(options.ProviderName=provider),ApiClient.getAvailableRemoteImages(options).then(function(result){renderRemoteImages(page,result,browsableImageType,options.startIndex,options.limit),page.querySelector("#selectBrowsableImageType").value=browsableImageType;var providersHtml=result.Providers.map(function(p){return'<option value="'+p+'">'+p+"</option>"}),selectImageProvider=page.querySelector("#selectImageProvider");selectImageProvider.innerHTML='<option value="">'+Globalize.translate("LabelAll")+"</option>"+providersHtml,selectImageProvider.value=provider,Dashboard.hideLoadingMsg()})}function renderRemoteImages(page,imagesResult,imageType,startIndex,limit){page.querySelector(".availableImagesPaging").innerHTML=getPagingHtml(startIndex,limit,imagesResult.TotalRecordCount);for(var html="",i=0,length=imagesResult.Images.length;i<length;i++)html+=getRemoteImageHtml(imagesResult.Images[i],imageType);var availableImagesList=page.querySelector(".availableImagesList");availableImagesList.innerHTML=html,imageLoader.lazyChildren(availableImagesList);var btnNextPage=page.querySelector(".btnNextPage"),btnPreviousPage=page.querySelector(".btnPreviousPage");btnNextPage&&btnNextPage.addEventListener("click",function(){browsableImageStartIndex+=browsableImagePageSize,reloadBrowsableImages(page)}),btnPreviousPage&&btnPreviousPage.addEventListener("click",function(){browsableImageStartIndex-=browsableImagePageSize,reloadBrowsableImages(page)})}function getPagingHtml(startIndex,limit,totalRecordCount){var html="",recordsEnd=Math.min(startIndex+limit,totalRecordCount),showControls=totalRecordCount>limit;html+='<div class="listPaging">',html+='<span style="margin-right: 10px;">';var startAtDisplay=totalRecordCount?startIndex+1:0;return html+=startAtDisplay+"-"+recordsEnd+" of "+totalRecordCount,html+="</span>",showControls&&(html+='<div data-role="controlgroup" data-type="horizontal" style="display:inline-block;">',html+='<button is="paper-icon-button-light" title="'+Globalize.translate("ButtonPreviousPage")+'" class="btnPreviousPage autoSize" '+(startIndex?"":"disabled")+'><i class="md-icon">&#xE5C4;</i></button>',html+='<button is="paper-icon-button-light" title="'+Globalize.translate("ButtonNextPage")+'" class="btnNextPage autoSize" '+(startIndex+limit>=totalRecordCount?"disabled":"")+'><i class="md-icon">arrow_forward</i></button>',html+="</div>"),html+="</div>"}function parentWithClass(elem,className){for(;!elem.classList||!elem.classList.contains(className);)if(elem=elem.parentNode,!elem)return null;return elem}function downloadRemoteImage(page,url,type,provider){var options=getBaseRemoteOptions();options.Type=type,options.ImageUrl=url,options.ProviderName=provider,Dashboard.showLoadingMsg(),ApiClient.downloadRemoteImage(options).then(function(){hasChanges=!0;var dlg=parentWithClass(page,"dialog");dialogHelper.close(dlg)})}function getDisplayUrl(url){return ApiClient.getUrl("Images/Remote",{imageUrl:url})}function getRemoteImageHtml(image,imageType){var html="";html+='<div class="remoteImageContainer">';var cssClass="remoteImage lazy";cssClass+="Backdrop"==imageType||"Art"==imageType||"Thumb"==imageType||"Logo"==imageType?" remoteBackdropImage":"Banner"==imageType?" remoteBannerImage":"Disc"==imageType?" remoteDiscImage":"Episode"==currentItemType?" remoteBackdropImage":"MusicAlbum"==currentItemType||"MusicArtist"==currentItemType?" remoteDiscImage":" remotePosterImage";var displayUrl=getDisplayUrl(image.ThumbnailUrl||image.Url);return html+='<a target="_blank" href="'+getDisplayUrl(image.Url)+'" class="'+cssClass+'" data-src="'+displayUrl+'">',html+="</a>",html+='<div class="remoteImageDetails">',html+='<div class="remoteImageDetailText">',html+=image.ProviderName,html+="</div>",(image.Width||image.Height||image.Language)&&(html+='<div class="remoteImageDetailText">',image.Width&&image.Height?(html+=image.Width+" x "+image.Height,image.Language&&(html+=" • "+image.Language)):image.Language&&(html+=image.Language),html+="</div>"),null!=image.CommunityRating&&(html+='<div class="remoteImageDetailText">',"Likes"==image.RatingType?html+=image.CommunityRating+(1==image.CommunityRating?" like":" likes"):image.CommunityRating?(html+=image.CommunityRating.toFixed(1),image.VoteCount&&(html+=" • "+image.VoteCount+(1==image.VoteCount?" vote":" votes"))):html+="Unrated",html+="</div>"),html+='<button is="paper-icon-button-light" class="btnDownloadRemoteImage autoSize" raised data-imageprovider="'+image.ProviderName+'" data-imageurl="'+image.Url+'" data-imagetype="'+image.Type+'" title="'+Globalize.translate("ButtonDownload")+'"><i class="md-icon">cloud_download</i></button>',html+="</div>",html+="</div>"}function initEditor(page){page.querySelector("#selectBrowsableImageType").addEventListener("change",function(){browsableImageType=this.value,browsableImageStartIndex=0,selectedProvider=null,reloadBrowsableImages(page)}),page.querySelector("#selectImageProvider").addEventListener("change",function(){browsableImageStartIndex=0,selectedProvider=this.value,reloadBrowsableImages(page)}),page.querySelector("#chkAllLanguages").addEventListener("change",function(){browsableImageStartIndex=0,reloadBrowsableImages(page)}),page.addEventListener("click",function(e){var btnDownloadRemoteImage=parentWithClass(e.target,"btnDownloadRemoteImage");btnDownloadRemoteImage&&downloadRemoteImage(page,btnDownloadRemoteImage.getAttribute("data-imageurl"),btnDownloadRemoteImage.getAttribute("data-imagetype"),btnDownloadRemoteImage.getAttribute("data-imageprovider"))})}function showEditor(itemId,itemType){Dashboard.showLoadingMsg();var xhr=new XMLHttpRequest;xhr.open("GET","components/imagedownloader/imagedownloader.template.html",!0),xhr.onload=function(e){var template=this.response;currentItemId=itemId,currentItemType=itemType;var dlg=dialogHelper.createDialog({size:"fullscreen-border",lockScroll:!0,removeOnClose:!0}),theme="b";dlg.classList.add("ui-body-"+theme),dlg.classList.add("background-theme-"+theme);var html="";html+='<h2 class="dialogHeader">',html+='<button type="button" is="emby-button" icon="arrow-back" class="fab mini btnCloseDialog autoSize" tabindex="-1"><i class="md-icon">&#xE5C4;</i></button>',html+='<div style="display:inline-block;margin-left:.6em;vertical-align:middle;">'+Globalize.translate("HeaderSearch")+"</div>",html+="</h2>",html+='<div class="editorContent">',html+=Globalize.translateDocument(template),html+="</div>",dlg.innerHTML=html,dlg.addEventListener("close",onDialogClosed),dialogHelper.open(dlg);var editorContent=dlg.querySelector(".editorContent");initEditor(editorContent),dlg.querySelector(".btnCloseDialog").addEventListener("click",function(){dialogHelper.close(dlg)}),reloadBrowsableImages(editorContent)},xhr.send()}function onDialogClosed(){Dashboard.hideLoadingMsg(),hasChanges?currentResolve():currentReject()}var currentItemId,currentItemType,currentResolve,currentReject,selectedProvider,hasChanges=!1,browsableImagePageSize=browserInfo.slow?6:30,browsableImageStartIndex=0,browsableImageType="Primary";return{show:function(itemId,itemType,imageType){return new Promise(function(resolve,reject){currentResolve=resolve,currentReject=reject,hasChanges=!1,browsableImageStartIndex=0,browsableImageType=imageType||"Primary",selectedProvider=null,showEditor(itemId,itemType)})}}});