/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.collections.SimpleFileCollection;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.internal.tasks.compile.CompilationFailedException;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompilerArgumentsBuilder;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.FileUtils;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.util.CollectionUtils;

public class NormalizingGroovyCompiler
implements Compiler<GroovyJavaJointCompileSpec> {
    private static final Logger LOGGER = Logging.getLogger(NormalizingGroovyCompiler.class);
    private final Compiler<GroovyJavaJointCompileSpec> delegate;

    public NormalizingGroovyCompiler(Compiler<GroovyJavaJointCompileSpec> delegate) {
        this.delegate = delegate;
    }

    public WorkResult execute(GroovyJavaJointCompileSpec spec) {
        this.resolveAndFilterSourceFiles(spec);
        this.resolveClasspath(spec);
        this.resolveNonStringsInCompilerArgs(spec);
        this.logSourceFiles(spec);
        this.logCompilerArguments(spec);
        return this.delegateAndHandleErrors(spec);
    }

    private void resolveAndFilterSourceFiles(GroovyJavaJointCompileSpec spec) {
        final List fileExtensions = CollectionUtils.collect(spec.getGroovyCompileOptions().getFileExtensions(), (Transformer)new Transformer<String, String>(){

            public String transform(String extension) {
                return '.' + extension;
            }
        });
        FileCollection filtered = spec.getSource().filter((Spec)new Spec<File>(){

            public boolean isSatisfiedBy(File element) {
                for (String fileExtension : fileExtensions) {
                    if (!FileUtils.hasExtension((File)element, (String)fileExtension)) continue;
                    return true;
                }
                return false;
            }
        });
        spec.setSource((FileCollection)new SimpleFileCollection((Collection)filtered.getFiles()));
    }

    private void resolveClasspath(GroovyJavaJointCompileSpec spec) {
        ArrayList classPath = Lists.newArrayList((Iterable)spec.getCompileClasspath());
        classPath.add(spec.getDestinationDir());
        spec.setCompileClasspath(classPath);
    }

    private void resolveNonStringsInCompilerArgs(GroovyJavaJointCompileSpec spec) {
        spec.getCompileOptions().setCompilerArgs(CollectionUtils.toStringList((Iterable)spec.getCompileOptions().getCompilerArgs()));
    }

    private void logSourceFiles(GroovyJavaJointCompileSpec spec) {
        if (!spec.getGroovyCompileOptions().isListFiles()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Source files to be compiled:");
        for (File file : spec.getSource()) {
            builder.append('\n');
            builder.append(file);
        }
        LOGGER.quiet(builder.toString());
    }

    private void logCompilerArguments(GroovyJavaJointCompileSpec spec) {
        if (!LOGGER.isDebugEnabled()) {
            return;
        }
        List compilerArgs = new JavaCompilerArgumentsBuilder((JavaCompileSpec)spec).includeLauncherOptions(true).includeSourceFiles(true).build();
        String joinedArgs = Joiner.on((char)' ').join((Iterable)compilerArgs);
        LOGGER.debug("Java compiler arguments: {}", (Object)joinedArgs);
    }

    private WorkResult delegateAndHandleErrors(GroovyJavaJointCompileSpec spec) {
        try {
            return this.delegate.execute((CompileSpec)spec);
        }
        catch (CompilationFailedException e) {
            if (spec.getCompileOptions().isFailOnError()) {
                throw e;
            }
            LOGGER.debug("Ignoring compilation failure.");
            return new SimpleWorkResult(false);
        }
    }
}

