/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.nbo.NBODialogConfig;
import org.openscience.jmol.app.nbo.NBODialogSearch;
import org.openscience.jmol.app.nbo.NBOFileHandler;
import org.openscience.jmol.app.nbo.NBOService;

public class NBODialog
extends NBODialogSearch {
    protected JLabel licenseInfo;
    private JButton helpBtn;
    private JDialog settingsDialog;
    private JPanel topPanel;
    protected JButton modelButton;
    protected JButton runButton;
    protected JButton viewButton;
    protected JButton searchButton;
    protected JPanel settingsPanel;
    private JPanel homePanel;
    boolean isJmolNBO;
    private boolean haveService;
    protected JLabel statusLab;
    protected JPanel nboOutput;
    static final char DIALOG_CONFIG = 'c';
    static final char DIALOG_MODEL = 'm';
    static final char DIALOG_RUN = 'r';
    static final char DIALOG_VIEW = 'v';
    static final char DIALOG_SEARCH = 's';
    static final char DIALOG_HOME = 'h';

    public NBODialog(JFrame f, Viewer vwr, NBOService nboService) {
        super(f);
        this.setTitle("NBOPro6@Jmol");
        ImageIcon img = null;
        String imageName = "org/openscience/jmol/app/images/nbo6logo.gif";
        URL imageUrl = this.getClass().getClassLoader().getResource(imageName);
        if (imageUrl != null) {
            img = new ImageIcon(imageUrl);
        }
        this.setIconImage(img.getImage());
        this.vwr = vwr;
        this.nboService = nboService;
        this.setLayout(new BorderLayout());
        this.sendDefaultScript();
        nboService.nboDialog = this;
        this.createDialog(f.getBounds());
    }

    protected Component getComponentatPoint(Point p, Component top) {
        Component c = null;
        if (top.isShowing()) {
            while (!((c = ((Container)top).findComponentAt(p)) instanceof Container)) {
            }
        }
        return c;
    }

    private void createDialog(Rectangle bounds) {
        this.dialogMode = (char)104;
        this.setBounds(bounds.x + bounds.width - 75, bounds.y, 615, Math.max(bounds.height, 660));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NBODialog.this.close();
            }
        });
        this.placeNBODialog(this);
        this.helpBtn = new NBODialogConfig.HelpBtn(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                String url = "http://nbo6.chem.wisc.edu/jmol_help/";
                switch (NBODialog.this.dialogMode) {
                    case 'm': {
                        url = url + "model_help.htm";
                        break;
                    }
                    case 'r': {
                        url = url + "run_help.htm";
                        break;
                    }
                    case 'v': {
                        url = url + "view_help.htm";
                        break;
                    }
                    case 's': {
                        url = url + "search_help.htm";
                        break;
                    }
                    default: {
                        url = url + "Jmol_NBOPro6_help.htm";
                    }
                }
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e1) {
                    NBODialog.this.alertError("Could not open help pages");
                }
            }
        };
        this.licenseInfo = new JLabel("Licence not found", 0);
        this.licenseInfo.setOpaque(true);
        this.licenseInfo.setForeground(Color.white);
        this.licenseInfo.setBackground(Color.black);
        this.nboOutput();
        this.centerPanel = new JSplitPane(1, new JPanel(), this.nboOutput);
        this.topPanel = this.buildTopPanel();
        this.homePanel = this.mainPage();
        this.getContentPane().add((Component)this.homePanel, "Center");
        this.getContentPane().add((Component)this.licenseInfo, "South");
        this.dialogMode = (char)104;
        this.getContentPane().add((Component)this.topPanel, "North");
        this.settingsPanel = this.buildSettingsPanel();
        this.settingsDialog = new JDialog((Dialog)this, "Settings");
        this.settingsDialog.add(this.settingsPanel);
        this.settingsDialog.setSize(new Dimension(350, 400));
        this.settingsDialog.setLocation(this.getX() + 100, this.getY() + 100);
        this.setVisible(true);
    }

    private void placeNBODialog(JDialog d) {
        Dimension screenSize = d.getToolkit().getScreenSize();
        Dimension size = d.getSize();
        int y = d.getParent().getY();
        int x = Math.min(screenSize.width - size.width, d.getParent().getX() + d.getParent().getWidth());
        System.out.println("------" + x + "   " + y);
        d.setLocation(x, y);
    }

    private JButton getMainButton(JButton b, final char mode, Font font) {
        b.setBorder(null);
        b.setMargin(new Insets(5, 5, 5, 5));
        b.setContentAreaFilled(false);
        b.setForeground(Color.white);
        b.setFont(font);
        if (mode != 'h') {
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBODialog.this.openPanel(mode);
                }
            });
        }
        return b;
    }

    protected JPanel buildTopPanel() {
        JPanel p = new JPanel(new BorderLayout());
        Font f = new Font("Arial", 1, 20);
        Box b = Box.createHorizontalBox();
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        this.modelButton = new JButton("Model");
        b.add(this.getMainButton(this.modelButton, 'm', f));
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        this.runButton = new JButton("Run");
        b.add(this.getMainButton(this.runButton, 'r', f));
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        this.viewButton = new JButton("View");
        b.add(this.getMainButton(this.viewButton, 'v', f));
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        this.searchButton = new JButton("Search");
        b.add(this.getMainButton(this.searchButton, 's', f));
        b.add(Box.createRigidArea(new Dimension(30, 50)));
        b.add(this.getMainButton(new JButton("Settings"), 'c', new Font("Arial", 0, 14)));
        b.add(Box.createRigidArea(new Dimension(20, 0)));
        b.add(this.getMainButton(this.helpBtn, 'h', new Font("Arial", 0, 14)));
        p.add((Component)b, "Center");
        this.icon = new JLabel();
        this.icon.setFont(new Font("Arial", 1, 16));
        this.icon.setForeground(Color.white);
        p.add((Component)this.icon, "East");
        p.setBackground(Color.BLACK);
        p.setPreferredSize(new Dimension(500, 60));
        return p;
    }

    protected void setComponents(Component comp, Color foregroundColor, Color backgroundColor) {
        if (comp instanceof JTextField || comp instanceof JTextPane || comp instanceof JButton) {
            return;
        }
        if (comp instanceof JComboBox) {
            comp.setBackground(new Color(248, 248, 248));
        }
        if (foregroundColor != null) {
            comp.setForeground(foregroundColor);
        }
        if (backgroundColor != null) {
            comp.setBackground(backgroundColor);
        }
        if (comp instanceof Container) {
            for (Component c : ((Container)comp).getComponents()) {
                this.setComponents(c, foregroundColor, backgroundColor);
            }
        }
    }

    private JPanel mainPage() {
        JPanel p = new JPanel();
        p.setBackground(Color.white);
        this.haveService = this.nboService.restartIfNecessary();
        p.setLayout(new BoxLayout(p, 1));
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("nbo6logo.gif"));
        Image image = imageIcon.getImage();
        Image newimg = image.getScaledInstance(20, 20, 4);
        imageIcon = new ImageIcon(newimg);
        JLabel lab = new JLabel(imageIcon);
        Box b = Box.createHorizontalBox();
        b.add(lab);
        lab = new JLabel("NBOServe (v6) toolbox");
        b.add(lab);
        b.add(Box.createRigidArea(new Dimension(370, 0)));
        this.icon.setOpaque(true);
        this.icon.setBackground(Color.LIGHT_GRAY);
        this.icon.setText(this.haveService ? "  Connected  " : " Not Connected  ");
        this.icon.setForeground(this.haveService ? Color.black : Color.red);
        this.icon.setBorder(BorderFactory.createLineBorder(Color.black));
        p.add(b);
        lab = new JLabel("NBOPro6@Jmol");
        lab.setFont(new Font("Arial", 1, 26));
        lab.setForeground(Color.red);
        p.add(lab);
        lab.setAlignmentX(0.5f);
        lab = new JLabel("Frank Weinhold, Dylan Phillips, and Bob Hanson");
        lab.setAlignmentX(0.5f);
        p.add(lab);
        JPanel p2 = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        p2.setBorder(BorderFactory.createLineBorder(Color.black));
        Font f = new Font("Arial", 3, 16);
        Font f2 = new Font("Arial", 3, 22);
        JButton btn = new JButton("Model");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.setFont(f2);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.openPanel('m');
            }
        });
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 3;
        lab = new JLabel("  Create & edit molecular model and input files");
        p2.add((Component)lab, c);
        c.gridx = 5;
        c.gridwidth = 1;
        p2.add(Box.createRigidArea(new Dimension(60, 10)), c);
        lab.setFont(f);
        JTextPane tp = new JTextPane();
        tp.setContentType("text/html");
        tp.setText("<HTML><center>Frank Weinhold<br><I>(Acknowledgments: Eric Glendening, John Carpenter, Mark Muyskens, Isaac Mades, Scott Ostrander, John Blair, Craig Weinhold)</I></center></HTML>");
        tp.setEditable(false);
        tp.setBackground(null);
        tp.setPreferredSize(new Dimension(430, 60));
        c.gridx = 1;
        c.gridy = 1;
        c.gridwidth = 3;
        c.fill = 2;
        p2.add((Component)tp, c);
        c.weightx = 0.0;
        btn = new JButton("Run");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.openPanel('r');
            }
        });
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        btn.setFont(f2);
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 2;
        c.gridwidth = 3;
        lab = new JLabel("  Launch NBO analysis for chosen archive file");
        p2.add((Component)lab, c);
        lab.setFont(f);
        tp = new JTextPane();
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Eric Glendening, Jay Badenhoop, Alan Reed, John Carpenter, Jon Bohmann, Christine Morales, and Frank Weinhold</center></HTML>");
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        btn = new JButton("View");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.openPanel('v');
            }
        });
        btn.setFont(f2);
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 3;
        lab = new JLabel("  Display NBO orbitals in 1D/2D/3D imagery");
        p2.add((Component)lab, c);
        lab.setFont(f);
        tp = new JTextPane();
        tp.setMaximumSize(new Dimension(430, 60));
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Mark Wendt and Frank Weinhold<br><I> (Acknowledgments: Eric Glendening, John Carpenter, Mark Muyskens, Scott Ostrander, Zdenek Havlas, Dave Anderson)</I></center></HTML>");
        c.gridx = 1;
        c.gridy = 5;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        btn = new JButton("Search");
        btn.setForeground(Color.WHITE);
        btn.setBackground(Color.BLUE);
        btn.setMinimumSize(new Dimension(150, 30));
        btn.setFont(f2);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.openPanel('s');
            }
        });
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 1;
        p2.add((Component)btn, c);
        c.gridx = 1;
        c.gridy = 6;
        c.gridwidth = 3;
        lab = new JLabel("  Search NBO output interactively");
        p2.add((Component)lab, c);
        lab.setFont(f);
        tp = new JTextPane();
        tp.setMaximumSize(new Dimension(430, 60));
        tp.setContentType("text/html");
        tp.setBackground(null);
        tp.setText("<HTML><center>Frank Weinhold</center></HTML>");
        c.gridx = 1;
        c.gridy = 7;
        c.gridwidth = 3;
        p2.add((Component)tp, c);
        p.add(p2);
        b = Box.createHorizontalBox();
        btn = new JButton("NBOPro6 Manual");
        b.add(btn);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        String url = "http://nbo6.chem.wisc.edu/jmol_help/NBOPro6_man.pdf";
                        Desktop.getDesktop().browse(new URI(url));
                    }
                    catch (IOException ex) {
                        NBODialog.this.alertError("Could open NBOPro6 manual");
                    }
                    catch (URISyntaxException e) {
                        NBODialog.this.alertError("Could open NBOPro6 manual");
                    }
                }
            }
        });
        btn.setFont(f);
        p.add(b);
        JTextPane t = new JTextPane();
        t.setContentType("text/html");
        t.setText("<HTML><Font color=\"RED\"><center>\u00a9Copyright 2016 Board of Regents of the University of Wisconsin System on behalf of \nthe Theoretical Chemistry Institute.  All Rights Reserved</center></font></HTML>");
        t.setForeground(Color.RED);
        t.setBackground(null);
        t.setAlignmentX(0.5f);
        t.setMaximumSize(new Dimension(10000, 80));
        p.add(t);
        this.centerPanel.setDividerLocation(355);
        return p;
    }

    protected void nboOutput() {
        this.nboOutput = new JPanel(new BorderLayout());
        this.settingsBox = new JPanel(new BorderLayout());
        this.settingsBox.add((Component)new JLabel("Settings"), "North");
        JPanel s = new JPanel(new BorderLayout());
        s.add((Component)this.settingsBox, "North");
        this.settingsBox.setVisible(true);
        this.nboOutput.add((Component)this.settingsBox, "North");
        this.nboOutput.add((Component)s, "Center");
        JLabel lab = new JLabel("Session Log");
        lab.setFont(nboFont);
        s.add((Component)lab, "First");
        JScrollPane p1 = new JScrollPane();
        if (this.jpNBOLog == null) {
            this.jpNBOLog = new JTextPane();
            this.jpNBOLog.setEditable(false);
            this.jpNBOLog.setBorder(null);
            this.jpNBOLog.setFont(new Font("Arial", 0, 16));
            this.bodyText = "";
        }
        this.jpNBOLog.setContentType("text/html");
        this.jpNBOLog.setFont(new Font("Arial", 0, 10));
        this.setComponents(s, Color.WHITE, Color.BLACK);
        p1.getViewport().add(this.jpNBOLog);
        p1.setBorder(null);
        s.add((Component)p1, "Center");
        JPanel box = new JPanel(new GridLayout(2, 1));
        this.statusLab = new JLabel();
        this.statusLab.setForeground(Color.red);
        this.statusLab.setBackground(Color.white);
        this.statusLab.setFont(new Font("Arial", 1, 14));
        this.statusLab.setOpaque(true);
        box.add(this.statusLab);
        Box box2 = Box.createHorizontalBox();
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBODialog.this.clearOutput();
            }
        });
        box2.add(clear);
        JButton btn = new JButton("Save Output");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser myChooser = new JFileChooser();
                myChooser.setFileFilter(new FileNameExtensionFilter(".txt", ".txt"));
                myChooser.setFileHidingEnabled(true);
                int button = myChooser.showSaveDialog(NBODialog.this.jpNBOLog);
                if (button == 0) {
                    String output = NBODialog.this.bodyText.replaceAll("<br>", NBODialogConfig.sep);
                    output = output.replaceAll("<b>", "");
                    output = output.replaceAll("</b>", "");
                    output = output.replaceAll("<i>", "");
                    output = output.replaceAll("</i>", "");
                    NBODialog.this.inputFileHandler.writeToFile(myChooser.getSelectedFile().toString(), output);
                }
            }
        });
        box2.add(btn);
        box.add(box2);
        s.add((Component)box, "South");
    }

    public void close() {
        if (this.modulePanel != null) {
            this.inputFileHandler.clearInputFile();
        }
        this.runScriptNow("mo delete; nbo delete; select off");
        this.dispose();
    }

    protected void openPanel(char type) {
        int i;
        if (type == 'c') {
            if (this.settingsDialog.isVisible()) {
                return;
            }
            this.settingsDialog.setVisible(true);
            return;
        }
        if (this.nboService.isWorking && (i = JOptionPane.showConfirmDialog(this, "NBOServe is working. Cancel current job?\nThis could affect input/output files\nif GenNBO is running.", "Message", 0)) == 1) {
            return;
        }
        this.nboService.restart();
        if (this.dialogMode == 'h') {
            this.remove(this.homePanel);
            this.add((Component)this.centerPanel, "Center");
            if (type != 'c') {
                this.dialogMode = type;
            }
        }
        switch (this.dialogMode) {
            case 's': 
            case 'v': {
                this.runScriptNow("mo delete; nbo delete; select off");
            }
        }
        this.nboService.jobQueue.clear();
        this.nboService.isWorking = false;
        this.settingsBox.setVisible(false);
        if (!this.checkEnabled()) {
            type = (char)99;
        }
        if (this.topPanel != null) {
            this.topPanel.remove(this.icon);
        }
        switch (type) {
            case 'm': {
                this.dialogMode = (char)109;
                this.modulePanel = this.buildModelPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nbomodel_logo.gif")));
                this.setThis(this.modelButton);
                break;
            }
            case 'r': {
                this.dialogMode = (char)114;
                this.modulePanel = this.buildRunPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nborun_logo.gif")));
                this.setThis(this.runButton);
                break;
            }
            case 'v': {
                this.dialogMode = (char)118;
                this.modulePanel = this.buildViewPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nboview_logo.gif")));
                this.setThis(this.viewButton);
                break;
            }
            case 's': {
                this.dialogMode = (char)115;
                this.modulePanel = this.buildSearchPanel();
                this.centerPanel.setLeftComponent(this.modulePanel);
                this.icon = new JLabel(new ImageIcon(this.getClass().getResource("nbosearch_logo.gif")));
                this.setThis(this.searchButton);
            }
        }
        this.centerPanel.setDividerLocation(350);
        if (this.topPanel != null) {
            this.topPanel.add((Component)this.icon, "East");
        }
        this.statusLab.setText("");
        this.invalidate();
        this.setVisible(true);
    }

    protected void setThis(JButton btn) {
        for (Component c : ((Container)this.topPanel.getComponent(0)).getComponents()) {
            if (!(c instanceof JButton)) continue;
            if (((JButton)c).equals(btn)) {
                btn.setEnabled(false);
                btn.setBorder(new LineBorder(Color.WHITE, 2));
                continue;
            }
            ((JButton)c).setBorder(null);
            ((JButton)c).setEnabled(true);
        }
        this.invalidate();
    }

    public void notifyCallback(CBK type, Object[] data) {
        if (!this.isVisible()) {
            return;
        }
        switch (type) {
            case STRUCTUREMODIFIED: {
                if (this.dialogMode != 'm') break;
                break;
            }
            case PICK: {
                String atomno;
                int atomIndex = (Integer)data[2];
                System.out.println("----" + type.toString() + ":  " + atomIndex);
                if (atomIndex == -3) {
                    atomno = data[1].toString();
                } else {
                    if (atomIndex < 0) break;
                    atomno = "" + (atomIndex + 1);
                }
                switch (this.dialogMode) {
                    case 'm': {
                        this.notifyPick_m(atomno);
                        return;
                    }
                    case 'v': {
                        this.notifyPick_v(atomno);
                        return;
                    }
                    case 's': {
                        this.notifyPick_s(atomno);
                        return;
                    }
                }
                break;
            }
            case LOADSTRUCT: {
                if (this.vwr.ms.ac == 0) {
                    return;
                }
                if (this.nboView) {
                    this.runScriptNow("select add {*}.bonds;color bonds lightgrey;wireframe 0.1;select remove {*}");
                }
                switch (this.dialogMode) {
                    case 'm': {
                        this.notifyLoad_m();
                        return;
                    }
                    case 'r': {
                        this.notifyLoad_r();
                        return;
                    }
                    case 'v': {
                        this.notifyLoad_v();
                        return;
                    }
                    case 's': {
                        this.notifyLoad_s();
                        return;
                    }
                }
            }
        }
    }

    void alert(String msg) {
        try {
            switch (this.dialogMode) {
                case 'm': 
                case 'r': 
                case 's': 
                case 'v': {
                    this.log(msg, 'b');
                }
            }
        }
        catch (Exception e) {
            this.alertError(msg);
        }
    }

    protected void clearOutput() {
        this.bodyText = "";
        String fontFamily = this.jpNBOLog.getFont().getFamily();
        this.jpNBOLog.setText("<html><body style=\"font-family: " + fontFamily + this.bodyText + "</html>");
    }

    protected boolean checkJmolNBO() {
        return this.vwr.ms.getInfo(this.vwr.am.cmi, "nboType") != null || NBOFileHandler.getExt(this.inputFileHandler.inputFile).equals("47");
    }

    public void setStatus(String statusInfo) {
        if (statusInfo.length() > 0) {
            this.log(statusInfo, 'p');
        }
        this.statusLab.setText(statusInfo);
    }

    public void processEnd(int dialogMode, DefaultComboBoxModel<String> list) {
        this.statusLab.setText("");
        switch (dialogMode) {
            case 88: {
                String fname = this.inputFileHandler.inputFile.getParent() + "\\" + this.inputFileHandler.jobStem + ".bmp";
                File f = new File(fname);
                SB title = new SB();
                String id = "id " + PT.esc(title.toString().trim());
                String script = "image " + id + " close;image id \"\" " + PT.esc(f.toString().replace('\\', '/'));
                this.runScriptNow(script);
                break;
            }
            case 20: {
                this.inputFileHandler.setInputFile(this.inputFileHandler.inputFile);
                break;
            }
            case 118: {
                if (list == null) break;
                this.setLastOrbitalSelection();
                break;
            }
            case 115: {
                if (list == null) break;
                this.setSearchList(list);
            }
        }
        this.setStatus("OK mode=" + dialogMode);
    }

    public void loadFromHandler(File file) {
        this.isNewJob = true;
        if (this.dialogMode == 'v') {
            this.setViewerBasis();
        } else {
            this.loadModelFileQueued(file, false, false);
        }
    }
}

