/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.coor;

import java.awt.geom.Area;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.gui.jmapviewer.interfaces.ICoordinate;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.Coordinate;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class LatLon
extends Coordinate {
    private static final long serialVersionUID = 1L;
    public static final double MAX_SERVER_PRECISION = 1.0E-7;
    public static final double MAX_SERVER_INV_PRECISION = 1.0E7;
    public static final LatLon ZERO = new LatLon(0.0, 0.0);
    public static final LatLon NORTH_POLE = new LatLon(90.0, 0.0);
    public static final LatLon SOUTH_POLE = new LatLon(-90.0, 0.0);
    private static DecimalFormat cDmsMinuteFormatter = new DecimalFormat("00");
    private static DecimalFormat cDmsSecondFormatter = new DecimalFormat(Main.pref == null ? "00.0" : Main.pref.get("latlon.dms.decimal-format", "00.0"));
    private static DecimalFormat cDmMinuteFormatter = new DecimalFormat(Main.pref == null ? "00.000" : Main.pref.get("latlon.dm.decimal-format", "00.000"));
    public static final DecimalFormat cDdFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
    public static final DecimalFormat cDdHighPecisionFormatter;
    private static final String cDms60;
    private static final String cDms00;
    private static final String cDm60;
    private static final String cDm00;
    public static final String SOUTH;
    public static final String NORTH;
    public static final String WEST;
    public static final String EAST;
    private static final char N_TR;
    private static final char S_TR;
    private static final char E_TR;
    private static final char W_TR;
    private static final String DEG = "\u00b0";
    private static final String MIN = "\u2032";
    private static final String SEC = "\u2033";
    private static final Pattern P;
    private static final Pattern P_XML;

    public static boolean isValidLat(double d) {
        return d >= -90.0 && d <= 90.0;
    }

    public static boolean isValidLon(double d) {
        return d >= -180.0 && d <= 180.0;
    }

    public static double normalizeLon(double d) {
        if (d >= -180.0 && d <= 180.0) {
            return d;
        }
        if ((d %= 360.0) > 180.0) {
            return d - 360.0;
        }
        if (d < -180.0) {
            return d + 360.0;
        }
        return d;
    }

    public boolean isValid() {
        return LatLon.isValidLat(this.lat()) && LatLon.isValidLon(this.lon());
    }

    public static double toIntervalLat(double d) {
        return Utils.clamp(d, -90.0, 90.0);
    }

    public static double toIntervalLon(double d) {
        if (LatLon.isValidLon(d)) {
            return d;
        }
        int n = (int)(d + Math.signum(d) * 180.0) / 360;
        return d - (double)n * 360.0;
    }

    public static String dms(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        int n2 = (int)d3;
        double d4 = (d3 - (double)n2) * 60.0;
        String string = Integer.toString(n);
        String string2 = cDmsMinuteFormatter.format(n2);
        String string3 = cDmsSecondFormatter.format(d4);
        if (cDms60.equals(string3)) {
            string3 = cDms00;
            string2 = cDmsMinuteFormatter.format((long)n2 + 1L);
        }
        if ("60".equals(string2)) {
            string2 = "00";
            string = Integer.toString(n + 1);
        }
        return string + '\u00b0' + string2 + '\'' + string3 + '\"';
    }

    public static String dm(double d) {
        double d2 = Math.abs(d);
        int n = (int)d2;
        double d3 = (d2 - (double)n) * 60.0;
        String string = Integer.toString(n);
        String string2 = cDmMinuteFormatter.format(d3);
        if (string2.equals(cDm60)) {
            string2 = cDm00;
            string = Integer.toString(n + 1);
        }
        return string + '\u00b0' + string2 + '\'';
    }

    public LatLon(double d, double d2) {
        super(d2, d);
    }

    protected LatLon(LatLon latLon) {
        super(latLon.lon(), latLon.lat());
    }

    public LatLon(ICoordinate iCoordinate) {
        this(iCoordinate.getLat(), iCoordinate.getLon());
    }

    public double lat() {
        return this.y;
    }

    public String latToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.y);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case NAUTICAL: {
                return LatLon.dm(this.y) + (this.y < 0.0 ? SOUTH : NORTH);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).north());
            }
        }
        return "ERR";
    }

    public double lon() {
        return this.x;
    }

    public String lonToString(CoordinateFormat coordinateFormat) {
        switch (coordinateFormat) {
            case DECIMAL_DEGREES: {
                return cDdFormatter.format(this.x);
            }
            case DEGREES_MINUTES_SECONDS: {
                return LatLon.dms(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case NAUTICAL: {
                return LatLon.dm(this.x) + (this.x < 0.0 ? WEST : EAST);
            }
            case EAST_NORTH: {
                return cDdFormatter.format(Main.getProjection().latlon2eastNorth(this).east());
            }
        }
        return "ERR";
    }

    public boolean equalsEpsilon(LatLon latLon) {
        double d = 5.0E-8;
        return Math.abs(this.lat() - latLon.lat()) <= d && Math.abs(this.lon() - latLon.lon()) <= d;
    }

    public boolean isOutSideWorld() {
        Bounds bounds = Main.getProjection().getWorldBoundsLatLon();
        return this.lat() < bounds.getMinLat() || this.lat() > bounds.getMaxLat() || this.lon() < bounds.getMinLon() || this.lon() > bounds.getMaxLon();
    }

    public boolean isWithin(Bounds bounds) {
        return bounds.contains(this);
    }

    public boolean isIn(Area area) {
        return area == null || area.contains(this.x, this.y);
    }

    public double greatCircleDistance(LatLon latLon) {
        double d = Math.sin(Math.toRadians(latLon.lat() - this.lat()) / 2.0);
        double d2 = Math.sin(Math.toRadians(latLon.lon() - this.lon()) / 2.0);
        double d3 = 2.0 * Ellipsoid.WGS84.a * Math.asin(Math.sqrt(d * d + Math.cos(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * d2 * d2));
        if (Double.isNaN(d3)) {
            Main.error("NaN in greatCircleDistance");
            d3 = Math.PI * Ellipsoid.WGS84.a;
        }
        return d3;
    }

    @Deprecated
    public double heading(LatLon latLon) {
        double d = Math.atan2(Math.sin(Math.toRadians(this.lon() - latLon.lon())) * Math.cos(Math.toRadians(latLon.lat())), Math.cos(Math.toRadians(this.lat())) * Math.sin(Math.toRadians(latLon.lat())) - Math.sin(Math.toRadians(this.lat())) * Math.cos(Math.toRadians(latLon.lat())) * Math.cos(Math.toRadians(this.lon() - latLon.lon())));
        if ((d %= Math.PI * 2) < 0.0) {
            d += Math.PI * 2;
        }
        return d;
    }

    public double bearing(LatLon latLon) {
        double d = Math.toRadians(this.lat());
        double d2 = Math.toRadians(latLon.lat());
        double d3 = Math.toRadians(latLon.lon() - this.lon());
        double d4 = Math.atan2(Math.sin(d3) * Math.cos(d2), Math.cos(d) * Math.sin(d2) - Math.sin(d) * Math.cos(d2) * Math.cos(d3));
        if ((d4 %= Math.PI * 2) < 0.0) {
            d4 += Math.PI * 2;
        }
        return d4;
    }

    public String toDisplayString() {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(5);
        return "lat=" + numberFormat.format(this.lat()) + "\u00b0, lon=" + numberFormat.format(this.lon()) + '\u00b0';
    }

    public String toStringCSV(String string) {
        return Utils.join(string, Arrays.asList(this.latToString(CoordinateFormat.DECIMAL_DEGREES), this.lonToString(CoordinateFormat.DECIMAL_DEGREES)));
    }

    public LatLon interpolate(LatLon latLon, double d) {
        return new LatLon((1.0 - d) * this.lat() + d * latLon.lat(), (1.0 - d) * this.lon() + d * latLon.lon());
    }

    public LatLon getCenter(LatLon latLon) {
        return this.interpolate(latLon, 0.5);
    }

    public double distance(LatLon latLon) {
        return super.distance(latLon);
    }

    public double distanceSq(LatLon latLon) {
        return super.distanceSq(latLon);
    }

    public String toString() {
        return "LatLon[lat=" + this.lat() + ",lon=" + this.lon() + ']';
    }

    public static double roundToOsmPrecision(double d) {
        return (double)Math.round(d * 1.0E7) / 1.0E7;
    }

    public LatLon getRoundedToOsmPrecision() {
        return new LatLon(LatLon.roundToOsmPrecision(this.lat()), LatLon.roundToOsmPrecision(this.lon()));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        LatLon latLon = (LatLon)object;
        return Double.compare(latLon.x, this.x) == 0 && Double.compare(latLon.y, this.y) == 0;
    }

    public ICoordinate toCoordinate() {
        return new org.openstreetmap.gui.jmapviewer.Coordinate(this.lat(), this.lon());
    }

    private static void setLatLonObj(LatLonHolder latLonHolder, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        LatLon.setLatLon(latLonHolder, (Double)object, (Double)object2, (Double)object3, (String)object4, (Double)object5, (Double)object6, (Double)object7, (String)object8);
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string, double d4, double d5, double d6, String string2) {
        LatLon.setLatLon(latLonHolder, d, d2, d3, string);
        LatLon.setLatLon(latLonHolder, d4, d5, d6, string2);
        if (Double.isNaN(latLonHolder.lat) || Double.isNaN(latLonHolder.lon)) {
            throw new IllegalArgumentException("invalid lat/lon parameters");
        }
    }

    private static void setLatLon(LatLonHolder latLonHolder, double d, double d2, double d3, String string) {
        if (d < -180.0 || d > 180.0 || d2 < 0.0 || d2 >= 60.0 || d3 < 0.0 || d3 > 60.0) {
            throw new IllegalArgumentException("out of range");
        }
        double d4 = (double)(d < 0.0 ? -1 : 1) * (Math.abs(d) + d2 / 60.0 + d3 / 3600.0);
        double d5 = d4 = "N".equals(string) || "E".equals(string) ? d4 : -d4;
        if ("N".equals(string) || "S".equals(string)) {
            latLonHolder.lat = d4;
        } else {
            latLonHolder.lon = d4;
        }
    }

    public static LatLon parse(String string) {
        LatLonHolder latLonHolder = new LatLonHolder();
        Matcher matcher = P_XML.matcher(string);
        if (matcher.matches()) {
            LatLon.setLatLonObj(latLonHolder, Double.valueOf(matcher.group(1).replace(',', '.')), 0.0, 0.0, "N", Double.valueOf(matcher.group(2).replace(',', '.')), 0.0, 0.0, "E");
        } else {
            String string2;
            Matcher matcher2 = P.matcher(string);
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (matcher2.find()) {
                if (matcher2.group(1) != null) {
                    stringBuilder.append('R');
                    arrayList.add(Double.valueOf(matcher2.group(1).replace(',', '.')));
                    continue;
                }
                if (matcher2.group(2) != null) {
                    stringBuilder.append('Z');
                    arrayList.add(Double.valueOf(matcher2.group(2)));
                    continue;
                }
                if (matcher2.group(3) != null) {
                    stringBuilder.append('o');
                    continue;
                }
                if (matcher2.group(4) != null) {
                    stringBuilder.append('\'');
                    continue;
                }
                if (matcher2.group(5) != null) {
                    stringBuilder.append('\"');
                    continue;
                }
                if (matcher2.group(6) != null) {
                    stringBuilder.append(',');
                    continue;
                }
                if (matcher2.group(7) != null) {
                    stringBuilder.append('x');
                    string2 = matcher2.group(7).toUpperCase(Locale.ENGLISH);
                    if ("N".equalsIgnoreCase(string2) || "S".equalsIgnoreCase(string2) || "E".equalsIgnoreCase(string2) || "W".equalsIgnoreCase(string2)) {
                        arrayList.add(string2);
                        continue;
                    }
                    arrayList.add(string2.replace(N_TR, 'N').replace(S_TR, 'S').replace(E_TR, 'E').replace(W_TR, 'W'));
                    continue;
                }
                if (matcher2.group(8) == null) continue;
                throw new IllegalArgumentException("invalid token: " + matcher2.group(8));
            }
            string2 = stringBuilder.toString();
            Object[] objectArray = arrayList.toArray();
            if (string2.matches("Ro?,?Ro?")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, "N", objectArray[1], 0.0, 0.0, "E");
            } else if (string2.matches("xRo?,?xRo?")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[1], 0.0, 0.0, objectArray[0], objectArray[3], 0.0, 0.0, objectArray[2]);
            } else if (string2.matches("Ro?x,?Ro?x")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], 0.0, 0.0, objectArray[1], objectArray[2], 0.0, 0.0, objectArray[3]);
            } else if (string2.matches("Zo[RZ]'?,?Zo[RZ]'?|Z[RZ],?Z[RZ]")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, "N", objectArray[2], objectArray[3], 0.0, "E");
            } else if (string2.matches("xZo[RZ]'?,?xZo[RZ]'?|xZo?[RZ],?xZo?[RZ]")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], 0.0, objectArray[0], objectArray[4], objectArray[5], 0.0, objectArray[3]);
            } else if (string2.matches("Zo[RZ]'?x,?Zo[RZ]'?x|Zo?[RZ]x,?Zo?[RZ]x")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], 0.0, objectArray[2], objectArray[3], objectArray[4], 0.0, objectArray[5]);
            } else if (string2.matches("ZoZ'[RZ]\"?x,?ZoZ'[RZ]\"?x|ZZ[RZ]x,?ZZ[RZ]x")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], objectArray[3], objectArray[4], objectArray[5], objectArray[6], objectArray[7]);
            } else if (string2.matches("xZoZ'[RZ]\"?,?xZoZ'[RZ]\"?|xZZ[RZ],?xZZ[RZ]")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[1], objectArray[2], objectArray[3], objectArray[0], objectArray[5], objectArray[6], objectArray[7], objectArray[4]);
            } else if (string2.matches("ZZ[RZ],?ZZ[RZ]")) {
                LatLon.setLatLonObj(latLonHolder, objectArray[0], objectArray[1], objectArray[2], "N", objectArray[3], objectArray[4], objectArray[5], "E");
            } else {
                throw new IllegalArgumentException("invalid format: " + string2);
            }
        }
        return new LatLon(latLonHolder.lat, latLonHolder.lon);
    }

    static {
        cDdFormatter.applyPattern("###0.0######");
        cDdHighPecisionFormatter = (DecimalFormat)NumberFormat.getInstance(Locale.UK);
        cDdHighPecisionFormatter.applyPattern("###0.0##########");
        cDms60 = cDmsSecondFormatter.format(60.0);
        cDms00 = cDmsSecondFormatter.format(0.0);
        cDm60 = cDmMinuteFormatter.format(60.0);
        cDm00 = cDmMinuteFormatter.format(0.0);
        SOUTH = I18n.trc("compass", "S");
        NORTH = I18n.trc("compass", "N");
        WEST = I18n.trc("compass", "W");
        EAST = I18n.trc("compass", "E");
        N_TR = NORTH.charAt(0);
        S_TR = SOUTH.charAt(0);
        E_TR = EAST.charAt(0);
        W_TR = WEST.charAt(0);
        P = Pattern.compile("([+|-]?\\d+[.,]\\d+)|([+|-]?\\d+)|(\u00b0|o|deg)|('|\u2032|min)|(\"|\u2033|sec)|(,|;)|([NSEW" + N_TR + S_TR + E_TR + W_TR + "])|\\s+|(.+)", 2);
        P_XML = Pattern.compile("lat=[\"']([+|-]?\\d+[.,]\\d+)[\"']\\s+lon=[\"']([+|-]?\\d+[.,]\\d+)[\"']");
    }

    private static class LatLonHolder {
        private double lat = Double.NaN;
        private double lon = Double.NaN;

        private LatLonHolder() {
        }
    }
}

